/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.TypedString;
import com.opengamma.strata.collect.named.Described;
import org.joda.convert.FromString;

public final class ProductType
extends TypedString<ProductType>
implements Described {
    public static final ProductType BULLET_PAYMENT = ProductType.of("BulletPayment", "Payment");
    public static final ProductType BILL = ProductType.of("Bill");
    public static final ProductType BOND = ProductType.of("Bond");
    public static final ProductType BOND_FUTURE = ProductType.of("BondFuture", "Bond Future");
    public static final ProductType BOND_FUTURE_OPTION = ProductType.of("BondFutureOption", "Bond Future Option");
    public static final ProductType CDS = ProductType.of("Cds", "CDS");
    public static final ProductType CDS_INDEX = ProductType.of("Cds Index", "CDS Index");
    public static final ProductType CMS = ProductType.of("Cms", "CMS");
    public static final ProductType DSF = ProductType.of("Dsf", "DSF");
    public static final ProductType FRA = ProductType.of("Fra", "FRA");
    public static final ProductType FX_NDF = ProductType.of("FxNdf", "FX NDF");
    public static final ProductType FX_SINGLE_BARRIER_OPTION = ProductType.of("FxSingleBarrierOption", "FX Single Barrier Option");
    public static final ProductType FX_SINGLE = ProductType.of("FxSingle", "FX");
    public static final ProductType FX_SWAP = ProductType.of("FxSwap", "FX Swap");
    public static final ProductType FX_VANILLA_OPTION = ProductType.of("FxVanillaOption", "FX Vanilla Option");
    public static final ProductType IBOR_CAP_FLOOR = ProductType.of("IborCapFloor", "Cap/Floor");
    public static final ProductType IBOR_FUTURE = ProductType.of("IborFuture", "STIR Future");
    public static final ProductType IBOR_FUTURE_OPTION = ProductType.of("IborFutureOption", "STIR Future Option");
    public static final ProductType OVERNIGHT_FUTURE = ProductType.of("OvernightFuture", "Overnight Future");
    public static final ProductType OVERNIGHT_FUTURE_OPTION = ProductType.of("OvernightFutureOption", "Overnight Future Option");
    public static final ProductType SENSITIVITIES = ProductType.of("Sensitivities");
    public static final ProductType SWAP = ProductType.of("Swap");
    public static final ProductType SWAPTION = ProductType.of("Swaption");
    public static final ProductType TERM_DEPOSIT = ProductType.of("TermDeposit", "Deposit");
    public static final ProductType ETD_FUTURE = ProductType.of("EtdFuture", "ETD Future");
    public static final ProductType ETD_OPTION = ProductType.of("EtdOption", "ETD Option");
    public static final ProductType SECURITY = ProductType.of("Security");
    public static final ProductType CALIBRATION = ProductType.of("Calibration");
    public static final ProductType OTHER = ProductType.of("Other");
    private static final long serialVersionUID = 1L;
    private final String description;

    @FromString
    public static ProductType of(String name) {
        return new ProductType(name, name);
    }

    private static ProductType of(String name, String description) {
        return new ProductType(name, description);
    }

    private ProductType(String name, String description) {
        super(name);
        this.description = ArgChecker.notBlank((String)description, (String)"description");
    }

    public String getDescription() {
        return this.description;
    }
}

