/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.ResolvableCalculationTarget;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.SecuritizedProductTrade;
import com.opengamma.strata.product.Security;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityQuantityTrade;

public interface ResolvableSecurityTrade
extends SecurityQuantityTrade,
ResolvableCalculationTarget {
    default public SecuritizedProductTrade<?> resolveTarget(ReferenceData refData) {
        SecurityId securityId = this.getSecurityId();
        Security security = (Security)refData.getValue((ReferenceDataId)securityId);
        SecurityQuantityTrade trade = security.createTrade(this.getInfo(), this.getQuantity(), this.getPrice(), refData);
        if (trade instanceof SecuritizedProductTrade) {
            return (SecuritizedProductTrade)trade;
        }
        throw new ClassCastException(Messages.format((String)"Reference data for security '{}' did not implement SecuritizedProductTrade: ", (Object[])new Object[]{securityId, trade.getClass().getName()}));
    }

    @Override
    public ResolvableSecurityTrade withInfo(PortfolioItemInfo var1);

    @Override
    public ResolvableSecurityTrade withQuantity(double var1);

    @Override
    public ResolvableSecurityTrade withPrice(double var1);
}

