/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.Attributes;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfoBuilder;
import com.opengamma.strata.product.SecurityPriceInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class SecurityInfo
implements Attributes,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SecurityId id;
    @PropertyDefinition(validate="notNull")
    private final SecurityPriceInfo priceInfo;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<AttributeType<?>, Object> attributes;
    private static final long serialVersionUID = 1L;

    public static SecurityInfo of(SecurityId id, double tickSize, CurrencyAmount tickValue) {
        return new SecurityInfo(id, SecurityPriceInfo.of(tickSize, tickValue), (Map<AttributeType<?>, Object>)ImmutableMap.of());
    }

    public static SecurityInfo of(SecurityId id, SecurityPriceInfo priceInfo) {
        return new SecurityInfo(id, priceInfo, (Map<AttributeType<?>, Object>)ImmutableMap.of());
    }

    public static SecurityInfoBuilder builder() {
        return new SecurityInfoBuilder();
    }

    @Override
    public ImmutableSet<AttributeType<?>> getAttributeTypes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> Optional<T> findAttribute(AttributeType<T> type) {
        return Optional.ofNullable(type.fromStoredForm(this.attributes.get(type)));
    }

    @Override
    public <T> SecurityInfo withAttribute(AttributeType<T> type, T value) {
        HashMap updatedAttributes = new HashMap((Map<AttributeType<?>, Object>)this.attributes);
        if (value == null) {
            updatedAttributes.remove(type);
        } else {
            updatedAttributes.put(type, type.toStoredForm(value));
        }
        return new SecurityInfo(this.id, this.priceInfo, updatedAttributes);
    }

    @Override
    public SecurityInfo withAttributes(Attributes other) {
        SecurityInfoBuilder builder = this.toBuilder();
        for (AttributeType attrType : other.getAttributeTypes()) {
            builder.addAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return builder.build();
    }

    public SecurityInfoBuilder toBuilder() {
        return new SecurityInfoBuilder(this.id, this.priceInfo, (Map<AttributeType<?>, Object>)this.attributes);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    SecurityInfo(SecurityId id, SecurityPriceInfo priceInfo, Map<AttributeType<?>, Object> attributes) {
        JodaBeanUtils.notNull((Object)id, (String)"id");
        JodaBeanUtils.notNull((Object)priceInfo, (String)"priceInfo");
        JodaBeanUtils.notNull(attributes, (String)"attributes");
        this.id = id;
        this.priceInfo = priceInfo;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public SecurityId getId() {
        return this.id;
    }

    public SecurityPriceInfo getPriceInfo() {
        return this.priceInfo;
    }

    public ImmutableMap<AttributeType<?>, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SecurityInfo other = (SecurityInfo)obj;
            return JodaBeanUtils.equal((Object)this.id, (Object)other.id) && JodaBeanUtils.equal((Object)this.priceInfo, (Object)other.priceInfo) && JodaBeanUtils.equal(this.attributes, other.attributes);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.id);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.priceInfo);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.attributes);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("SecurityInfo{");
        buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
        buf.append("priceInfo").append('=').append(JodaBeanUtils.toString((Object)this.priceInfo)).append(',').append(' ');
        buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SecurityInfo> {
        private SecurityId id;
        private SecurityPriceInfo priceInfo;
        private Map<AttributeType<?>, Object> attributes = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case -2126070377: {
                    return this.priceInfo;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (SecurityId)newValue;
                    break;
                }
                case -2126070377: {
                    this.priceInfo = (SecurityPriceInfo)newValue;
                    break;
                }
                case 405645655: {
                    this.attributes = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SecurityInfo build() {
            return new SecurityInfo(this.id, this.priceInfo, this.attributes);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("SecurityInfo.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("priceInfo").append('=').append(JodaBeanUtils.toString((Object)this.priceInfo)).append(',').append(' ');
            buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> id = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"id", SecurityInfo.class, SecurityId.class);
        private final MetaProperty<SecurityPriceInfo> priceInfo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"priceInfo", SecurityInfo.class, SecurityPriceInfo.class);
        private final MetaProperty<ImmutableMap<AttributeType<?>, Object>> attributes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"attributes", SecurityInfo.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"id", "priceInfo", "attributes"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case -2126070377: {
                    return this.priceInfo;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SecurityInfo> builder() {
            return new Builder();
        }

        public Class<? extends SecurityInfo> beanType() {
            return SecurityInfo.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> id() {
            return this.id;
        }

        public MetaProperty<SecurityPriceInfo> priceInfo() {
            return this.priceInfo;
        }

        public MetaProperty<ImmutableMap<AttributeType<?>, Object>> attributes() {
            return this.attributes;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return ((SecurityInfo)bean).getId();
                }
                case -2126070377: {
                    return ((SecurityInfo)bean).getPriceInfo();
                }
                case 405645655: {
                    return ((SecurityInfo)bean).getAttributes();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

