/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.SecurityPriceInfo;
import java.util.HashMap;
import java.util.Map;

public final class SecurityInfoBuilder {
    private SecurityId id;
    private SecurityPriceInfo priceInfo;
    private final Map<AttributeType<?>, Object> attributes = new HashMap();

    SecurityInfoBuilder() {
    }

    SecurityInfoBuilder(SecurityId id, SecurityPriceInfo priceInfo, Map<AttributeType<?>, Object> attributes) {
        this.id = id;
        this.priceInfo = priceInfo;
        this.attributes.putAll(attributes);
    }

    public SecurityInfoBuilder id(SecurityId id) {
        this.id = (SecurityId)ArgChecker.notNull((Object)id, (String)"id");
        return this;
    }

    public SecurityInfoBuilder priceInfo(SecurityPriceInfo priceInfo) {
        this.priceInfo = (SecurityPriceInfo)ArgChecker.notNull((Object)priceInfo, (String)"priceInfo");
        return this;
    }

    public <T> SecurityInfoBuilder addAttribute(AttributeType<T> attributeType, T attributeValue) {
        ArgChecker.notNull(attributeType, (String)"attributeType");
        ArgChecker.notNull(attributeValue, (String)"attributeValue");
        this.attributes.put(attributeType, attributeType.toStoredForm(attributeValue));
        return this;
    }

    public SecurityInfo build() {
        return new SecurityInfo(this.id, this.priceInfo, this.attributes);
    }
}

