/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.Position;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.ResolvableSecurityPosition;
import com.opengamma.strata.product.SecuritizedProductPosition;
import com.opengamma.strata.product.Security;
import com.opengamma.strata.product.SecurityId;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class SecurityPosition
implements ResolvableSecurityPosition,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PositionInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityId securityId;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double longQuantity;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double shortQuantity;
    private static final long serialVersionUID = 1L;

    public static SecurityPosition ofNet(SecurityId securityId, double netQuantity) {
        return SecurityPosition.ofNet(PositionInfo.empty(), securityId, netQuantity);
    }

    public static SecurityPosition ofNet(PositionInfo positionInfo, SecurityId securityId, double netQuantity) {
        double longQuantity = netQuantity >= 0.0 ? netQuantity : 0.0;
        double shortQuantity = netQuantity >= 0.0 ? 0.0 : -netQuantity;
        return new SecurityPosition(positionInfo, securityId, longQuantity, shortQuantity);
    }

    public static SecurityPosition ofLongShort(SecurityId securityId, double longQuantity, double shortQuantity) {
        return SecurityPosition.ofLongShort(PositionInfo.empty(), securityId, longQuantity, shortQuantity);
    }

    public static SecurityPosition ofLongShort(PositionInfo positionInfo, SecurityId securityId, double longQuantity, double shortQuantity) {
        return new SecurityPosition(positionInfo, securityId, longQuantity, shortQuantity);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = PositionInfo.empty();
    }

    @Override
    @DerivedProperty
    public double getQuantity() {
        return this.longQuantity - this.shortQuantity;
    }

    @Override
    public SecurityPosition withInfo(PortfolioItemInfo info) {
        return new SecurityPosition(PositionInfo.from(info), this.securityId, this.longQuantity, this.shortQuantity);
    }

    @Override
    public SecurityPosition withQuantity(double quantity) {
        return SecurityPosition.ofNet(this.info, this.securityId, quantity);
    }

    @Override
    public SecuritizedProductPosition<?> resolveTarget(ReferenceData refData) {
        SecurityId securityId = this.getSecurityId();
        Security security = (Security)refData.getValue((ReferenceDataId)securityId);
        Position position = security.createPosition(this.getInfo(), this.getLongQuantity(), this.getShortQuantity(), refData);
        if (position instanceof SecuritizedProductPosition) {
            return (SecuritizedProductPosition)position;
        }
        throw new ClassCastException(Messages.format((String)"Reference data for security '{}' did not implement SecuritizedProductPosition: ", (Object[])new Object[]{securityId, position.getClass().getName()}));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    SecurityPosition(PositionInfo info, SecurityId securityId, double longQuantity, double shortQuantity) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        ArgChecker.notNegative((double)longQuantity, (String)"longQuantity");
        ArgChecker.notNegative((double)shortQuantity, (String)"shortQuantity");
        this.info = info;
        this.securityId = securityId;
        this.longQuantity = longQuantity;
        this.shortQuantity = shortQuantity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PositionInfo getInfo() {
        return this.info;
    }

    @Override
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public double getLongQuantity() {
        return this.longQuantity;
    }

    public double getShortQuantity() {
        return this.shortQuantity;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SecurityPosition other = (SecurityPosition)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((double)this.longQuantity, (double)other.longQuantity) && JodaBeanUtils.equal((double)this.shortQuantity, (double)other.shortQuantity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.longQuantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.shortQuantity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("SecurityPosition{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("longQuantity").append('=').append(JodaBeanUtils.toString((Object)this.longQuantity)).append(',').append(' ');
        buf.append("shortQuantity").append('=').append(JodaBeanUtils.toString((Object)this.shortQuantity)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.getQuantity()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SecurityPosition> {
        private PositionInfo info;
        private SecurityId securityId;
        private double longQuantity;
        private double shortQuantity;

        private Builder() {
            SecurityPosition.applyDefaults(this);
        }

        private Builder(SecurityPosition beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.securityId = beanToCopy.getSecurityId();
            this.longQuantity = beanToCopy.getLongQuantity();
            this.shortQuantity = beanToCopy.getShortQuantity();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1574023291: {
                    return this.securityId;
                }
                case 611668775: {
                    return this.longQuantity;
                }
                case -2094395097: {
                    return this.shortQuantity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (PositionInfo)newValue;
                    break;
                }
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case 611668775: {
                    this.longQuantity = (Double)newValue;
                    break;
                }
                case -2094395097: {
                    this.shortQuantity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SecurityPosition build() {
            return new SecurityPosition(this.info, this.securityId, this.longQuantity, this.shortQuantity);
        }

        public Builder info(PositionInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder longQuantity(double longQuantity) {
            ArgChecker.notNegative((double)longQuantity, (String)"longQuantity");
            this.longQuantity = longQuantity;
            return this;
        }

        public Builder shortQuantity(double shortQuantity) {
            ArgChecker.notNegative((double)shortQuantity, (String)"shortQuantity");
            this.shortQuantity = shortQuantity;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("SecurityPosition.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("longQuantity").append('=').append(JodaBeanUtils.toString((Object)this.longQuantity)).append(',').append(' ');
            buf.append("shortQuantity").append('=').append(JodaBeanUtils.toString((Object)this.shortQuantity)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PositionInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", SecurityPosition.class, PositionInfo.class);
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", SecurityPosition.class, SecurityId.class);
        private final MetaProperty<Double> longQuantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longQuantity", SecurityPosition.class, Double.TYPE);
        private final MetaProperty<Double> shortQuantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shortQuantity", SecurityPosition.class, Double.TYPE);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofDerived((MetaBean)this, (String)"quantity", SecurityPosition.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "securityId", "longQuantity", "shortQuantity", "quantity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1574023291: {
                    return this.securityId;
                }
                case 611668775: {
                    return this.longQuantity;
                }
                case -2094395097: {
                    return this.shortQuantity;
                }
                case -1285004149: {
                    return this.quantity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SecurityPosition> beanType() {
            return SecurityPosition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PositionInfo> info() {
            return this.info;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<Double> longQuantity() {
            return this.longQuantity;
        }

        public MetaProperty<Double> shortQuantity() {
            return this.shortQuantity;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((SecurityPosition)bean).getInfo();
                }
                case 1574023291: {
                    return ((SecurityPosition)bean).getSecurityId();
                }
                case 611668775: {
                    return ((SecurityPosition)bean).getLongQuantity();
                }
                case -2094395097: {
                    return ((SecurityPosition)bean).getShortQuantity();
                }
                case -1285004149: {
                    return ((SecurityPosition)bean).getQuantity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

