/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SecurityPriceInfo
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double tickSize;
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmount tickValue;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double contractSize;
    private final transient double tradeUnitValue;
    private static final long serialVersionUID = 1L;

    public static SecurityPriceInfo of(double tickSize, CurrencyAmount tickValue) {
        return new SecurityPriceInfo(tickSize, tickValue, 1.0);
    }

    public static SecurityPriceInfo of(double tickSize, CurrencyAmount tickValue, double contractSize) {
        return new SecurityPriceInfo(tickSize, tickValue, contractSize);
    }

    public static SecurityPriceInfo of(Currency currency, double tradeUnitValue) {
        return new SecurityPriceInfo(1.0, CurrencyAmount.of((Currency)currency, (double)1.0), tradeUnitValue);
    }

    public static SecurityPriceInfo ofCurrencyMinorUnit(Currency currency) {
        int digits = currency.getMinorUnitDigits();
        double unitAmount = Math.pow(10.0, -digits);
        return new SecurityPriceInfo(unitAmount, CurrencyAmount.of((Currency)currency, (double)unitAmount), 1.0);
    }

    @ImmutableConstructor
    private SecurityPriceInfo(double tickSize, CurrencyAmount tickValue, double contractSize) {
        ArgChecker.notNegativeOrZero((double)tickSize, (String)"tickSize");
        JodaBeanUtils.notNull((Object)tickValue, (String)"tickValue");
        ArgChecker.notNegativeOrZero((double)contractSize, (String)"contractSize");
        this.tickSize = tickSize;
        this.tickValue = tickValue;
        this.contractSize = contractSize;
        this.tradeUnitValue = tickValue.getAmount() * contractSize / tickSize;
    }

    private Object readResolve() {
        return new SecurityPriceInfo(this.tickSize, this.tickValue, this.contractSize);
    }

    @DerivedProperty
    public Currency getCurrency() {
        return this.tickValue.getCurrency();
    }

    public CurrencyAmount calculateMonetaryAmount(double quantity, double price) {
        return CurrencyAmount.of((Currency)this.tickValue.getCurrency(), (double)this.calculateMonetaryValue(quantity, price));
    }

    public double calculateMonetaryValue(double quantity, double price) {
        return price * quantity * this.tradeUnitValue;
    }

    public double getTradeUnitValue() {
        return this.tradeUnitValue;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getTickSize() {
        return this.tickSize;
    }

    public CurrencyAmount getTickValue() {
        return this.tickValue;
    }

    public double getContractSize() {
        return this.contractSize;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SecurityPriceInfo other = (SecurityPriceInfo)obj;
            return JodaBeanUtils.equal((double)this.tickSize, (double)other.tickSize) && JodaBeanUtils.equal((Object)this.tickValue, (Object)other.tickValue) && JodaBeanUtils.equal((double)this.contractSize, (double)other.contractSize);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.tickSize);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tickValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.contractSize);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SecurityPriceInfo{");
        buf.append("tickSize").append('=').append(JodaBeanUtils.toString((Object)this.tickSize)).append(',').append(' ');
        buf.append("tickValue").append('=').append(JodaBeanUtils.toString((Object)this.tickValue)).append(',').append(' ');
        buf.append("contractSize").append('=').append(JodaBeanUtils.toString((Object)this.contractSize)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.getCurrency()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SecurityPriceInfo> {
        private double tickSize;
        private CurrencyAmount tickValue;
        private double contractSize;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1936822078: {
                    return this.tickSize;
                }
                case -85538348: {
                    return this.tickValue;
                }
                case -1402368973: {
                    return this.contractSize;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1936822078: {
                    this.tickSize = (Double)newValue;
                    break;
                }
                case -85538348: {
                    this.tickValue = (CurrencyAmount)newValue;
                    break;
                }
                case -1402368973: {
                    this.contractSize = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SecurityPriceInfo build() {
            return new SecurityPriceInfo(this.tickSize, this.tickValue, this.contractSize);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("SecurityPriceInfo.Builder{");
            buf.append("tickSize").append('=').append(JodaBeanUtils.toString((Object)this.tickSize)).append(',').append(' ');
            buf.append("tickValue").append('=').append(JodaBeanUtils.toString((Object)this.tickValue)).append(',').append(' ');
            buf.append("contractSize").append('=').append(JodaBeanUtils.toString((Object)this.contractSize)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> tickSize = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tickSize", SecurityPriceInfo.class, Double.TYPE);
        private final MetaProperty<CurrencyAmount> tickValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tickValue", SecurityPriceInfo.class, CurrencyAmount.class);
        private final MetaProperty<Double> contractSize = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"contractSize", SecurityPriceInfo.class, Double.TYPE);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofDerived((MetaBean)this, (String)"currency", SecurityPriceInfo.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"tickSize", "tickValue", "contractSize", "currency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1936822078: {
                    return this.tickSize;
                }
                case -85538348: {
                    return this.tickValue;
                }
                case -1402368973: {
                    return this.contractSize;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SecurityPriceInfo> builder() {
            return new Builder();
        }

        public Class<? extends SecurityPriceInfo> beanType() {
            return SecurityPriceInfo.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> tickSize() {
            return this.tickSize;
        }

        public MetaProperty<CurrencyAmount> tickValue() {
            return this.tickValue;
        }

        public MetaProperty<Double> contractSize() {
            return this.contractSize;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1936822078: {
                    return ((SecurityPriceInfo)bean).getTickSize();
                }
                case -85538348: {
                    return ((SecurityPriceInfo)bean).getTickValue();
                }
                case -1402368973: {
                    return ((SecurityPriceInfo)bean).getContractSize();
                }
                case 575402001: {
                    return ((SecurityPriceInfo)bean).getCurrency();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

