/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.ResolvableSecurityTrade;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.SummarizerUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class SecurityTrade
implements ResolvableSecurityTrade,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TradeInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityId securityId;
    @PropertyDefinition(overrideGet=true)
    private final double quantity;
    @PropertyDefinition(overrideGet=true)
    private final double price;
    private static final long serialVersionUID = 1L;

    public static SecurityTrade of(TradeInfo tradeInfo, SecurityId securityId, double quantity, double price) {
        return new SecurityTrade(tradeInfo, securityId, quantity, price);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    @Override
    public PortfolioItemSummary summarize() {
        String description = this.getSecurityId().getStandardId().getValue() + " x " + SummarizerUtils.value(this.getQuantity());
        return SummarizerUtils.summary(this, ProductType.SECURITY, description, new Currency[0]);
    }

    @Override
    public SecurityTrade withInfo(PortfolioItemInfo info) {
        return new SecurityTrade(TradeInfo.from(info), this.securityId, this.quantity, this.price);
    }

    @Override
    public SecurityTrade withQuantity(double quantity) {
        return new SecurityTrade(this.info, this.securityId, quantity, this.price);
    }

    @Override
    public SecurityTrade withPrice(double price) {
        return new SecurityTrade(this.info, this.securityId, this.quantity, price);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    SecurityTrade(TradeInfo info, SecurityId securityId, double quantity, double price) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        this.info = info;
        this.securityId = securityId;
        this.quantity = quantity;
        this.price = price;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public TradeInfo getInfo() {
        return this.info;
    }

    @Override
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    @Override
    public double getQuantity() {
        return this.quantity;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SecurityTrade other = (SecurityTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((double)this.quantity, (double)other.quantity) && JodaBeanUtils.equal((double)this.price, (double)other.price);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.quantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.price);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SecurityTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
        buf.append("price").append('=').append(JodaBeanUtils.toString((Object)this.price));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SecurityTrade> {
        private TradeInfo info;
        private SecurityId securityId;
        private double quantity;
        private double price;

        private Builder() {
            SecurityTrade.applyDefaults(this);
        }

        private Builder(SecurityTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.securityId = beanToCopy.getSecurityId();
            this.quantity = beanToCopy.getQuantity();
            this.price = beanToCopy.getPrice();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1574023291: {
                    return this.securityId;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 106934601: {
                    return this.price;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (TradeInfo)newValue;
                    break;
                }
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case -1285004149: {
                    this.quantity = (Double)newValue;
                    break;
                }
                case 106934601: {
                    this.price = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SecurityTrade build() {
            return new SecurityTrade(this.info, this.securityId, this.quantity, this.price);
        }

        public Builder info(TradeInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder price(double price) {
            this.price = price;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("SecurityTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
            buf.append("price").append('=').append(JodaBeanUtils.toString((Object)this.price));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<TradeInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", SecurityTrade.class, TradeInfo.class);
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", SecurityTrade.class, SecurityId.class);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quantity", SecurityTrade.class, Double.TYPE);
        private final MetaProperty<Double> price = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"price", SecurityTrade.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "securityId", "quantity", "price"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1574023291: {
                    return this.securityId;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 106934601: {
                    return this.price;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SecurityTrade> beanType() {
            return SecurityTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<TradeInfo> info() {
            return this.info;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        public MetaProperty<Double> price() {
            return this.price;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((SecurityTrade)bean).getInfo();
                }
                case 1574023291: {
                    return ((SecurityTrade)bean).getSecurityId();
                }
                case -1285004149: {
                    return ((SecurityTrade)bean).getQuantity();
                }
                case 106934601: {
                    return ((SecurityTrade)bean).getPrice();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

