/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.Attributes;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class SimpleAttributes
implements Attributes,
ImmutableBean,
Serializable {
    private static final SimpleAttributes EMPTY = new SimpleAttributes((Map<AttributeType<?>, Object>)ImmutableMap.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<AttributeType<?>, Object> attributes;
    private static final TypedMetaBean<SimpleAttributes> META_BEAN = LightMetaBean.of(SimpleAttributes.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"attributes"}, (Object[])new Object[]{ImmutableMap.of()});
    private static final long serialVersionUID = 1L;

    public static SimpleAttributes empty() {
        return EMPTY;
    }

    public static <T> SimpleAttributes of(AttributeType<T> type, T value) {
        return new SimpleAttributes((Map<AttributeType<?>, Object>)ImmutableMap.of(type, (Object)type.toStoredForm(value)));
    }

    public static SimpleAttributes from(Attributes other) {
        if (other instanceof SimpleAttributes) {
            return (SimpleAttributes)other;
        }
        return SimpleAttributes.empty().withAttributes(other);
    }

    @Override
    public ImmutableSet<AttributeType<?>> getAttributeTypes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> Optional<T> findAttribute(AttributeType<T> type) {
        return Optional.ofNullable(type.fromStoredForm(this.attributes.get(type)));
    }

    @Override
    public <T> SimpleAttributes withAttribute(AttributeType<T> type, T value) {
        HashMap updatedAttributes = new HashMap((Map<AttributeType<?>, Object>)this.attributes);
        if (value == null) {
            updatedAttributes.remove(type);
        } else {
            updatedAttributes.put(type, type.toStoredForm(value));
        }
        return new SimpleAttributes(updatedAttributes);
    }

    @Override
    public SimpleAttributes withAttributes(Attributes other) {
        HashMap updatedAttributes = new HashMap((Map<AttributeType<?>, Object>)this.attributes);
        for (AttributeType type : other.getAttributeTypes()) {
            updatedAttributes.put(type, type.captureWildcard().toStoredForm(other.getAttribute(type)));
        }
        return new SimpleAttributes(updatedAttributes);
    }

    public static TypedMetaBean<SimpleAttributes> meta() {
        return META_BEAN;
    }

    private SimpleAttributes(Map<AttributeType<?>, Object> attributes) {
        JodaBeanUtils.notNull(attributes, (String)"attributes");
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public TypedMetaBean<SimpleAttributes> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<AttributeType<?>, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SimpleAttributes other = (SimpleAttributes)obj;
            return JodaBeanUtils.equal(this.attributes, other.attributes);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.attributes);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("SimpleAttributes{");
        buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

