/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.Attributes;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.TradeInfoBuilder;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class TradeInfo
implements PortfolioItemInfo,
ImmutableBean,
Serializable {
    private static final TradeInfo EMPTY = TradeInfo.builder().build();
    @PropertyDefinition(get="optional", overrideGet=true)
    private final StandardId id;
    @PropertyDefinition(get="optional")
    private final StandardId counterparty;
    @PropertyDefinition(get="optional")
    private final LocalDate tradeDate;
    @PropertyDefinition(get="optional")
    private final LocalTime tradeTime;
    @PropertyDefinition(get="optional")
    private final ZoneId zone;
    @PropertyDefinition(get="optional")
    private final LocalDate settlementDate;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<AttributeType<?>, Object> attributes;
    private static final long serialVersionUID = 1L;

    public static TradeInfo empty() {
        return EMPTY;
    }

    public static TradeInfo of(LocalDate tradeDate) {
        return new TradeInfo(null, null, tradeDate, null, null, null, (Map<AttributeType<?>, Object>)ImmutableMap.of());
    }

    public static TradeInfo from(PortfolioItemInfo info) {
        if (info instanceof TradeInfo) {
            return (TradeInfo)info;
        }
        return TradeInfo.empty().combinedWith(info);
    }

    public static TradeInfoBuilder builder() {
        return new TradeInfoBuilder();
    }

    @Override
    public TradeInfo withId(StandardId identifier) {
        return new TradeInfo(identifier, this.counterparty, this.tradeDate, this.tradeTime, this.zone, this.settlementDate, (Map<AttributeType<?>, Object>)this.attributes);
    }

    @Override
    public ImmutableSet<AttributeType<?>> getAttributeTypes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> Optional<T> findAttribute(AttributeType<T> type) {
        return Optional.ofNullable(type.fromStoredForm(this.attributes.get(type)));
    }

    @Override
    public <T> TradeInfo withAttribute(AttributeType<T> type, T value) {
        HashMap updatedAttributes = new HashMap((Map<AttributeType<?>, Object>)this.attributes);
        if (value == null) {
            updatedAttributes.remove(type);
        } else {
            updatedAttributes.put(type, type.toStoredForm(value));
        }
        return new TradeInfo(this.id, this.counterparty, this.tradeDate, this.tradeTime, this.zone, this.settlementDate, updatedAttributes);
    }

    @Override
    public TradeInfo withAttributes(Attributes other) {
        TradeInfoBuilder builder = this.toBuilder();
        for (AttributeType attrType : other.getAttributeTypes()) {
            builder.addAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return builder.build();
    }

    @Override
    public TradeInfo combinedWith(PortfolioItemInfo other) {
        TradeInfoBuilder builder = this.toBuilder();
        other.getId().filter(ignored -> this.id == null).ifPresent(builder::id);
        if (other instanceof TradeInfo) {
            TradeInfo otherInfo = (TradeInfo)other;
            otherInfo.getCounterparty().filter(ignored -> this.counterparty == null).ifPresent(builder::counterparty);
            otherInfo.getTradeDate().filter(ignored -> this.tradeDate == null).ifPresent(builder::tradeDate);
            otherInfo.getTradeTime().filter(ignored -> this.tradeTime == null).ifPresent(builder::tradeTime);
            otherInfo.getZone().filter(ignored -> this.zone == null).ifPresent(builder::zone);
            otherInfo.getSettlementDate().filter(ignored -> this.settlementDate == null).ifPresent(builder::settlementDate);
        }
        for (AttributeType attrType : other.getAttributeTypes()) {
            if (this.attributes.keySet().contains((Object)attrType)) continue;
            builder.addAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return builder.build();
    }

    @Override
    public TradeInfo overrideWith(PortfolioItemInfo other) {
        TradeInfoBuilder builder = this.toBuilder();
        other.getId().ifPresent(builder::id);
        if (other instanceof TradeInfo) {
            TradeInfo otherInfo = (TradeInfo)other;
            otherInfo.getCounterparty().ifPresent(builder::counterparty);
            otherInfo.getTradeDate().ifPresent(builder::tradeDate);
            otherInfo.getTradeTime().ifPresent(builder::tradeTime);
            otherInfo.getZone().ifPresent(builder::zone);
            otherInfo.getSettlementDate().ifPresent(builder::settlementDate);
        }
        for (AttributeType attrType : other.getAttributeTypes()) {
            builder.addAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return builder.build();
    }

    public TradeInfoBuilder toBuilder() {
        return new TradeInfoBuilder(this.id, this.counterparty, this.tradeDate, this.tradeTime, this.zone, this.settlementDate, (Map<AttributeType<?>, Object>)this.attributes);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    TradeInfo(StandardId id, StandardId counterparty, LocalDate tradeDate, LocalTime tradeTime, ZoneId zone, LocalDate settlementDate, Map<AttributeType<?>, Object> attributes) {
        JodaBeanUtils.notNull(attributes, (String)"attributes");
        this.id = id;
        this.counterparty = counterparty;
        this.tradeDate = tradeDate;
        this.tradeTime = tradeTime;
        this.zone = zone;
        this.settlementDate = settlementDate;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public Optional<StandardId> getId() {
        return Optional.ofNullable(this.id);
    }

    public Optional<StandardId> getCounterparty() {
        return Optional.ofNullable(this.counterparty);
    }

    public Optional<LocalDate> getTradeDate() {
        return Optional.ofNullable(this.tradeDate);
    }

    public Optional<LocalTime> getTradeTime() {
        return Optional.ofNullable(this.tradeTime);
    }

    public Optional<ZoneId> getZone() {
        return Optional.ofNullable(this.zone);
    }

    public Optional<LocalDate> getSettlementDate() {
        return Optional.ofNullable(this.settlementDate);
    }

    public ImmutableMap<AttributeType<?>, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TradeInfo other = (TradeInfo)obj;
            return JodaBeanUtils.equal((Object)this.id, (Object)other.id) && JodaBeanUtils.equal((Object)this.counterparty, (Object)other.counterparty) && JodaBeanUtils.equal((Object)this.tradeDate, (Object)other.tradeDate) && JodaBeanUtils.equal((Object)this.tradeTime, (Object)other.tradeTime) && JodaBeanUtils.equal((Object)this.zone, (Object)other.zone) && JodaBeanUtils.equal((Object)this.settlementDate, (Object)other.settlementDate) && JodaBeanUtils.equal(this.attributes, other.attributes);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.id);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.counterparty);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tradeTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.zone);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDate);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.attributes);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("TradeInfo{");
        buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
        buf.append("counterparty").append('=').append(JodaBeanUtils.toString((Object)this.counterparty)).append(',').append(' ');
        buf.append("tradeDate").append('=').append(JodaBeanUtils.toString((Object)this.tradeDate)).append(',').append(' ');
        buf.append("tradeTime").append('=').append(JodaBeanUtils.toString((Object)this.tradeTime)).append(',').append(' ');
        buf.append("zone").append('=').append(JodaBeanUtils.toString((Object)this.zone)).append(',').append(' ');
        buf.append("settlementDate").append('=').append(JodaBeanUtils.toString((Object)this.settlementDate)).append(',').append(' ');
        buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<TradeInfo> {
        private StandardId id;
        private StandardId counterparty;
        private LocalDate tradeDate;
        private LocalTime tradeTime;
        private ZoneId zone;
        private LocalDate settlementDate;
        private Map<AttributeType<?>, Object> attributes = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case -1651301782: {
                    return this.counterparty;
                }
                case 752419634: {
                    return this.tradeDate;
                }
                case 752903761: {
                    return this.tradeTime;
                }
                case 3744684: {
                    return this.zone;
                }
                case -295948169: {
                    return this.settlementDate;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (StandardId)newValue;
                    break;
                }
                case -1651301782: {
                    this.counterparty = (StandardId)newValue;
                    break;
                }
                case 752419634: {
                    this.tradeDate = (LocalDate)newValue;
                    break;
                }
                case 752903761: {
                    this.tradeTime = (LocalTime)newValue;
                    break;
                }
                case 3744684: {
                    this.zone = (ZoneId)newValue;
                    break;
                }
                case -295948169: {
                    this.settlementDate = (LocalDate)newValue;
                    break;
                }
                case 405645655: {
                    this.attributes = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public TradeInfo build() {
            return new TradeInfo(this.id, this.counterparty, this.tradeDate, this.tradeTime, this.zone, this.settlementDate, this.attributes);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("TradeInfo.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("counterparty").append('=').append(JodaBeanUtils.toString((Object)this.counterparty)).append(',').append(' ');
            buf.append("tradeDate").append('=').append(JodaBeanUtils.toString((Object)this.tradeDate)).append(',').append(' ');
            buf.append("tradeTime").append('=').append(JodaBeanUtils.toString((Object)this.tradeTime)).append(',').append(' ');
            buf.append("zone").append('=').append(JodaBeanUtils.toString((Object)this.zone)).append(',').append(' ');
            buf.append("settlementDate").append('=').append(JodaBeanUtils.toString((Object)this.settlementDate)).append(',').append(' ');
            buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<StandardId> id = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"id", TradeInfo.class, StandardId.class);
        private final MetaProperty<StandardId> counterparty = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"counterparty", TradeInfo.class, StandardId.class);
        private final MetaProperty<LocalDate> tradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tradeDate", TradeInfo.class, LocalDate.class);
        private final MetaProperty<LocalTime> tradeTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tradeTime", TradeInfo.class, LocalTime.class);
        private final MetaProperty<ZoneId> zone = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"zone", TradeInfo.class, ZoneId.class);
        private final MetaProperty<LocalDate> settlementDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDate", TradeInfo.class, LocalDate.class);
        private final MetaProperty<ImmutableMap<AttributeType<?>, Object>> attributes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"attributes", TradeInfo.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"id", "counterparty", "tradeDate", "tradeTime", "zone", "settlementDate", "attributes"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case -1651301782: {
                    return this.counterparty;
                }
                case 752419634: {
                    return this.tradeDate;
                }
                case 752903761: {
                    return this.tradeTime;
                }
                case 3744684: {
                    return this.zone;
                }
                case -295948169: {
                    return this.settlementDate;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends TradeInfo> builder() {
            return new Builder();
        }

        public Class<? extends TradeInfo> beanType() {
            return TradeInfo.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<StandardId> id() {
            return this.id;
        }

        public MetaProperty<StandardId> counterparty() {
            return this.counterparty;
        }

        public MetaProperty<LocalDate> tradeDate() {
            return this.tradeDate;
        }

        public MetaProperty<LocalTime> tradeTime() {
            return this.tradeTime;
        }

        public MetaProperty<ZoneId> zone() {
            return this.zone;
        }

        public MetaProperty<LocalDate> settlementDate() {
            return this.settlementDate;
        }

        public MetaProperty<ImmutableMap<AttributeType<?>, Object>> attributes() {
            return this.attributes;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return ((TradeInfo)bean).id;
                }
                case -1651301782: {
                    return ((TradeInfo)bean).counterparty;
                }
                case 752419634: {
                    return ((TradeInfo)bean).tradeDate;
                }
                case 752903761: {
                    return ((TradeInfo)bean).tradeTime;
                }
                case 3744684: {
                    return ((TradeInfo)bean).zone;
                }
                case -295948169: {
                    return ((TradeInfo)bean).settlementDate;
                }
                case 405645655: {
                    return ((TradeInfo)bean).getAttributes();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

