/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.PortfolioItemInfoBuilder;
import com.opengamma.strata.product.TradeInfo;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;

public final class TradeInfoBuilder
implements PortfolioItemInfoBuilder<TradeInfo> {
    private StandardId id;
    private StandardId counterparty;
    private LocalDate tradeDate;
    private LocalTime tradeTime;
    private ZoneId zone;
    private LocalDate settlementDate;
    private final Map<AttributeType<?>, Object> attributes = new HashMap();

    TradeInfoBuilder() {
    }

    TradeInfoBuilder(StandardId id, StandardId counterparty, LocalDate tradeDate, LocalTime tradeTime, ZoneId zone, LocalDate settlementDate, Map<AttributeType<?>, Object> attributes) {
        this.id = id;
        this.counterparty = counterparty;
        this.tradeDate = tradeDate;
        this.tradeTime = tradeTime;
        this.zone = zone;
        this.settlementDate = settlementDate;
        this.attributes.putAll(attributes);
    }

    public TradeInfoBuilder id(StandardId id) {
        this.id = id;
        return this;
    }

    public TradeInfoBuilder counterparty(StandardId counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    public TradeInfoBuilder tradeDate(LocalDate tradeDate) {
        this.tradeDate = tradeDate;
        return this;
    }

    public TradeInfoBuilder tradeTime(LocalTime tradeTime) {
        this.tradeTime = tradeTime;
        return this;
    }

    public TradeInfoBuilder zone(ZoneId zone) {
        this.zone = zone;
        return this;
    }

    public TradeInfoBuilder settlementDate(LocalDate settlementDate) {
        this.settlementDate = settlementDate;
        return this;
    }

    public <T> TradeInfoBuilder addAttribute(AttributeType<T> attributeType, T attributeValue) {
        ArgChecker.notNull(attributeType, (String)"attributeType");
        ArgChecker.notNull(attributeValue, (String)"attributeValue");
        this.attributes.put(attributeType, attributeType.toStoredForm(attributeValue));
        return this;
    }

    @Override
    public TradeInfo build() {
        return new TradeInfo(this.id, this.counterparty, this.tradeDate, this.tradeTime, this.zone, this.settlementDate, this.attributes);
    }
}

