/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.AdjustablePayment;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.bond.Bill;
import com.opengamma.strata.product.bond.BillPosition;
import com.opengamma.strata.product.bond.BillTrade;
import com.opengamma.strata.product.bond.BillYieldConvention;
import com.opengamma.strata.product.bond.LegalEntitySecurity;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BillSecurity
implements LegalEntitySecurity,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="notNull")
    private final AdjustablePayment notional;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final BillYieldConvention yieldConvention;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LegalEntityId legalEntityId;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment settlementDateOffset;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((this.settlementDateOffset.getDays() >= 0 ? 1 : 0) != 0, (String)"The settlement date offset must be non-negative");
        ArgChecker.isTrue((this.notional.getAmount() > 0.0 ? 1 : 0) != 0, (String)"Notional must be strictly positive");
    }

    @Override
    public Currency getCurrency() {
        return this.notional.getCurrency();
    }

    @Override
    public ImmutableSet<SecurityId> getUnderlyingIds() {
        return ImmutableSet.of();
    }

    @Override
    public BillSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public Bill createProduct(ReferenceData refData) {
        return new Bill(this.getSecurityId(), this.notional, this.dayCount, this.yieldConvention, this.legalEntityId, this.settlementDateOffset);
    }

    @Override
    public BillTrade createTrade(TradeInfo info, double quantity, double tradePrice, ReferenceData refData) {
        return new BillTrade(info, this.createProduct(refData), quantity, tradePrice);
    }

    @Override
    public BillPosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return BillPosition.ofNet(positionInfo, this.createProduct(refData), quantity);
    }

    @Override
    public BillPosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return BillPosition.ofLongShort(positionInfo, this.createProduct(refData), longQuantity, shortQuantity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BillSecurity(SecurityInfo info, AdjustablePayment notional, DayCount dayCount, BillYieldConvention yieldConvention, LegalEntityId legalEntityId, DaysAdjustment settlementDateOffset) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        this.info = info;
        this.notional = notional;
        this.dayCount = dayCount;
        this.yieldConvention = yieldConvention;
        this.legalEntityId = legalEntityId;
        this.settlementDateOffset = settlementDateOffset;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    public AdjustablePayment getNotional() {
        return this.notional;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public BillYieldConvention getYieldConvention() {
        return this.yieldConvention;
    }

    @Override
    public LegalEntityId getLegalEntityId() {
        return this.legalEntityId;
    }

    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BillSecurity other = (BillSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.notional, (Object)other.notional) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.yieldConvention), (Object)((Object)other.yieldConvention)) && JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yieldConvention));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("BillSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BillSecurity> {
        private SecurityInfo info;
        private AdjustablePayment notional;
        private DayCount dayCount;
        private BillYieldConvention yieldConvention;
        private LegalEntityId legalEntityId;
        private DaysAdjustment settlementDateOffset;

        private Builder() {
        }

        private Builder(BillSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.notional = beanToCopy.getNotional();
            this.dayCount = beanToCopy.getDayCount();
            this.yieldConvention = beanToCopy.getYieldConvention();
            this.legalEntityId = beanToCopy.getLegalEntityId();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (AdjustablePayment)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -1895216418: {
                    this.yieldConvention = (BillYieldConvention)((Object)newValue);
                    break;
                }
                case 866287159: {
                    this.legalEntityId = (LegalEntityId)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BillSecurity build() {
            return new BillSecurity(this.info, this.notional, this.dayCount, this.yieldConvention, this.legalEntityId, this.settlementDateOffset);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder notional(AdjustablePayment notional) {
            JodaBeanUtils.notNull((Object)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder yieldConvention(BillYieldConvention yieldConvention) {
            JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
            this.yieldConvention = yieldConvention;
            return this;
        }

        public Builder legalEntityId(LegalEntityId legalEntityId) {
            JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
            this.legalEntityId = legalEntityId;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("BillSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", BillSecurity.class, SecurityInfo.class);
        private final MetaProperty<AdjustablePayment> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", BillSecurity.class, AdjustablePayment.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", BillSecurity.class, DayCount.class);
        private final MetaProperty<BillYieldConvention> yieldConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yieldConvention", BillSecurity.class, BillYieldConvention.class);
        private final MetaProperty<LegalEntityId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", BillSecurity.class, LegalEntityId.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", BillSecurity.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "notional", "dayCount", "yieldConvention", "legalEntityId", "settlementDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BillSecurity> beanType() {
            return BillSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<AdjustablePayment> notional() {
            return this.notional;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<BillYieldConvention> yieldConvention() {
            return this.yieldConvention;
        }

        public MetaProperty<LegalEntityId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((BillSecurity)bean).getInfo();
                }
                case 1585636160: {
                    return ((BillSecurity)bean).getNotional();
                }
                case 1905311443: {
                    return ((BillSecurity)bean).getDayCount();
                }
                case -1895216418: {
                    return ((BillSecurity)bean).getYieldConvention();
                }
                case 866287159: {
                    return ((BillSecurity)bean).getLegalEntityId();
                }
                case 135924714: {
                    return ((BillSecurity)bean).getSettlementDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

