/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum BillYieldConvention implements NamedEnum
{
    DISCOUNT("Discount"){

        @Override
        public double priceFromYield(double yield, double accrualFactor) {
            return 1.0 - accrualFactor * yield;
        }

        @Override
        public double yieldFromPrice(double price, double accrualFactor) {
            return (1.0 - price) / accrualFactor;
        }
    }
    ,
    FRANCE_CD("France-CD"){

        @Override
        public double priceFromYield(double yield, double accrualFactor) {
            return 1.0 / (1.0 + accrualFactor * yield);
        }

        @Override
        public double yieldFromPrice(double price, double accrualFactor) {
            return (1.0 / price - 1.0) / accrualFactor;
        }
    }
    ,
    INTEREST_AT_MATURITY("Interest-At-Maturity"){

        @Override
        public double priceFromYield(double yield, double accrualFactor) {
            return 1.0 / (1.0 + accrualFactor * yield);
        }

        @Override
        public double yieldFromPrice(double price, double accrualFactor) {
            return (1.0 / price - 1.0) / accrualFactor;
        }
    }
    ,
    JAPAN_BILLS("Japan-Bills"){

        @Override
        public double priceFromYield(double yield, double accrualFactor) {
            return 1.0 / (1.0 + accrualFactor * yield);
        }

        @Override
        public double yieldFromPrice(double price, double accrualFactor) {
            return (1.0 / price - 1.0) / accrualFactor;
        }
    };

    private static final EnumNames<BillYieldConvention> NAMES;
    private final String name;

    private BillYieldConvention(String name) {
        this.name = name;
    }

    @FromString
    public static BillYieldConvention of(String name) {
        return (BillYieldConvention)NAMES.parse(name);
    }

    @ToString
    public String toString() {
        return this.name;
    }

    public abstract double priceFromYield(double var1, double var3);

    public abstract double yieldFromPrice(double var1, double var3);

    static {
        NAMES = EnumNames.ofManualToString(BillYieldConvention.class);
    }
}

