/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.SecuritizedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.bond.FixedCouponBond;
import com.opengamma.strata.product.bond.ResolvedBondFuture;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class BondFuture
implements SecuritizedProduct,
Resolvable<ResolvedBondFuture>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityId securityId;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<FixedCouponBond> deliveryBasket;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<Double> conversionFactors;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastTradeDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate firstNoticeDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastNoticeDate;
    @PropertyDefinition(get="optional")
    private final LocalDate firstDeliveryDate;
    @PropertyDefinition(get="optional")
    private final LocalDate lastDeliveryDate;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.rounding(Rounding.none());
    }

    @ImmutableValidator
    private void validate() {
        int size = this.deliveryBasket.size();
        ArgChecker.isTrue((size == this.conversionFactors.size() ? 1 : 0) != 0, (String)"The delivery basket size should be the same as the conversion factor size");
        ArgChecker.inOrderOrEqual((Comparable)this.firstNoticeDate, (Object)this.lastNoticeDate, (String)"firstNoticeDate", (String)"lastNoticeDate");
        if (this.firstDeliveryDate != null && this.lastDeliveryDate != null) {
            ArgChecker.inOrderOrEqual((Comparable)this.firstDeliveryDate, (Object)this.lastDeliveryDate, (String)"firstDeliveryDate", (String)"lastDeliveryDate");
            ArgChecker.inOrderOrEqual((Comparable)this.firstNoticeDate, (Object)this.firstDeliveryDate, (String)"firstNoticeDate", (String)"firstDeliveryDate");
            ArgChecker.inOrderOrEqual((Comparable)this.lastNoticeDate, (Object)this.lastDeliveryDate, (String)"lastNoticeDate", (String)"lastDeliveryDate");
        }
        if (size > 1) {
            ImmutableList<FixedCouponBond> bondsList = this.getDeliveryBasket();
            double notional = this.getNotional();
            Currency currency = this.getCurrency();
            for (int i = 1; i < size; ++i) {
                ArgChecker.isTrue((((FixedCouponBond)bondsList.get(i)).getNotional() == notional ? 1 : 0) != 0, (String)"Notional must be same for all bonds");
                ArgChecker.isTrue((boolean)((FixedCouponBond)bondsList.get(i)).getCurrency().equals((Object)currency), (String)"Currency must be same for all bonds");
            }
        }
    }

    public double getNotional() {
        return ((FixedCouponBond)this.deliveryBasket.get(0)).getNotional();
    }

    @Override
    public Currency getCurrency() {
        return ((FixedCouponBond)this.deliveryBasket.get(0)).getCurrency();
    }

    public ResolvedBondFuture resolve(ReferenceData refData) {
        List basket = (List)this.deliveryBasket.stream().map(bond -> bond.resolve(refData)).collect(Guavate.toImmutableList());
        DaysAdjustment settleOffset = ((FixedCouponBond)this.deliveryBasket.get(0)).getSettlementDateOffset();
        return ResolvedBondFuture.builder().securityId(this.securityId).deliveryBasket(basket).conversionFactors((List<Double>)this.conversionFactors).lastTradeDate(this.lastTradeDate).firstNoticeDate(this.firstNoticeDate).lastNoticeDate(this.lastNoticeDate).firstDeliveryDate(this.firstDeliveryDate != null ? this.firstDeliveryDate : settleOffset.adjust(this.firstNoticeDate, refData)).lastDeliveryDate(this.lastDeliveryDate != null ? this.lastDeliveryDate : settleOffset.adjust(this.lastNoticeDate, refData)).rounding(this.rounding).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    BondFuture(SecurityId securityId, List<FixedCouponBond> deliveryBasket, List<Double> conversionFactors, LocalDate lastTradeDate, LocalDate firstNoticeDate, LocalDate lastNoticeDate, LocalDate firstDeliveryDate, LocalDate lastDeliveryDate, Rounding rounding) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notEmpty(deliveryBasket, (String)"deliveryBasket");
        JodaBeanUtils.notEmpty(conversionFactors, (String)"conversionFactors");
        JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
        JodaBeanUtils.notNull((Object)firstNoticeDate, (String)"firstNoticeDate");
        JodaBeanUtils.notNull((Object)lastNoticeDate, (String)"lastNoticeDate");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        this.securityId = securityId;
        this.deliveryBasket = ImmutableList.copyOf(deliveryBasket);
        this.conversionFactors = ImmutableList.copyOf(conversionFactors);
        this.lastTradeDate = lastTradeDate;
        this.firstNoticeDate = firstNoticeDate;
        this.lastNoticeDate = lastNoticeDate;
        this.firstDeliveryDate = firstDeliveryDate;
        this.lastDeliveryDate = lastDeliveryDate;
        this.rounding = rounding;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public ImmutableList<FixedCouponBond> getDeliveryBasket() {
        return this.deliveryBasket;
    }

    public ImmutableList<Double> getConversionFactors() {
        return this.conversionFactors;
    }

    public LocalDate getLastTradeDate() {
        return this.lastTradeDate;
    }

    public LocalDate getFirstNoticeDate() {
        return this.firstNoticeDate;
    }

    public LocalDate getLastNoticeDate() {
        return this.lastNoticeDate;
    }

    public Optional<LocalDate> getFirstDeliveryDate() {
        return Optional.ofNullable(this.firstDeliveryDate);
    }

    public Optional<LocalDate> getLastDeliveryDate() {
        return Optional.ofNullable(this.lastDeliveryDate);
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BondFuture other = (BondFuture)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal(this.deliveryBasket, other.deliveryBasket) && JodaBeanUtils.equal(this.conversionFactors, other.conversionFactors) && JodaBeanUtils.equal((Object)this.lastTradeDate, (Object)other.lastTradeDate) && JodaBeanUtils.equal((Object)this.firstNoticeDate, (Object)other.firstNoticeDate) && JodaBeanUtils.equal((Object)this.lastNoticeDate, (Object)other.lastNoticeDate) && JodaBeanUtils.equal((Object)this.firstDeliveryDate, (Object)other.firstDeliveryDate) && JodaBeanUtils.equal((Object)this.lastDeliveryDate, (Object)other.lastDeliveryDate) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.deliveryBasket);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.conversionFactors);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstNoticeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastNoticeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstDeliveryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastDeliveryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(320);
        buf.append("BondFuture{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("deliveryBasket").append('=').append(JodaBeanUtils.toString(this.deliveryBasket)).append(',').append(' ');
        buf.append("conversionFactors").append('=').append(JodaBeanUtils.toString(this.conversionFactors)).append(',').append(' ');
        buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
        buf.append("firstNoticeDate").append('=').append(JodaBeanUtils.toString((Object)this.firstNoticeDate)).append(',').append(' ');
        buf.append("lastNoticeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastNoticeDate)).append(',').append(' ');
        buf.append("firstDeliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.firstDeliveryDate)).append(',').append(' ');
        buf.append("lastDeliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.lastDeliveryDate)).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BondFuture> {
        private SecurityId securityId;
        private List<FixedCouponBond> deliveryBasket = ImmutableList.of();
        private List<Double> conversionFactors = ImmutableList.of();
        private LocalDate lastTradeDate;
        private LocalDate firstNoticeDate;
        private LocalDate lastNoticeDate;
        private LocalDate firstDeliveryDate;
        private LocalDate lastDeliveryDate;
        private Rounding rounding;

        private Builder() {
            BondFuture.applyDefaults(this);
        }

        private Builder(BondFuture beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.deliveryBasket = beanToCopy.getDeliveryBasket();
            this.conversionFactors = beanToCopy.getConversionFactors();
            this.lastTradeDate = beanToCopy.getLastTradeDate();
            this.firstNoticeDate = beanToCopy.getFirstNoticeDate();
            this.lastNoticeDate = beanToCopy.getLastNoticeDate();
            this.firstDeliveryDate = beanToCopy.firstDeliveryDate;
            this.lastDeliveryDate = beanToCopy.lastDeliveryDate;
            this.rounding = beanToCopy.getRounding();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 1999764186: {
                    return this.deliveryBasket;
                }
                case 1655488270: {
                    return this.conversionFactors;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case -1085415050: {
                    return this.firstNoticeDate;
                }
                case -1060668964: {
                    return this.lastNoticeDate;
                }
                case 1755448466: {
                    return this.firstDeliveryDate;
                }
                case -233366664: {
                    return this.lastDeliveryDate;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case 1999764186: {
                    this.deliveryBasket = (List)newValue;
                    break;
                }
                case 1655488270: {
                    this.conversionFactors = (List)newValue;
                    break;
                }
                case -1041950404: {
                    this.lastTradeDate = (LocalDate)newValue;
                    break;
                }
                case -1085415050: {
                    this.firstNoticeDate = (LocalDate)newValue;
                    break;
                }
                case -1060668964: {
                    this.lastNoticeDate = (LocalDate)newValue;
                    break;
                }
                case 1755448466: {
                    this.firstDeliveryDate = (LocalDate)newValue;
                    break;
                }
                case -233366664: {
                    this.lastDeliveryDate = (LocalDate)newValue;
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BondFuture build() {
            return new BondFuture(this.securityId, this.deliveryBasket, this.conversionFactors, this.lastTradeDate, this.firstNoticeDate, this.lastNoticeDate, this.firstDeliveryDate, this.lastDeliveryDate, this.rounding);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder deliveryBasket(List<FixedCouponBond> deliveryBasket) {
            JodaBeanUtils.notEmpty(deliveryBasket, (String)"deliveryBasket");
            this.deliveryBasket = deliveryBasket;
            return this;
        }

        public Builder deliveryBasket(FixedCouponBond ... deliveryBasket) {
            return this.deliveryBasket((List<FixedCouponBond>)ImmutableList.copyOf((Object[])deliveryBasket));
        }

        public Builder conversionFactors(List<Double> conversionFactors) {
            JodaBeanUtils.notEmpty(conversionFactors, (String)"conversionFactors");
            this.conversionFactors = conversionFactors;
            return this;
        }

        public Builder conversionFactors(Double ... conversionFactors) {
            return this.conversionFactors((List<Double>)ImmutableList.copyOf((Object[])conversionFactors));
        }

        public Builder lastTradeDate(LocalDate lastTradeDate) {
            JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        public Builder firstNoticeDate(LocalDate firstNoticeDate) {
            JodaBeanUtils.notNull((Object)firstNoticeDate, (String)"firstNoticeDate");
            this.firstNoticeDate = firstNoticeDate;
            return this;
        }

        public Builder lastNoticeDate(LocalDate lastNoticeDate) {
            JodaBeanUtils.notNull((Object)lastNoticeDate, (String)"lastNoticeDate");
            this.lastNoticeDate = lastNoticeDate;
            return this;
        }

        public Builder firstDeliveryDate(LocalDate firstDeliveryDate) {
            this.firstDeliveryDate = firstDeliveryDate;
            return this;
        }

        public Builder lastDeliveryDate(LocalDate lastDeliveryDate) {
            this.lastDeliveryDate = lastDeliveryDate;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(320);
            buf.append("BondFuture.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("deliveryBasket").append('=').append(JodaBeanUtils.toString(this.deliveryBasket)).append(',').append(' ');
            buf.append("conversionFactors").append('=').append(JodaBeanUtils.toString(this.conversionFactors)).append(',').append(' ');
            buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
            buf.append("firstNoticeDate").append('=').append(JodaBeanUtils.toString((Object)this.firstNoticeDate)).append(',').append(' ');
            buf.append("lastNoticeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastNoticeDate)).append(',').append(' ');
            buf.append("firstDeliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.firstDeliveryDate)).append(',').append(' ');
            buf.append("lastDeliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.lastDeliveryDate)).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", BondFuture.class, SecurityId.class);
        private final MetaProperty<ImmutableList<FixedCouponBond>> deliveryBasket = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"deliveryBasket", BondFuture.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<Double>> conversionFactors = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"conversionFactors", BondFuture.class, ImmutableList.class);
        private final MetaProperty<LocalDate> lastTradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastTradeDate", BondFuture.class, LocalDate.class);
        private final MetaProperty<LocalDate> firstNoticeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstNoticeDate", BondFuture.class, LocalDate.class);
        private final MetaProperty<LocalDate> lastNoticeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastNoticeDate", BondFuture.class, LocalDate.class);
        private final MetaProperty<LocalDate> firstDeliveryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstDeliveryDate", BondFuture.class, LocalDate.class);
        private final MetaProperty<LocalDate> lastDeliveryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastDeliveryDate", BondFuture.class, LocalDate.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", BondFuture.class, Rounding.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "deliveryBasket", "conversionFactors", "lastTradeDate", "firstNoticeDate", "lastNoticeDate", "firstDeliveryDate", "lastDeliveryDate", "rounding"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 1999764186: {
                    return this.deliveryBasket;
                }
                case 1655488270: {
                    return this.conversionFactors;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case -1085415050: {
                    return this.firstNoticeDate;
                }
                case -1060668964: {
                    return this.lastNoticeDate;
                }
                case 1755448466: {
                    return this.firstDeliveryDate;
                }
                case -233366664: {
                    return this.lastDeliveryDate;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BondFuture> beanType() {
            return BondFuture.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<ImmutableList<FixedCouponBond>> deliveryBasket() {
            return this.deliveryBasket;
        }

        public MetaProperty<ImmutableList<Double>> conversionFactors() {
            return this.conversionFactors;
        }

        public MetaProperty<LocalDate> lastTradeDate() {
            return this.lastTradeDate;
        }

        public MetaProperty<LocalDate> firstNoticeDate() {
            return this.firstNoticeDate;
        }

        public MetaProperty<LocalDate> lastNoticeDate() {
            return this.lastNoticeDate;
        }

        public MetaProperty<LocalDate> firstDeliveryDate() {
            return this.firstDeliveryDate;
        }

        public MetaProperty<LocalDate> lastDeliveryDate() {
            return this.lastDeliveryDate;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((BondFuture)bean).getSecurityId();
                }
                case 1999764186: {
                    return ((BondFuture)bean).getDeliveryBasket();
                }
                case 1655488270: {
                    return ((BondFuture)bean).getConversionFactors();
                }
                case -1041950404: {
                    return ((BondFuture)bean).getLastTradeDate();
                }
                case -1085415050: {
                    return ((BondFuture)bean).getFirstNoticeDate();
                }
                case -1060668964: {
                    return ((BondFuture)bean).getLastNoticeDate();
                }
                case 1755448466: {
                    return ((BondFuture)bean).firstDeliveryDate;
                }
                case -233366664: {
                    return ((BondFuture)bean).lastDeliveryDate;
                }
                case -142444: {
                    return ((BondFuture)bean).getRounding();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

