/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.Security;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.bond.BondFuture;
import com.opengamma.strata.product.bond.BondFuturePosition;
import com.opengamma.strata.product.bond.BondFutureTrade;
import com.opengamma.strata.product.bond.FixedCouponBond;
import com.opengamma.strata.product.bond.FixedCouponBondSecurity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BondFutureSecurity
implements Security,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<SecurityId> deliveryBasketIds;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<Double> conversionFactors;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastTradeDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate firstNoticeDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastNoticeDate;
    @PropertyDefinition(get="optional")
    private final LocalDate firstDeliveryDate;
    @PropertyDefinition(get="optional")
    private final LocalDate lastDeliveryDate;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.rounding(Rounding.none());
    }

    @ImmutableValidator
    private void validate() {
        int size = this.deliveryBasketIds.size();
        ArgChecker.isTrue((size == this.conversionFactors.size() ? 1 : 0) != 0, (String)"The delivery basket size should be the same as the conversion factor size");
        ArgChecker.inOrderOrEqual((Comparable)this.firstNoticeDate, (Object)this.lastNoticeDate, (String)"firstNoticeDate", (String)"lastNoticeDate");
        if (this.firstDeliveryDate != null && this.lastDeliveryDate != null) {
            ArgChecker.inOrderOrEqual((Comparable)this.firstDeliveryDate, (Object)this.lastDeliveryDate, (String)"firstDeliveryDate", (String)"lastDeliveryDate");
            ArgChecker.inOrderOrEqual((Comparable)this.firstNoticeDate, (Object)this.firstDeliveryDate, (String)"firstNoticeDate", (String)"firstDeliveryDate");
            ArgChecker.inOrderOrEqual((Comparable)this.lastNoticeDate, (Object)this.lastDeliveryDate, (String)"lastNoticeDate", (String)"lastDeliveryDate");
        }
    }

    @Override
    public ImmutableSet<SecurityId> getUnderlyingIds() {
        return ImmutableSet.copyOf(this.deliveryBasketIds);
    }

    @Override
    public BondFutureSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public BondFuture createProduct(ReferenceData refData) {
        List bonds = (List)this.deliveryBasketIds.stream().map(id -> this.resolveBond((SecurityId)id, refData)).collect(Guavate.toImmutableList());
        return new BondFuture(this.getSecurityId(), bonds, (List<Double>)this.conversionFactors, this.lastTradeDate, this.firstNoticeDate, this.lastNoticeDate, this.firstDeliveryDate, this.lastDeliveryDate, this.rounding);
    }

    private FixedCouponBond resolveBond(SecurityId id, ReferenceData refData) {
        Security security = (Security)refData.getValue((ReferenceDataId)id);
        if (!(security instanceof FixedCouponBondSecurity)) {
            throw new ClassCastException(Messages.format((String)"{} underlying bond '{}' resolved to '{}' when '{}' was expected", (Object[])new Object[]{BondFutureSecurity.class.getSimpleName(), id, security.getClass().getSimpleName(), FixedCouponBondSecurity.class.getSimpleName()}));
        }
        FixedCouponBondSecurity bondSec = (FixedCouponBondSecurity)security;
        return bondSec.createProduct(refData);
    }

    @Override
    public BondFutureTrade createTrade(TradeInfo info, double quantity, double tradePrice, ReferenceData refData) {
        BondFuture product = this.createProduct(refData);
        return new BondFutureTrade(info, product, quantity, tradePrice);
    }

    @Override
    public BondFuturePosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return BondFuturePosition.ofNet(positionInfo, this.createProduct(refData), quantity);
    }

    @Override
    public BondFuturePosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return BondFuturePosition.ofLongShort(positionInfo, this.createProduct(refData), longQuantity, shortQuantity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BondFutureSecurity(SecurityInfo info, Currency currency, List<SecurityId> deliveryBasketIds, List<Double> conversionFactors, LocalDate lastTradeDate, LocalDate firstNoticeDate, LocalDate lastNoticeDate, LocalDate firstDeliveryDate, LocalDate lastDeliveryDate, Rounding rounding) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notEmpty(deliveryBasketIds, (String)"deliveryBasketIds");
        JodaBeanUtils.notEmpty(conversionFactors, (String)"conversionFactors");
        JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
        JodaBeanUtils.notNull((Object)firstNoticeDate, (String)"firstNoticeDate");
        JodaBeanUtils.notNull((Object)lastNoticeDate, (String)"lastNoticeDate");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        this.info = info;
        this.currency = currency;
        this.deliveryBasketIds = ImmutableList.copyOf(deliveryBasketIds);
        this.conversionFactors = ImmutableList.copyOf(conversionFactors);
        this.lastTradeDate = lastTradeDate;
        this.firstNoticeDate = firstNoticeDate;
        this.lastNoticeDate = lastNoticeDate;
        this.firstDeliveryDate = firstDeliveryDate;
        this.lastDeliveryDate = lastDeliveryDate;
        this.rounding = rounding;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public ImmutableList<SecurityId> getDeliveryBasketIds() {
        return this.deliveryBasketIds;
    }

    public ImmutableList<Double> getConversionFactors() {
        return this.conversionFactors;
    }

    public LocalDate getLastTradeDate() {
        return this.lastTradeDate;
    }

    public LocalDate getFirstNoticeDate() {
        return this.firstNoticeDate;
    }

    public LocalDate getLastNoticeDate() {
        return this.lastNoticeDate;
    }

    public Optional<LocalDate> getFirstDeliveryDate() {
        return Optional.ofNullable(this.firstDeliveryDate);
    }

    public Optional<LocalDate> getLastDeliveryDate() {
        return Optional.ofNullable(this.lastDeliveryDate);
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BondFutureSecurity other = (BondFutureSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal(this.deliveryBasketIds, other.deliveryBasketIds) && JodaBeanUtils.equal(this.conversionFactors, other.conversionFactors) && JodaBeanUtils.equal((Object)this.lastTradeDate, (Object)other.lastTradeDate) && JodaBeanUtils.equal((Object)this.firstNoticeDate, (Object)other.firstNoticeDate) && JodaBeanUtils.equal((Object)this.lastNoticeDate, (Object)other.lastNoticeDate) && JodaBeanUtils.equal((Object)this.firstDeliveryDate, (Object)other.firstDeliveryDate) && JodaBeanUtils.equal((Object)this.lastDeliveryDate, (Object)other.lastDeliveryDate) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.deliveryBasketIds);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.conversionFactors);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstNoticeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastNoticeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstDeliveryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastDeliveryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("BondFutureSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("deliveryBasketIds").append('=').append(JodaBeanUtils.toString(this.deliveryBasketIds)).append(',').append(' ');
        buf.append("conversionFactors").append('=').append(JodaBeanUtils.toString(this.conversionFactors)).append(',').append(' ');
        buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
        buf.append("firstNoticeDate").append('=').append(JodaBeanUtils.toString((Object)this.firstNoticeDate)).append(',').append(' ');
        buf.append("lastNoticeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastNoticeDate)).append(',').append(' ');
        buf.append("firstDeliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.firstDeliveryDate)).append(',').append(' ');
        buf.append("lastDeliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.lastDeliveryDate)).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BondFutureSecurity> {
        private SecurityInfo info;
        private Currency currency;
        private List<SecurityId> deliveryBasketIds = ImmutableList.of();
        private List<Double> conversionFactors = ImmutableList.of();
        private LocalDate lastTradeDate;
        private LocalDate firstNoticeDate;
        private LocalDate lastNoticeDate;
        private LocalDate firstDeliveryDate;
        private LocalDate lastDeliveryDate;
        private Rounding rounding;

        private Builder() {
            BondFutureSecurity.applyDefaults(this);
        }

        private Builder(BondFutureSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.currency = beanToCopy.getCurrency();
            this.deliveryBasketIds = beanToCopy.getDeliveryBasketIds();
            this.conversionFactors = beanToCopy.getConversionFactors();
            this.lastTradeDate = beanToCopy.getLastTradeDate();
            this.firstNoticeDate = beanToCopy.getFirstNoticeDate();
            this.lastNoticeDate = beanToCopy.getLastNoticeDate();
            this.firstDeliveryDate = beanToCopy.firstDeliveryDate;
            this.lastDeliveryDate = beanToCopy.lastDeliveryDate;
            this.rounding = beanToCopy.getRounding();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 575402001: {
                    return this.currency;
                }
                case -516424322: {
                    return this.deliveryBasketIds;
                }
                case 1655488270: {
                    return this.conversionFactors;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case -1085415050: {
                    return this.firstNoticeDate;
                }
                case -1060668964: {
                    return this.lastNoticeDate;
                }
                case 1755448466: {
                    return this.firstDeliveryDate;
                }
                case -233366664: {
                    return this.lastDeliveryDate;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -516424322: {
                    this.deliveryBasketIds = (List)newValue;
                    break;
                }
                case 1655488270: {
                    this.conversionFactors = (List)newValue;
                    break;
                }
                case -1041950404: {
                    this.lastTradeDate = (LocalDate)newValue;
                    break;
                }
                case -1085415050: {
                    this.firstNoticeDate = (LocalDate)newValue;
                    break;
                }
                case -1060668964: {
                    this.lastNoticeDate = (LocalDate)newValue;
                    break;
                }
                case 1755448466: {
                    this.firstDeliveryDate = (LocalDate)newValue;
                    break;
                }
                case -233366664: {
                    this.lastDeliveryDate = (LocalDate)newValue;
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BondFutureSecurity build() {
            return new BondFutureSecurity(this.info, this.currency, this.deliveryBasketIds, this.conversionFactors, this.lastTradeDate, this.firstNoticeDate, this.lastNoticeDate, this.firstDeliveryDate, this.lastDeliveryDate, this.rounding);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder deliveryBasketIds(List<SecurityId> deliveryBasketIds) {
            JodaBeanUtils.notEmpty(deliveryBasketIds, (String)"deliveryBasketIds");
            this.deliveryBasketIds = deliveryBasketIds;
            return this;
        }

        public Builder deliveryBasketIds(SecurityId ... deliveryBasketIds) {
            return this.deliveryBasketIds((List<SecurityId>)ImmutableList.copyOf((Object[])deliveryBasketIds));
        }

        public Builder conversionFactors(List<Double> conversionFactors) {
            JodaBeanUtils.notEmpty(conversionFactors, (String)"conversionFactors");
            this.conversionFactors = conversionFactors;
            return this;
        }

        public Builder conversionFactors(Double ... conversionFactors) {
            return this.conversionFactors((List<Double>)ImmutableList.copyOf((Object[])conversionFactors));
        }

        public Builder lastTradeDate(LocalDate lastTradeDate) {
            JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        public Builder firstNoticeDate(LocalDate firstNoticeDate) {
            JodaBeanUtils.notNull((Object)firstNoticeDate, (String)"firstNoticeDate");
            this.firstNoticeDate = firstNoticeDate;
            return this;
        }

        public Builder lastNoticeDate(LocalDate lastNoticeDate) {
            JodaBeanUtils.notNull((Object)lastNoticeDate, (String)"lastNoticeDate");
            this.lastNoticeDate = lastNoticeDate;
            return this;
        }

        public Builder firstDeliveryDate(LocalDate firstDeliveryDate) {
            this.firstDeliveryDate = firstDeliveryDate;
            return this;
        }

        public Builder lastDeliveryDate(LocalDate lastDeliveryDate) {
            this.lastDeliveryDate = lastDeliveryDate;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("BondFutureSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("deliveryBasketIds").append('=').append(JodaBeanUtils.toString(this.deliveryBasketIds)).append(',').append(' ');
            buf.append("conversionFactors").append('=').append(JodaBeanUtils.toString(this.conversionFactors)).append(',').append(' ');
            buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
            buf.append("firstNoticeDate").append('=').append(JodaBeanUtils.toString((Object)this.firstNoticeDate)).append(',').append(' ');
            buf.append("lastNoticeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastNoticeDate)).append(',').append(' ');
            buf.append("firstDeliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.firstDeliveryDate)).append(',').append(' ');
            buf.append("lastDeliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.lastDeliveryDate)).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", BondFutureSecurity.class, SecurityInfo.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", BondFutureSecurity.class, Currency.class);
        private final MetaProperty<ImmutableList<SecurityId>> deliveryBasketIds = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"deliveryBasketIds", BondFutureSecurity.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<Double>> conversionFactors = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"conversionFactors", BondFutureSecurity.class, ImmutableList.class);
        private final MetaProperty<LocalDate> lastTradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastTradeDate", BondFutureSecurity.class, LocalDate.class);
        private final MetaProperty<LocalDate> firstNoticeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstNoticeDate", BondFutureSecurity.class, LocalDate.class);
        private final MetaProperty<LocalDate> lastNoticeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastNoticeDate", BondFutureSecurity.class, LocalDate.class);
        private final MetaProperty<LocalDate> firstDeliveryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstDeliveryDate", BondFutureSecurity.class, LocalDate.class);
        private final MetaProperty<LocalDate> lastDeliveryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastDeliveryDate", BondFutureSecurity.class, LocalDate.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", BondFutureSecurity.class, Rounding.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "currency", "deliveryBasketIds", "conversionFactors", "lastTradeDate", "firstNoticeDate", "lastNoticeDate", "firstDeliveryDate", "lastDeliveryDate", "rounding"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 575402001: {
                    return this.currency;
                }
                case -516424322: {
                    return this.deliveryBasketIds;
                }
                case 1655488270: {
                    return this.conversionFactors;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case -1085415050: {
                    return this.firstNoticeDate;
                }
                case -1060668964: {
                    return this.lastNoticeDate;
                }
                case 1755448466: {
                    return this.firstDeliveryDate;
                }
                case -233366664: {
                    return this.lastDeliveryDate;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BondFutureSecurity> beanType() {
            return BondFutureSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<ImmutableList<SecurityId>> deliveryBasketIds() {
            return this.deliveryBasketIds;
        }

        public MetaProperty<ImmutableList<Double>> conversionFactors() {
            return this.conversionFactors;
        }

        public MetaProperty<LocalDate> lastTradeDate() {
            return this.lastTradeDate;
        }

        public MetaProperty<LocalDate> firstNoticeDate() {
            return this.firstNoticeDate;
        }

        public MetaProperty<LocalDate> lastNoticeDate() {
            return this.lastNoticeDate;
        }

        public MetaProperty<LocalDate> firstDeliveryDate() {
            return this.firstDeliveryDate;
        }

        public MetaProperty<LocalDate> lastDeliveryDate() {
            return this.lastDeliveryDate;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((BondFutureSecurity)bean).getInfo();
                }
                case 575402001: {
                    return ((BondFutureSecurity)bean).getCurrency();
                }
                case -516424322: {
                    return ((BondFutureSecurity)bean).getDeliveryBasketIds();
                }
                case 1655488270: {
                    return ((BondFutureSecurity)bean).getConversionFactors();
                }
                case -1041950404: {
                    return ((BondFutureSecurity)bean).getLastTradeDate();
                }
                case -1085415050: {
                    return ((BondFutureSecurity)bean).getFirstNoticeDate();
                }
                case -1060668964: {
                    return ((BondFutureSecurity)bean).getLastNoticeDate();
                }
                case 1755448466: {
                    return ((BondFutureSecurity)bean).firstDeliveryDate;
                }
                case -233366664: {
                    return ((BondFutureSecurity)bean).lastDeliveryDate;
                }
                case -142444: {
                    return ((BondFutureSecurity)bean).getRounding();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

