/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.SecuritizedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.bond.CapitalIndexedBondPaymentPeriod;
import com.opengamma.strata.product.bond.CapitalIndexedBondYieldConvention;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBond;
import com.opengamma.strata.product.swap.InflationRateCalculation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class CapitalIndexedBond
implements SecuritizedProduct,
Resolvable<ResolvedCapitalIndexedBond>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityId securityId;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final PeriodicSchedule accrualSchedule;
    @PropertyDefinition(validate="notNull")
    private final InflationRateCalculation rateCalculation;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final CapitalIndexedBondYieldConvention yieldConvention;
    @PropertyDefinition(validate="notNull")
    private final LegalEntityId legalEntityId;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment settlementDateOffset;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment exCouponPeriod;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.exCouponPeriod = DaysAdjustment.NONE;
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((this.settlementDateOffset.getDays() >= 0 ? 1 : 0) != 0, (String)"The settlement date offset must be non-negative");
        ArgChecker.isTrue((this.exCouponPeriod.getDays() <= 0 ? 1 : 0) != 0, (String)"The ex-coupon period is measured from the payment date, thus the days must be non-positive");
        ArgChecker.isTrue((boolean)this.rateCalculation.getFirstIndexValue().isPresent(), (String)"Rate calculation must specify first index value");
    }

    public double getFirstIndexValue() {
        return this.rateCalculation.getFirstIndexValue().getAsDouble();
    }

    public ResolvedCapitalIndexedBond resolve(ReferenceData refData) {
        Schedule adjustedSchedule = this.accrualSchedule.createSchedule(refData);
        DateAdjuster exCouponPeriodAdjuster = this.exCouponPeriod.resolve(refData);
        DoubleArray resolvedGearings = this.rateCalculation.getGearing().orElse(ValueSchedule.ALWAYS_1).resolveValues(adjustedSchedule);
        ImmutableList.Builder bondPeriodsBuilder = ImmutableList.builder();
        for (int i = 0; i < adjustedSchedule.size(); ++i) {
            SchedulePeriod period = adjustedSchedule.getPeriod(i);
            bondPeriodsBuilder.add((Object)CapitalIndexedBondPaymentPeriod.builder().unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate()).startDate(period.getStartDate()).endDate(period.getEndDate()).detachmentDate(exCouponPeriodAdjuster.adjust(period.getEndDate())).notional(this.notional).currency(this.currency).rateComputation(this.rateCalculation.createRateComputation(period.getEndDate())).realCoupon(resolvedGearings.get(i)).build());
        }
        ImmutableList bondPeriods = bondPeriodsBuilder.build();
        CapitalIndexedBondPaymentPeriod nominalPayment = ((CapitalIndexedBondPaymentPeriod)bondPeriods.get(bondPeriods.size() - 1)).withUnitCoupon(((CapitalIndexedBondPaymentPeriod)bondPeriods.get(0)).getStartDate(), ((CapitalIndexedBondPaymentPeriod)bondPeriods.get(0)).getUnadjustedStartDate());
        return ResolvedCapitalIndexedBond.builder().securityId(this.securityId).periodicPayments((List<CapitalIndexedBondPaymentPeriod>)ImmutableList.copyOf((Collection)bondPeriods)).frequency(this.accrualSchedule.getFrequency()).rollConvention(this.accrualSchedule.calculatedRollConvention()).dayCount(this.dayCount).yieldConvention(this.yieldConvention).settlementDateOffset(this.settlementDateOffset).legalEntityId(this.legalEntityId).nominalPayment(nominalPayment).rateCalculation(this.rateCalculation).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    CapitalIndexedBond(SecurityId securityId, Currency currency, double notional, PeriodicSchedule accrualSchedule, InflationRateCalculation rateCalculation, DayCount dayCount, CapitalIndexedBondYieldConvention yieldConvention, LegalEntityId legalEntityId, DaysAdjustment settlementDateOffset, DaysAdjustment exCouponPeriod) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)accrualSchedule, (String)"accrualSchedule");
        JodaBeanUtils.notNull((Object)rateCalculation, (String)"rateCalculation");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        JodaBeanUtils.notNull((Object)exCouponPeriod, (String)"exCouponPeriod");
        this.securityId = securityId;
        this.currency = currency;
        this.notional = notional;
        this.accrualSchedule = accrualSchedule;
        this.rateCalculation = rateCalculation;
        this.dayCount = dayCount;
        this.yieldConvention = yieldConvention;
        this.legalEntityId = legalEntityId;
        this.settlementDateOffset = settlementDateOffset;
        this.exCouponPeriod = exCouponPeriod;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public PeriodicSchedule getAccrualSchedule() {
        return this.accrualSchedule;
    }

    public InflationRateCalculation getRateCalculation() {
        return this.rateCalculation;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public CapitalIndexedBondYieldConvention getYieldConvention() {
        return this.yieldConvention;
    }

    public LegalEntityId getLegalEntityId() {
        return this.legalEntityId;
    }

    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public DaysAdjustment getExCouponPeriod() {
        return this.exCouponPeriod;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CapitalIndexedBond other = (CapitalIndexedBond)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.accrualSchedule, (Object)other.accrualSchedule) && JodaBeanUtils.equal((Object)this.rateCalculation, (Object)other.rateCalculation) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.yieldConvention), (Object)((Object)other.yieldConvention)) && JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset) && JodaBeanUtils.equal((Object)this.exCouponPeriod, (Object)other.exCouponPeriod);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rateCalculation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yieldConvention));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.exCouponPeriod);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("CapitalIndexedBond{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("accrualSchedule").append('=').append(JodaBeanUtils.toString((Object)this.accrualSchedule)).append(',').append(' ');
        buf.append("rateCalculation").append('=').append(JodaBeanUtils.toString((Object)this.rateCalculation)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset)).append(',').append(' ');
        buf.append("exCouponPeriod").append('=').append(JodaBeanUtils.toString((Object)this.exCouponPeriod));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CapitalIndexedBond> {
        private SecurityId securityId;
        private Currency currency;
        private double notional;
        private PeriodicSchedule accrualSchedule;
        private InflationRateCalculation rateCalculation;
        private DayCount dayCount;
        private CapitalIndexedBondYieldConvention yieldConvention;
        private LegalEntityId legalEntityId;
        private DaysAdjustment settlementDateOffset;
        private DaysAdjustment exCouponPeriod;

        private Builder() {
            CapitalIndexedBond.applyDefaults(this);
        }

        private Builder(CapitalIndexedBond beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.accrualSchedule = beanToCopy.getAccrualSchedule();
            this.rateCalculation = beanToCopy.getRateCalculation();
            this.dayCount = beanToCopy.getDayCount();
            this.yieldConvention = beanToCopy.getYieldConvention();
            this.legalEntityId = beanToCopy.getLegalEntityId();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
            this.exCouponPeriod = beanToCopy.getExCouponPeriod();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 304659814: {
                    return this.accrualSchedule;
                }
                case -521703991: {
                    return this.rateCalculation;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
                case 1408037338: {
                    return this.exCouponPeriod;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case 304659814: {
                    this.accrualSchedule = (PeriodicSchedule)newValue;
                    break;
                }
                case -521703991: {
                    this.rateCalculation = (InflationRateCalculation)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -1895216418: {
                    this.yieldConvention = (CapitalIndexedBondYieldConvention)((Object)newValue);
                    break;
                }
                case 866287159: {
                    this.legalEntityId = (LegalEntityId)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1408037338: {
                    this.exCouponPeriod = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CapitalIndexedBond build() {
            return new CapitalIndexedBond(this.securityId, this.currency, this.notional, this.accrualSchedule, this.rateCalculation, this.dayCount, this.yieldConvention, this.legalEntityId, this.settlementDateOffset, this.exCouponPeriod);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder accrualSchedule(PeriodicSchedule accrualSchedule) {
            JodaBeanUtils.notNull((Object)accrualSchedule, (String)"accrualSchedule");
            this.accrualSchedule = accrualSchedule;
            return this;
        }

        public Builder rateCalculation(InflationRateCalculation rateCalculation) {
            JodaBeanUtils.notNull((Object)rateCalculation, (String)"rateCalculation");
            this.rateCalculation = rateCalculation;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder yieldConvention(CapitalIndexedBondYieldConvention yieldConvention) {
            JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
            this.yieldConvention = yieldConvention;
            return this;
        }

        public Builder legalEntityId(LegalEntityId legalEntityId) {
            JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
            this.legalEntityId = legalEntityId;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public Builder exCouponPeriod(DaysAdjustment exCouponPeriod) {
            JodaBeanUtils.notNull((Object)exCouponPeriod, (String)"exCouponPeriod");
            this.exCouponPeriod = exCouponPeriod;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("CapitalIndexedBond.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("accrualSchedule").append('=').append(JodaBeanUtils.toString((Object)this.accrualSchedule)).append(',').append(' ');
            buf.append("rateCalculation").append('=').append(JodaBeanUtils.toString((Object)this.rateCalculation)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset)).append(',').append(' ');
            buf.append("exCouponPeriod").append('=').append(JodaBeanUtils.toString((Object)this.exCouponPeriod));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", CapitalIndexedBond.class, SecurityId.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CapitalIndexedBond.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", CapitalIndexedBond.class, Double.TYPE);
        private final MetaProperty<PeriodicSchedule> accrualSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualSchedule", CapitalIndexedBond.class, PeriodicSchedule.class);
        private final MetaProperty<InflationRateCalculation> rateCalculation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rateCalculation", CapitalIndexedBond.class, InflationRateCalculation.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", CapitalIndexedBond.class, DayCount.class);
        private final MetaProperty<CapitalIndexedBondYieldConvention> yieldConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yieldConvention", CapitalIndexedBond.class, CapitalIndexedBondYieldConvention.class);
        private final MetaProperty<LegalEntityId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", CapitalIndexedBond.class, LegalEntityId.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", CapitalIndexedBond.class, DaysAdjustment.class);
        private final MetaProperty<DaysAdjustment> exCouponPeriod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"exCouponPeriod", CapitalIndexedBond.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "currency", "notional", "accrualSchedule", "rateCalculation", "dayCount", "yieldConvention", "legalEntityId", "settlementDateOffset", "exCouponPeriod"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 304659814: {
                    return this.accrualSchedule;
                }
                case -521703991: {
                    return this.rateCalculation;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
                case 1408037338: {
                    return this.exCouponPeriod;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CapitalIndexedBond> beanType() {
            return CapitalIndexedBond.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<PeriodicSchedule> accrualSchedule() {
            return this.accrualSchedule;
        }

        public MetaProperty<InflationRateCalculation> rateCalculation() {
            return this.rateCalculation;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<CapitalIndexedBondYieldConvention> yieldConvention() {
            return this.yieldConvention;
        }

        public MetaProperty<LegalEntityId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        public MetaProperty<DaysAdjustment> exCouponPeriod() {
            return this.exCouponPeriod;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((CapitalIndexedBond)bean).getSecurityId();
                }
                case 575402001: {
                    return ((CapitalIndexedBond)bean).getCurrency();
                }
                case 1585636160: {
                    return ((CapitalIndexedBond)bean).getNotional();
                }
                case 304659814: {
                    return ((CapitalIndexedBond)bean).getAccrualSchedule();
                }
                case -521703991: {
                    return ((CapitalIndexedBond)bean).getRateCalculation();
                }
                case 1905311443: {
                    return ((CapitalIndexedBond)bean).getDayCount();
                }
                case -1895216418: {
                    return ((CapitalIndexedBond)bean).getYieldConvention();
                }
                case 866287159: {
                    return ((CapitalIndexedBond)bean).getLegalEntityId();
                }
                case 135924714: {
                    return ((CapitalIndexedBond)bean).getSettlementDateOffset();
                }
                case 1408037338: {
                    return ((CapitalIndexedBond)bean).getExCouponPeriod();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

