/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.bond.BondPaymentPeriod;
import com.opengamma.strata.product.rate.InflationEndInterpolatedRateComputation;
import com.opengamma.strata.product.rate.InflationEndMonthRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CapitalIndexedBondPaymentPeriod
implements BondPaymentPeriod,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition
    private final double notional;
    @PropertyDefinition
    private final double realCoupon;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedEndDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate detachmentDate;
    @PropertyDefinition(validate="notNull")
    private final RateComputation rateComputation;
    private static final long serialVersionUID = 1L;

    @ImmutableConstructor
    private CapitalIndexedBondPaymentPeriod(Currency currency, double notional, double realCoupon, LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate, LocalDate detachmentDate, RateComputation rateComputation) {
        this.currency = (Currency)ArgChecker.notNull((Object)currency, (String)"currency");
        this.notional = ArgChecker.notZero((double)notional, (double)0.0, (String)"notional");
        this.realCoupon = ArgChecker.notNegative((double)realCoupon, (String)"realCoupon");
        this.startDate = (LocalDate)ArgChecker.notNull((Object)startDate, (String)"startDate");
        this.endDate = (LocalDate)ArgChecker.notNull((Object)endDate, (String)"endDate");
        this.unadjustedStartDate = (LocalDate)MoreObjects.firstNonNull((Object)unadjustedStartDate, (Object)startDate);
        this.unadjustedEndDate = (LocalDate)MoreObjects.firstNonNull((Object)unadjustedEndDate, (Object)endDate);
        this.detachmentDate = (LocalDate)MoreObjects.firstNonNull((Object)detachmentDate, (Object)endDate);
        this.rateComputation = (RateComputation)ArgChecker.notNull((Object)rateComputation, (String)"rateComputation");
        ArgChecker.inOrderNotEqual((Comparable)startDate, (Object)endDate, (String)"startDate", (String)"endDate");
        ArgChecker.inOrderNotEqual((Comparable)this.unadjustedStartDate, (Object)this.unadjustedEndDate, (String)"unadjustedStartDate", (String)"unadjustedEndDate");
        ArgChecker.inOrderOrEqual((Comparable)this.detachmentDate, (Object)this.endDate, (String)"detachmentDate", (String)"endDate");
        ArgChecker.isTrue((rateComputation instanceof InflationEndInterpolatedRateComputation || rateComputation instanceof InflationEndMonthRateComputation ? 1 : 0) != 0, (String)"rateComputation must be inflation rate observation");
    }

    CapitalIndexedBondPaymentPeriod withUnitCoupon(LocalDate startDate, LocalDate unadjustedStartDate) {
        return new CapitalIndexedBondPaymentPeriod(this.currency, this.notional, 1.0, startDate, this.endDate, unadjustedStartDate, this.unadjustedEndDate, this.endDate, this.rateComputation);
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
        this.rateComputation.collectIndices(builder);
    }

    @Override
    public CapitalIndexedBondPaymentPeriod adjustPaymentDate(TemporalAdjuster adjuster) {
        return this;
    }

    @Override
    public LocalDate getPaymentDate() {
        return this.getEndDate();
    }

    public boolean hasExCouponPeriod() {
        return !this.detachmentDate.equals(this.endDate);
    }

    boolean contains(LocalDate date) {
        return !date.isBefore(this.unadjustedStartDate) && date.isBefore(this.unadjustedEndDate);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public double getRealCoupon() {
        return this.realCoupon;
    }

    @Override
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Override
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalDate getUnadjustedStartDate() {
        return this.unadjustedStartDate;
    }

    public LocalDate getUnadjustedEndDate() {
        return this.unadjustedEndDate;
    }

    public LocalDate getDetachmentDate() {
        return this.detachmentDate;
    }

    public RateComputation getRateComputation() {
        return this.rateComputation;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CapitalIndexedBondPaymentPeriod other = (CapitalIndexedBondPaymentPeriod)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((double)this.realCoupon, (double)other.realCoupon) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.unadjustedStartDate, (Object)other.unadjustedStartDate) && JodaBeanUtils.equal((Object)this.unadjustedEndDate, (Object)other.unadjustedEndDate) && JodaBeanUtils.equal((Object)this.detachmentDate, (Object)other.detachmentDate) && JodaBeanUtils.equal((Object)this.rateComputation, (Object)other.rateComputation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.realCoupon);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.detachmentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rateComputation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(320);
        buf.append("CapitalIndexedBondPaymentPeriod{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("realCoupon").append('=').append(JodaBeanUtils.toString((Object)this.realCoupon)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
        buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
        buf.append("detachmentDate").append('=').append(JodaBeanUtils.toString((Object)this.detachmentDate)).append(',').append(' ');
        buf.append("rateComputation").append('=').append(JodaBeanUtils.toString((Object)this.rateComputation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CapitalIndexedBondPaymentPeriod> {
        private Currency currency;
        private double notional;
        private double realCoupon;
        private LocalDate startDate;
        private LocalDate endDate;
        private LocalDate unadjustedStartDate;
        private LocalDate unadjustedEndDate;
        private LocalDate detachmentDate;
        private RateComputation rateComputation;

        private Builder() {
        }

        private Builder(CapitalIndexedBondPaymentPeriod beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.realCoupon = beanToCopy.getRealCoupon();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.unadjustedStartDate = beanToCopy.getUnadjustedStartDate();
            this.unadjustedEndDate = beanToCopy.getUnadjustedEndDate();
            this.detachmentDate = beanToCopy.getDetachmentDate();
            this.rateComputation = beanToCopy.getRateComputation();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 1842278244: {
                    return this.realCoupon;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -878940481: {
                    return this.detachmentDate;
                }
                case 625350855: {
                    return this.rateComputation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case 1842278244: {
                    this.realCoupon = (Double)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 1457691881: {
                    this.unadjustedStartDate = (LocalDate)newValue;
                    break;
                }
                case 31758114: {
                    this.unadjustedEndDate = (LocalDate)newValue;
                    break;
                }
                case -878940481: {
                    this.detachmentDate = (LocalDate)newValue;
                    break;
                }
                case 625350855: {
                    this.rateComputation = (RateComputation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CapitalIndexedBondPaymentPeriod build() {
            return new CapitalIndexedBondPaymentPeriod(this.currency, this.notional, this.realCoupon, this.startDate, this.endDate, this.unadjustedStartDate, this.unadjustedEndDate, this.detachmentDate, this.rateComputation);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            this.notional = notional;
            return this;
        }

        public Builder realCoupon(double realCoupon) {
            this.realCoupon = realCoupon;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder unadjustedStartDate(LocalDate unadjustedStartDate) {
            JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
            this.unadjustedStartDate = unadjustedStartDate;
            return this;
        }

        public Builder unadjustedEndDate(LocalDate unadjustedEndDate) {
            JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
            this.unadjustedEndDate = unadjustedEndDate;
            return this;
        }

        public Builder detachmentDate(LocalDate detachmentDate) {
            JodaBeanUtils.notNull((Object)detachmentDate, (String)"detachmentDate");
            this.detachmentDate = detachmentDate;
            return this;
        }

        public Builder rateComputation(RateComputation rateComputation) {
            JodaBeanUtils.notNull((Object)rateComputation, (String)"rateComputation");
            this.rateComputation = rateComputation;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(320);
            buf.append("CapitalIndexedBondPaymentPeriod.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("realCoupon").append('=').append(JodaBeanUtils.toString((Object)this.realCoupon)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
            buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
            buf.append("detachmentDate").append('=').append(JodaBeanUtils.toString((Object)this.detachmentDate)).append(',').append(' ');
            buf.append("rateComputation").append('=').append(JodaBeanUtils.toString((Object)this.rateComputation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CapitalIndexedBondPaymentPeriod.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", CapitalIndexedBondPaymentPeriod.class, Double.TYPE);
        private final MetaProperty<Double> realCoupon = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"realCoupon", CapitalIndexedBondPaymentPeriod.class, Double.TYPE);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", CapitalIndexedBondPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", CapitalIndexedBondPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedStartDate", CapitalIndexedBondPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedEndDate", CapitalIndexedBondPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> detachmentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"detachmentDate", CapitalIndexedBondPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<RateComputation> rateComputation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rateComputation", CapitalIndexedBondPaymentPeriod.class, RateComputation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "notional", "realCoupon", "startDate", "endDate", "unadjustedStartDate", "unadjustedEndDate", "detachmentDate", "rateComputation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 1842278244: {
                    return this.realCoupon;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -878940481: {
                    return this.detachmentDate;
                }
                case 625350855: {
                    return this.rateComputation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CapitalIndexedBondPaymentPeriod> beanType() {
            return CapitalIndexedBondPaymentPeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<Double> realCoupon() {
            return this.realCoupon;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<LocalDate> unadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        public MetaProperty<LocalDate> unadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        public MetaProperty<LocalDate> detachmentDate() {
            return this.detachmentDate;
        }

        public MetaProperty<RateComputation> rateComputation() {
            return this.rateComputation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getCurrency();
                }
                case 1585636160: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getNotional();
                }
                case 1842278244: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getRealCoupon();
                }
                case -2129778896: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getStartDate();
                }
                case -1607727319: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getEndDate();
                }
                case 1457691881: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getUnadjustedStartDate();
                }
                case 31758114: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getUnadjustedEndDate();
                }
                case -878940481: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getDetachmentDate();
                }
                case 625350855: {
                    return ((CapitalIndexedBondPaymentPeriod)bean).getRateComputation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

