/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.SecuritizedProductPosition;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.bond.CapitalIndexedBond;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBond;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBondTrade;
import com.opengamma.strata.product.common.SummarizerUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class CapitalIndexedBondPosition
implements SecuritizedProductPosition<CapitalIndexedBond>,
Resolvable<ResolvedCapitalIndexedBondTrade>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PositionInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CapitalIndexedBond product;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double longQuantity;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double shortQuantity;
    private static final long serialVersionUID = 1L;

    public static CapitalIndexedBondPosition ofNet(PositionInfo positionInfo, CapitalIndexedBond product, double netQuantity) {
        double longQuantity = netQuantity >= 0.0 ? netQuantity : 0.0;
        double shortQuantity = netQuantity >= 0.0 ? 0.0 : -netQuantity;
        return new CapitalIndexedBondPosition(positionInfo, product, longQuantity, shortQuantity);
    }

    public static CapitalIndexedBondPosition ofLongShort(PositionInfo positionInfo, CapitalIndexedBond product, double longQuantity, double shortQuantity) {
        return new CapitalIndexedBondPosition(positionInfo, product, longQuantity, shortQuantity);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = PositionInfo.empty();
    }

    @Override
    public SecurityId getSecurityId() {
        return this.product.getSecurityId();
    }

    @Override
    public Currency getCurrency() {
        return this.product.getCurrency();
    }

    @Override
    @DerivedProperty
    public double getQuantity() {
        return this.longQuantity - this.shortQuantity;
    }

    @Override
    public CapitalIndexedBondPosition withInfo(PortfolioItemInfo info) {
        return new CapitalIndexedBondPosition(PositionInfo.from(info), this.product, this.longQuantity, this.shortQuantity);
    }

    @Override
    public CapitalIndexedBondPosition withQuantity(double quantity) {
        return CapitalIndexedBondPosition.ofNet(this.info, this.product, quantity);
    }

    @Override
    public PortfolioItemSummary summarize() {
        String description = this.getSecurityId().getStandardId().getValue() + " x " + SummarizerUtils.value(this.getQuantity());
        return SummarizerUtils.summary(this, ProductType.BOND, description, this.getCurrency());
    }

    public ResolvedCapitalIndexedBondTrade resolve(ReferenceData refData) {
        ResolvedCapitalIndexedBond resolved = this.product.resolve(refData);
        return new ResolvedCapitalIndexedBondTrade(this.info, resolved, this.getQuantity(), null);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    CapitalIndexedBondPosition(PositionInfo info, CapitalIndexedBond product, double longQuantity, double shortQuantity) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        ArgChecker.notNegative((double)longQuantity, (String)"longQuantity");
        ArgChecker.notNegative((double)shortQuantity, (String)"shortQuantity");
        this.info = info;
        this.product = product;
        this.longQuantity = longQuantity;
        this.shortQuantity = shortQuantity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PositionInfo getInfo() {
        return this.info;
    }

    @Override
    public CapitalIndexedBond getProduct() {
        return this.product;
    }

    public double getLongQuantity() {
        return this.longQuantity;
    }

    public double getShortQuantity() {
        return this.shortQuantity;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CapitalIndexedBondPosition other = (CapitalIndexedBondPosition)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product) && JodaBeanUtils.equal((double)this.longQuantity, (double)other.longQuantity) && JodaBeanUtils.equal((double)this.shortQuantity, (double)other.shortQuantity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.longQuantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.shortQuantity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("CapitalIndexedBondPosition{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
        buf.append("longQuantity").append('=').append(JodaBeanUtils.toString((Object)this.longQuantity)).append(',').append(' ');
        buf.append("shortQuantity").append('=').append(JodaBeanUtils.toString((Object)this.shortQuantity)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.getQuantity()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CapitalIndexedBondPosition> {
        private PositionInfo info;
        private CapitalIndexedBond product;
        private double longQuantity;
        private double shortQuantity;

        private Builder() {
            CapitalIndexedBondPosition.applyDefaults(this);
        }

        private Builder(CapitalIndexedBondPosition beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
            this.longQuantity = beanToCopy.getLongQuantity();
            this.shortQuantity = beanToCopy.getShortQuantity();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case 611668775: {
                    return this.longQuantity;
                }
                case -2094395097: {
                    return this.shortQuantity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (PositionInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (CapitalIndexedBond)newValue;
                    break;
                }
                case 611668775: {
                    this.longQuantity = (Double)newValue;
                    break;
                }
                case -2094395097: {
                    this.shortQuantity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CapitalIndexedBondPosition build() {
            return new CapitalIndexedBondPosition(this.info, this.product, this.longQuantity, this.shortQuantity);
        }

        public Builder info(PositionInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(CapitalIndexedBond product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public Builder longQuantity(double longQuantity) {
            ArgChecker.notNegative((double)longQuantity, (String)"longQuantity");
            this.longQuantity = longQuantity;
            return this;
        }

        public Builder shortQuantity(double shortQuantity) {
            ArgChecker.notNegative((double)shortQuantity, (String)"shortQuantity");
            this.shortQuantity = shortQuantity;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("CapitalIndexedBondPosition.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
            buf.append("longQuantity").append('=').append(JodaBeanUtils.toString((Object)this.longQuantity)).append(',').append(' ');
            buf.append("shortQuantity").append('=').append(JodaBeanUtils.toString((Object)this.shortQuantity)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PositionInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", CapitalIndexedBondPosition.class, PositionInfo.class);
        private final MetaProperty<CapitalIndexedBond> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", CapitalIndexedBondPosition.class, CapitalIndexedBond.class);
        private final MetaProperty<Double> longQuantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longQuantity", CapitalIndexedBondPosition.class, Double.TYPE);
        private final MetaProperty<Double> shortQuantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shortQuantity", CapitalIndexedBondPosition.class, Double.TYPE);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofDerived((MetaBean)this, (String)"quantity", CapitalIndexedBondPosition.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product", "longQuantity", "shortQuantity", "quantity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case 611668775: {
                    return this.longQuantity;
                }
                case -2094395097: {
                    return this.shortQuantity;
                }
                case -1285004149: {
                    return this.quantity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CapitalIndexedBondPosition> beanType() {
            return CapitalIndexedBondPosition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PositionInfo> info() {
            return this.info;
        }

        public MetaProperty<CapitalIndexedBond> product() {
            return this.product;
        }

        public MetaProperty<Double> longQuantity() {
            return this.longQuantity;
        }

        public MetaProperty<Double> shortQuantity() {
            return this.shortQuantity;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((CapitalIndexedBondPosition)bean).getInfo();
                }
                case -309474065: {
                    return ((CapitalIndexedBondPosition)bean).getProduct();
                }
                case 611668775: {
                    return ((CapitalIndexedBondPosition)bean).getLongQuantity();
                }
                case -2094395097: {
                    return ((CapitalIndexedBondPosition)bean).getShortQuantity();
                }
                case -1285004149: {
                    return ((CapitalIndexedBondPosition)bean).getQuantity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

