/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.ResolvableTrade;
import com.opengamma.strata.product.SecuritizedProductTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.bond.CapitalIndexedBond;
import com.opengamma.strata.product.bond.CapitalIndexedBondPaymentPeriod;
import com.opengamma.strata.product.bond.CapitalIndexedBondYieldConvention;
import com.opengamma.strata.product.bond.KnownAmountBondPaymentPeriod;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBond;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBondSettlement;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBondTrade;
import com.opengamma.strata.product.common.SummarizerUtils;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class CapitalIndexedBondTrade
implements SecuritizedProductTrade<CapitalIndexedBond>,
ResolvableTrade<ResolvedCapitalIndexedBondTrade>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TradeInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CapitalIndexedBond product;
    @PropertyDefinition(overrideGet=true)
    private final double quantity;
    @PropertyDefinition(validate="ArgChecker.notNegative", overrideGet=true)
    private final double price;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    @Override
    public CapitalIndexedBondTrade withInfo(PortfolioItemInfo info) {
        return new CapitalIndexedBondTrade(TradeInfo.from(info), this.product, this.quantity, this.price);
    }

    @Override
    public CapitalIndexedBondTrade withQuantity(double quantity) {
        return new CapitalIndexedBondTrade(this.info, this.product, quantity, this.price);
    }

    @Override
    public CapitalIndexedBondTrade withPrice(double price) {
        return new CapitalIndexedBondTrade(this.info, this.product, this.quantity, price);
    }

    @Override
    public PortfolioItemSummary summarize() {
        String description = this.getSecurityId().getStandardId().getValue() + " x " + SummarizerUtils.value(this.getQuantity());
        return SummarizerUtils.summary(this, ProductType.BOND, description, this.getCurrency());
    }

    @Override
    public ResolvedCapitalIndexedBondTrade resolve(ReferenceData refData) {
        ImmutableBean settlePeriod;
        ResolvedCapitalIndexedBond resolvedProduct = this.product.resolve(refData);
        LocalDate settlementDate = this.calculateSettlementDate(refData);
        double accruedInterest = resolvedProduct.accruedInterest(settlementDate) / this.product.getNotional();
        if (settlementDate.isBefore(resolvedProduct.getStartDate())) {
            throw new IllegalArgumentException("Settlement date must not be before bond starts");
        }
        if (this.product.getYieldConvention().equals((Object)CapitalIndexedBondYieldConvention.GB_IL_FLOAT)) {
            settlePeriod = KnownAmountBondPaymentPeriod.of(Payment.of((Currency)this.product.getCurrency(), (double)(-this.product.getNotional() * this.quantity * (this.price + accruedInterest)), (LocalDate)settlementDate), SchedulePeriod.of((LocalDate)resolvedProduct.getStartDate(), (LocalDate)settlementDate, (LocalDate)this.product.getAccrualSchedule().getStartDate(), (LocalDate)settlementDate));
        } else {
            RateComputation rateComputation = this.product.getRateCalculation().createRateComputation(settlementDate);
            settlePeriod = CapitalIndexedBondPaymentPeriod.builder().startDate(resolvedProduct.getStartDate()).unadjustedStartDate(this.product.getAccrualSchedule().getStartDate()).endDate(settlementDate).rateComputation(rateComputation).currency(this.product.getCurrency()).notional(-this.product.getNotional() * this.quantity * (this.price + accruedInterest)).realCoupon(1.0).build();
        }
        return ResolvedCapitalIndexedBondTrade.builder().info(this.info).product(resolvedProduct).quantity(this.quantity).settlement(ResolvedCapitalIndexedBondSettlement.of(settlementDate, this.price, settlePeriod)).build();
    }

    private LocalDate calculateSettlementDate(ReferenceData refData) {
        if (this.info.getSettlementDate().isPresent()) {
            return this.info.getSettlementDate().get();
        }
        if (this.info.getTradeDate().isPresent()) {
            LocalDate tradeDate = this.info.getTradeDate().get();
            return this.product.getSettlementDateOffset().adjust(tradeDate, refData);
        }
        throw new IllegalStateException("CapitalIndexedBondTrade.resolve() requires either trade date or settlement date");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    CapitalIndexedBondTrade(TradeInfo info, CapitalIndexedBond product, double quantity, double price) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        ArgChecker.notNegative((double)price, (String)"price");
        this.info = info;
        this.product = product;
        this.quantity = quantity;
        this.price = price;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public TradeInfo getInfo() {
        return this.info;
    }

    @Override
    public CapitalIndexedBond getProduct() {
        return this.product;
    }

    @Override
    public double getQuantity() {
        return this.quantity;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CapitalIndexedBondTrade other = (CapitalIndexedBondTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product) && JodaBeanUtils.equal((double)this.quantity, (double)other.quantity) && JodaBeanUtils.equal((double)this.price, (double)other.price);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.quantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.price);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("CapitalIndexedBondTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
        buf.append("price").append('=').append(JodaBeanUtils.toString((Object)this.price));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CapitalIndexedBondTrade> {
        private TradeInfo info;
        private CapitalIndexedBond product;
        private double quantity;
        private double price;

        private Builder() {
            CapitalIndexedBondTrade.applyDefaults(this);
        }

        private Builder(CapitalIndexedBondTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
            this.quantity = beanToCopy.getQuantity();
            this.price = beanToCopy.getPrice();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 106934601: {
                    return this.price;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (TradeInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (CapitalIndexedBond)newValue;
                    break;
                }
                case -1285004149: {
                    this.quantity = (Double)newValue;
                    break;
                }
                case 106934601: {
                    this.price = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CapitalIndexedBondTrade build() {
            return new CapitalIndexedBondTrade(this.info, this.product, this.quantity, this.price);
        }

        public Builder info(TradeInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(CapitalIndexedBond product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public Builder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder price(double price) {
            ArgChecker.notNegative((double)price, (String)"price");
            this.price = price;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("CapitalIndexedBondTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
            buf.append("price").append('=').append(JodaBeanUtils.toString((Object)this.price));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<TradeInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", CapitalIndexedBondTrade.class, TradeInfo.class);
        private final MetaProperty<CapitalIndexedBond> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", CapitalIndexedBondTrade.class, CapitalIndexedBond.class);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quantity", CapitalIndexedBondTrade.class, Double.TYPE);
        private final MetaProperty<Double> price = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"price", CapitalIndexedBondTrade.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product", "quantity", "price"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 106934601: {
                    return this.price;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CapitalIndexedBondTrade> beanType() {
            return CapitalIndexedBondTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<TradeInfo> info() {
            return this.info;
        }

        public MetaProperty<CapitalIndexedBond> product() {
            return this.product;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        public MetaProperty<Double> price() {
            return this.price;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((CapitalIndexedBondTrade)bean).getInfo();
                }
                case -309474065: {
                    return ((CapitalIndexedBondTrade)bean).getProduct();
                }
                case -1285004149: {
                    return ((CapitalIndexedBondTrade)bean).getQuantity();
                }
                case 106934601: {
                    return ((CapitalIndexedBondTrade)bean).getPrice();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

