/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.bond.FixedCouponBond;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondOption;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondSettlement;
import com.opengamma.strata.product.common.LongShort;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FixedCouponBondOption
implements Product,
Resolvable<ResolvedFixedCouponBondOption>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LongShort longShort;
    @PropertyDefinition(validate="notNull")
    private final FixedCouponBond underlying;
    @PropertyDefinition(validate="notNull")
    private final AdjustableDate expiryDate;
    @PropertyDefinition(validate="notNull")
    private final LocalTime expiryTime;
    @PropertyDefinition(validate="notNull")
    private final ZoneId expiryZone;
    @PropertyDefinition
    private final double quantity;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double cleanStrikePrice;
    @PropertyDefinition(validate="notNull")
    private final AdjustableDate settlementDate;
    private static final long serialVersionUID = 1L;

    public Currency getCurrency() {
        return this.underlying.getCurrency();
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderOrEqual((Comparable)this.expiryDate.getUnadjusted(), (Object)this.settlementDate.getUnadjusted(), (String)"expiry date", (String)"settlement date");
    }

    public ResolvedFixedCouponBondOption resolve(ReferenceData refData) {
        return ResolvedFixedCouponBondOption.builder().longShort(this.longShort).underlying(this.underlying.resolve(refData)).expiry(this.expiryDate.adjusted(refData).atTime(this.expiryTime).atZone(this.expiryZone)).quantity(this.quantity).settlement(ResolvedFixedCouponBondSettlement.of(this.settlementDate.adjusted(refData), this.cleanStrikePrice)).build();
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        return ImmutableSet.of((Object)this.getCurrency());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FixedCouponBondOption(LongShort longShort, FixedCouponBond underlying, AdjustableDate expiryDate, LocalTime expiryTime, ZoneId expiryZone, double quantity, double cleanStrikePrice, AdjustableDate settlementDate) {
        JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
        JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
        JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
        ArgChecker.notNegative((double)cleanStrikePrice, (String)"cleanStrikePrice");
        JodaBeanUtils.notNull((Object)settlementDate, (String)"settlementDate");
        this.longShort = longShort;
        this.underlying = underlying;
        this.expiryDate = expiryDate;
        this.expiryTime = expiryTime;
        this.expiryZone = expiryZone;
        this.quantity = quantity;
        this.cleanStrikePrice = cleanStrikePrice;
        this.settlementDate = settlementDate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LongShort getLongShort() {
        return this.longShort;
    }

    public FixedCouponBond getUnderlying() {
        return this.underlying;
    }

    public AdjustableDate getExpiryDate() {
        return this.expiryDate;
    }

    public LocalTime getExpiryTime() {
        return this.expiryTime;
    }

    public ZoneId getExpiryZone() {
        return this.expiryZone;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public double getCleanStrikePrice() {
        return this.cleanStrikePrice;
    }

    public AdjustableDate getSettlementDate() {
        return this.settlementDate;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FixedCouponBondOption other = (FixedCouponBondOption)obj;
            return JodaBeanUtils.equal((Object)((Object)this.longShort), (Object)((Object)other.longShort)) && JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying) && JodaBeanUtils.equal((Object)this.expiryDate, (Object)other.expiryDate) && JodaBeanUtils.equal((Object)this.expiryTime, (Object)other.expiryTime) && JodaBeanUtils.equal((Object)this.expiryZone, (Object)other.expiryZone) && JodaBeanUtils.equal((double)this.quantity, (double)other.quantity) && JodaBeanUtils.equal((double)this.cleanStrikePrice, (double)other.cleanStrikePrice) && JodaBeanUtils.equal((Object)this.settlementDate, (Object)other.settlementDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.longShort));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryZone);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.quantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.cleanStrikePrice);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("FixedCouponBondOption{");
        buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying)).append(',').append(' ');
        buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
        buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
        buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
        buf.append("cleanStrikePrice").append('=').append(JodaBeanUtils.toString((Object)this.cleanStrikePrice)).append(',').append(' ');
        buf.append("settlementDate").append('=').append(JodaBeanUtils.toString((Object)this.settlementDate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FixedCouponBondOption> {
        private LongShort longShort;
        private FixedCouponBond underlying;
        private AdjustableDate expiryDate;
        private LocalTime expiryTime;
        private ZoneId expiryZone;
        private double quantity;
        private double cleanStrikePrice;
        private AdjustableDate settlementDate;

        private Builder() {
        }

        private Builder(FixedCouponBondOption beanToCopy) {
            this.longShort = beanToCopy.getLongShort();
            this.underlying = beanToCopy.getUnderlying();
            this.expiryDate = beanToCopy.getExpiryDate();
            this.expiryTime = beanToCopy.getExpiryTime();
            this.expiryZone = beanToCopy.getExpiryZone();
            this.quantity = beanToCopy.getQuantity();
            this.cleanStrikePrice = beanToCopy.getCleanStrikePrice();
            this.settlementDate = beanToCopy.getSettlementDate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1770633379: {
                    return this.underlying;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 1424472750: {
                    return this.cleanStrikePrice;
                }
                case -295948169: {
                    return this.settlementDate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    this.longShort = (LongShort)((Object)newValue);
                    break;
                }
                case -1770633379: {
                    this.underlying = (FixedCouponBond)newValue;
                    break;
                }
                case -816738431: {
                    this.expiryDate = (AdjustableDate)newValue;
                    break;
                }
                case -816254304: {
                    this.expiryTime = (LocalTime)newValue;
                    break;
                }
                case -816069761: {
                    this.expiryZone = (ZoneId)newValue;
                    break;
                }
                case -1285004149: {
                    this.quantity = (Double)newValue;
                    break;
                }
                case 1424472750: {
                    this.cleanStrikePrice = (Double)newValue;
                    break;
                }
                case -295948169: {
                    this.settlementDate = (AdjustableDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FixedCouponBondOption build() {
            return new FixedCouponBondOption(this.longShort, this.underlying, this.expiryDate, this.expiryTime, this.expiryZone, this.quantity, this.cleanStrikePrice, this.settlementDate);
        }

        public Builder longShort(LongShort longShort) {
            JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
            this.longShort = longShort;
            return this;
        }

        public Builder underlying(FixedCouponBond underlying) {
            JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
            this.underlying = underlying;
            return this;
        }

        public Builder expiryDate(AdjustableDate expiryDate) {
            JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
            this.expiryDate = expiryDate;
            return this;
        }

        public Builder expiryTime(LocalTime expiryTime) {
            JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
            this.expiryTime = expiryTime;
            return this;
        }

        public Builder expiryZone(ZoneId expiryZone) {
            JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
            this.expiryZone = expiryZone;
            return this;
        }

        public Builder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder cleanStrikePrice(double cleanStrikePrice) {
            ArgChecker.notNegative((double)cleanStrikePrice, (String)"cleanStrikePrice");
            this.cleanStrikePrice = cleanStrikePrice;
            return this;
        }

        public Builder settlementDate(AdjustableDate settlementDate) {
            JodaBeanUtils.notNull((Object)settlementDate, (String)"settlementDate");
            this.settlementDate = settlementDate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("FixedCouponBondOption.Builder{");
            buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying)).append(',').append(' ');
            buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
            buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
            buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
            buf.append("cleanStrikePrice").append('=').append(JodaBeanUtils.toString((Object)this.cleanStrikePrice)).append(',').append(' ');
            buf.append("settlementDate").append('=').append(JodaBeanUtils.toString((Object)this.settlementDate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LongShort> longShort = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longShort", FixedCouponBondOption.class, LongShort.class);
        private final MetaProperty<FixedCouponBond> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", FixedCouponBondOption.class, FixedCouponBond.class);
        private final MetaProperty<AdjustableDate> expiryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryDate", FixedCouponBondOption.class, AdjustableDate.class);
        private final MetaProperty<LocalTime> expiryTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryTime", FixedCouponBondOption.class, LocalTime.class);
        private final MetaProperty<ZoneId> expiryZone = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryZone", FixedCouponBondOption.class, ZoneId.class);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quantity", FixedCouponBondOption.class, Double.TYPE);
        private final MetaProperty<Double> cleanStrikePrice = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cleanStrikePrice", FixedCouponBondOption.class, Double.TYPE);
        private final MetaProperty<AdjustableDate> settlementDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDate", FixedCouponBondOption.class, AdjustableDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"longShort", "underlying", "expiryDate", "expiryTime", "expiryZone", "quantity", "cleanStrikePrice", "settlementDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1770633379: {
                    return this.underlying;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 1424472750: {
                    return this.cleanStrikePrice;
                }
                case -295948169: {
                    return this.settlementDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FixedCouponBondOption> beanType() {
            return FixedCouponBondOption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LongShort> longShort() {
            return this.longShort;
        }

        public MetaProperty<FixedCouponBond> underlying() {
            return this.underlying;
        }

        public MetaProperty<AdjustableDate> expiryDate() {
            return this.expiryDate;
        }

        public MetaProperty<LocalTime> expiryTime() {
            return this.expiryTime;
        }

        public MetaProperty<ZoneId> expiryZone() {
            return this.expiryZone;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        public MetaProperty<Double> cleanStrikePrice() {
            return this.cleanStrikePrice;
        }

        public MetaProperty<AdjustableDate> settlementDate() {
            return this.settlementDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return ((FixedCouponBondOption)bean).getLongShort();
                }
                case -1770633379: {
                    return ((FixedCouponBondOption)bean).getUnderlying();
                }
                case -816738431: {
                    return ((FixedCouponBondOption)bean).getExpiryDate();
                }
                case -816254304: {
                    return ((FixedCouponBondOption)bean).getExpiryTime();
                }
                case -816069761: {
                    return ((FixedCouponBondOption)bean).getExpiryZone();
                }
                case -1285004149: {
                    return ((FixedCouponBondOption)bean).getQuantity();
                }
                case 1424472750: {
                    return ((FixedCouponBondOption)bean).getCleanStrikePrice();
                }
                case -295948169: {
                    return ((FixedCouponBondOption)bean).getSettlementDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

