/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.bond.FixedCouponBond;
import com.opengamma.strata.product.bond.FixedCouponBondPosition;
import com.opengamma.strata.product.bond.FixedCouponBondTrade;
import com.opengamma.strata.product.bond.FixedCouponBondYieldConvention;
import com.opengamma.strata.product.bond.LegalEntitySecurity;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FixedCouponBondSecurity
implements LegalEntitySecurity,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final PeriodicSchedule accrualSchedule;
    @PropertyDefinition
    private final double fixedRate;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final FixedCouponBondYieldConvention yieldConvention;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LegalEntityId legalEntityId;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment settlementDateOffset;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment exCouponPeriod;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.exCouponPeriod = DaysAdjustment.NONE;
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((this.settlementDateOffset.getDays() >= 0 ? 1 : 0) != 0, (String)"The settlement date offset must be non-negative");
        ArgChecker.isTrue((this.exCouponPeriod.getDays() <= 0 ? 1 : 0) != 0, (String)"The ex-coupon period is measured from the payment date, thus the days must be non-positive");
    }

    @Override
    public ImmutableSet<SecurityId> getUnderlyingIds() {
        return ImmutableSet.of();
    }

    @Override
    public FixedCouponBondSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public FixedCouponBond createProduct(ReferenceData refData) {
        return new FixedCouponBond(this.getSecurityId(), this.currency, this.notional, this.accrualSchedule, this.fixedRate, this.dayCount, this.yieldConvention, this.legalEntityId, this.settlementDateOffset, this.exCouponPeriod);
    }

    @Override
    public FixedCouponBondTrade createTrade(TradeInfo info, double quantity, double tradePrice, ReferenceData refData) {
        return new FixedCouponBondTrade(info, this.createProduct(refData), quantity, tradePrice);
    }

    @Override
    public FixedCouponBondPosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return FixedCouponBondPosition.ofNet(positionInfo, this.createProduct(refData), quantity);
    }

    @Override
    public FixedCouponBondPosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return FixedCouponBondPosition.ofLongShort(positionInfo, this.createProduct(refData), longQuantity, shortQuantity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FixedCouponBondSecurity(SecurityInfo info, Currency currency, double notional, PeriodicSchedule accrualSchedule, double fixedRate, DayCount dayCount, FixedCouponBondYieldConvention yieldConvention, LegalEntityId legalEntityId, DaysAdjustment settlementDateOffset, DaysAdjustment exCouponPeriod) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)accrualSchedule, (String)"accrualSchedule");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        JodaBeanUtils.notNull((Object)exCouponPeriod, (String)"exCouponPeriod");
        this.info = info;
        this.currency = currency;
        this.notional = notional;
        this.accrualSchedule = accrualSchedule;
        this.fixedRate = fixedRate;
        this.dayCount = dayCount;
        this.yieldConvention = yieldConvention;
        this.legalEntityId = legalEntityId;
        this.settlementDateOffset = settlementDateOffset;
        this.exCouponPeriod = exCouponPeriod;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public PeriodicSchedule getAccrualSchedule() {
        return this.accrualSchedule;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public FixedCouponBondYieldConvention getYieldConvention() {
        return this.yieldConvention;
    }

    @Override
    public LegalEntityId getLegalEntityId() {
        return this.legalEntityId;
    }

    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public DaysAdjustment getExCouponPeriod() {
        return this.exCouponPeriod;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FixedCouponBondSecurity other = (FixedCouponBondSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.accrualSchedule, (Object)other.accrualSchedule) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.yieldConvention), (Object)((Object)other.yieldConvention)) && JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset) && JodaBeanUtils.equal((Object)this.exCouponPeriod, (Object)other.exCouponPeriod);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yieldConvention));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.exCouponPeriod);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("FixedCouponBondSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("accrualSchedule").append('=').append(JodaBeanUtils.toString((Object)this.accrualSchedule)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset)).append(',').append(' ');
        buf.append("exCouponPeriod").append('=').append(JodaBeanUtils.toString((Object)this.exCouponPeriod));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FixedCouponBondSecurity> {
        private SecurityInfo info;
        private Currency currency;
        private double notional;
        private PeriodicSchedule accrualSchedule;
        private double fixedRate;
        private DayCount dayCount;
        private FixedCouponBondYieldConvention yieldConvention;
        private LegalEntityId legalEntityId;
        private DaysAdjustment settlementDateOffset;
        private DaysAdjustment exCouponPeriod;

        private Builder() {
            FixedCouponBondSecurity.applyDefaults(this);
        }

        private Builder(FixedCouponBondSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.accrualSchedule = beanToCopy.getAccrualSchedule();
            this.fixedRate = beanToCopy.getFixedRate();
            this.dayCount = beanToCopy.getDayCount();
            this.yieldConvention = beanToCopy.getYieldConvention();
            this.legalEntityId = beanToCopy.getLegalEntityId();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
            this.exCouponPeriod = beanToCopy.getExCouponPeriod();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 304659814: {
                    return this.accrualSchedule;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
                case 1408037338: {
                    return this.exCouponPeriod;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case 304659814: {
                    this.accrualSchedule = (PeriodicSchedule)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -1895216418: {
                    this.yieldConvention = (FixedCouponBondYieldConvention)((Object)newValue);
                    break;
                }
                case 866287159: {
                    this.legalEntityId = (LegalEntityId)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1408037338: {
                    this.exCouponPeriod = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FixedCouponBondSecurity build() {
            return new FixedCouponBondSecurity(this.info, this.currency, this.notional, this.accrualSchedule, this.fixedRate, this.dayCount, this.yieldConvention, this.legalEntityId, this.settlementDateOffset, this.exCouponPeriod);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder accrualSchedule(PeriodicSchedule accrualSchedule) {
            JodaBeanUtils.notNull((Object)accrualSchedule, (String)"accrualSchedule");
            this.accrualSchedule = accrualSchedule;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder yieldConvention(FixedCouponBondYieldConvention yieldConvention) {
            JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
            this.yieldConvention = yieldConvention;
            return this;
        }

        public Builder legalEntityId(LegalEntityId legalEntityId) {
            JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
            this.legalEntityId = legalEntityId;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public Builder exCouponPeriod(DaysAdjustment exCouponPeriod) {
            JodaBeanUtils.notNull((Object)exCouponPeriod, (String)"exCouponPeriod");
            this.exCouponPeriod = exCouponPeriod;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("FixedCouponBondSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("accrualSchedule").append('=').append(JodaBeanUtils.toString((Object)this.accrualSchedule)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset)).append(',').append(' ');
            buf.append("exCouponPeriod").append('=').append(JodaBeanUtils.toString((Object)this.exCouponPeriod));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", FixedCouponBondSecurity.class, SecurityInfo.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", FixedCouponBondSecurity.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", FixedCouponBondSecurity.class, Double.TYPE);
        private final MetaProperty<PeriodicSchedule> accrualSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualSchedule", FixedCouponBondSecurity.class, PeriodicSchedule.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", FixedCouponBondSecurity.class, Double.TYPE);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", FixedCouponBondSecurity.class, DayCount.class);
        private final MetaProperty<FixedCouponBondYieldConvention> yieldConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yieldConvention", FixedCouponBondSecurity.class, FixedCouponBondYieldConvention.class);
        private final MetaProperty<LegalEntityId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", FixedCouponBondSecurity.class, LegalEntityId.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", FixedCouponBondSecurity.class, DaysAdjustment.class);
        private final MetaProperty<DaysAdjustment> exCouponPeriod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"exCouponPeriod", FixedCouponBondSecurity.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "currency", "notional", "accrualSchedule", "fixedRate", "dayCount", "yieldConvention", "legalEntityId", "settlementDateOffset", "exCouponPeriod"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 304659814: {
                    return this.accrualSchedule;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
                case 1408037338: {
                    return this.exCouponPeriod;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FixedCouponBondSecurity> beanType() {
            return FixedCouponBondSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<PeriodicSchedule> accrualSchedule() {
            return this.accrualSchedule;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<FixedCouponBondYieldConvention> yieldConvention() {
            return this.yieldConvention;
        }

        public MetaProperty<LegalEntityId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        public MetaProperty<DaysAdjustment> exCouponPeriod() {
            return this.exCouponPeriod;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((FixedCouponBondSecurity)bean).getInfo();
                }
                case 575402001: {
                    return ((FixedCouponBondSecurity)bean).getCurrency();
                }
                case 1585636160: {
                    return ((FixedCouponBondSecurity)bean).getNotional();
                }
                case 304659814: {
                    return ((FixedCouponBondSecurity)bean).getAccrualSchedule();
                }
                case 747425396: {
                    return ((FixedCouponBondSecurity)bean).getFixedRate();
                }
                case 1905311443: {
                    return ((FixedCouponBondSecurity)bean).getDayCount();
                }
                case -1895216418: {
                    return ((FixedCouponBondSecurity)bean).getYieldConvention();
                }
                case 866287159: {
                    return ((FixedCouponBondSecurity)bean).getLegalEntityId();
                }
                case 135924714: {
                    return ((FixedCouponBondSecurity)bean).getSettlementDateOffset();
                }
                case 1408037338: {
                    return ((FixedCouponBondSecurity)bean).getExCouponPeriod();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

