/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.bond.BondPaymentPeriod;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class KnownAmountBondPaymentPeriod
implements BondPaymentPeriod,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Payment payment;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedEndDate;
    private static final long serialVersionUID = 1L;

    public static KnownAmountBondPaymentPeriod of(Payment payment, SchedulePeriod period) {
        return KnownAmountBondPaymentPeriod.builder().payment(payment).startDate(period.getStartDate()).endDate(period.getEndDate()).unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate()).build();
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.unadjustedStartDate == null && builder.startDate != null) {
            builder.unadjustedStartDate = builder.startDate;
        }
        if (builder.unadjustedEndDate == null && builder.endDate != null) {
            builder.unadjustedEndDate = builder.endDate;
        }
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
        ArgChecker.inOrderNotEqual((Comparable)this.unadjustedStartDate, (Object)this.unadjustedEndDate, (String)"unadjustedStartDate", (String)"unadjustedEndDate");
    }

    @Override
    public LocalDate getPaymentDate() {
        return this.payment.getDate();
    }

    @Override
    public Currency getCurrency() {
        return this.payment.getCurrency();
    }

    @Override
    public KnownAmountBondPaymentPeriod adjustPaymentDate(TemporalAdjuster adjuster) {
        Payment adjusted = this.payment.adjustDate(adjuster);
        return adjusted == this.payment ? this : this.toBuilder().payment(adjusted).build();
    }

    @Override
    public void collectIndices(ImmutableSet.Builder<Index> builder) {
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private KnownAmountBondPaymentPeriod(Payment payment, LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate) {
        JodaBeanUtils.notNull((Object)payment, (String)"payment");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
        JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
        this.payment = payment;
        this.startDate = startDate;
        this.endDate = endDate;
        this.unadjustedStartDate = unadjustedStartDate;
        this.unadjustedEndDate = unadjustedEndDate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Payment getPayment() {
        return this.payment;
    }

    @Override
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Override
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalDate getUnadjustedStartDate() {
        return this.unadjustedStartDate;
    }

    public LocalDate getUnadjustedEndDate() {
        return this.unadjustedEndDate;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            KnownAmountBondPaymentPeriod other = (KnownAmountBondPaymentPeriod)obj;
            return JodaBeanUtils.equal((Object)this.payment, (Object)other.payment) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.unadjustedStartDate, (Object)other.unadjustedStartDate) && JodaBeanUtils.equal((Object)this.unadjustedEndDate, (Object)other.unadjustedEndDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.payment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedEndDate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("KnownAmountBondPaymentPeriod{");
        buf.append("payment").append('=').append(JodaBeanUtils.toString((Object)this.payment)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
        buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<KnownAmountBondPaymentPeriod> {
        private Payment payment;
        private LocalDate startDate;
        private LocalDate endDate;
        private LocalDate unadjustedStartDate;
        private LocalDate unadjustedEndDate;

        private Builder() {
        }

        private Builder(KnownAmountBondPaymentPeriod beanToCopy) {
            this.payment = beanToCopy.getPayment();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.unadjustedStartDate = beanToCopy.getUnadjustedStartDate();
            this.unadjustedEndDate = beanToCopy.getUnadjustedEndDate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return this.payment;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    this.payment = (Payment)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 1457691881: {
                    this.unadjustedStartDate = (LocalDate)newValue;
                    break;
                }
                case 31758114: {
                    this.unadjustedEndDate = (LocalDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public KnownAmountBondPaymentPeriod build() {
            KnownAmountBondPaymentPeriod.preBuild(this);
            return new KnownAmountBondPaymentPeriod(this.payment, this.startDate, this.endDate, this.unadjustedStartDate, this.unadjustedEndDate);
        }

        public Builder payment(Payment payment) {
            JodaBeanUtils.notNull((Object)payment, (String)"payment");
            this.payment = payment;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder unadjustedStartDate(LocalDate unadjustedStartDate) {
            JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
            this.unadjustedStartDate = unadjustedStartDate;
            return this;
        }

        public Builder unadjustedEndDate(LocalDate unadjustedEndDate) {
            JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
            this.unadjustedEndDate = unadjustedEndDate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("KnownAmountBondPaymentPeriod.Builder{");
            buf.append("payment").append('=').append(JodaBeanUtils.toString((Object)this.payment)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
            buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Payment> payment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payment", KnownAmountBondPaymentPeriod.class, Payment.class);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", KnownAmountBondPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", KnownAmountBondPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedStartDate", KnownAmountBondPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedEndDate", KnownAmountBondPaymentPeriod.class, LocalDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payment", "startDate", "endDate", "unadjustedStartDate", "unadjustedEndDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return this.payment;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends KnownAmountBondPaymentPeriod> beanType() {
            return KnownAmountBondPaymentPeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Payment> payment() {
            return this.payment;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<LocalDate> unadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        public MetaProperty<LocalDate> unadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -786681338: {
                    return ((KnownAmountBondPaymentPeriod)bean).getPayment();
                }
                case -2129778896: {
                    return ((KnownAmountBondPaymentPeriod)bean).getStartDate();
                }
                case -1607727319: {
                    return ((KnownAmountBondPaymentPeriod)bean).getEndDate();
                }
                case 1457691881: {
                    return ((KnownAmountBondPaymentPeriod)bean).getUnadjustedStartDate();
                }
                case 31758114: {
                    return ((KnownAmountBondPaymentPeriod)bean).getUnadjustedEndDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

