/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.bond.ResolvedBill;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class ResolvedBillTrade
implements ResolvedTrade,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PortfolioItemInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ResolvedBill product;
    @PropertyDefinition
    private final double quantity;
    @PropertyDefinition(get="optional")
    private final Payment settlement;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.settlement != null) {
            ArgChecker.isTrue((builder.quantity * builder.settlement.getAmount() <= 0.0 ? 1 : 0) != 0);
        }
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    ResolvedBillTrade(PortfolioItemInfo info, ResolvedBill product, double quantity, Payment settlement) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        this.info = info;
        this.product = product;
        this.quantity = quantity;
        this.settlement = settlement;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PortfolioItemInfo getInfo() {
        return this.info;
    }

    @Override
    public ResolvedBill getProduct() {
        return this.product;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public Optional<Payment> getSettlement() {
        return Optional.ofNullable(this.settlement);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedBillTrade other = (ResolvedBillTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product) && JodaBeanUtils.equal((double)this.quantity, (double)other.quantity) && JodaBeanUtils.equal((Object)this.settlement, (Object)other.settlement);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.quantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlement);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("ResolvedBillTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
        buf.append("settlement").append('=').append(JodaBeanUtils.toString((Object)this.settlement));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedBillTrade> {
        private PortfolioItemInfo info;
        private ResolvedBill product;
        private double quantity;
        private Payment settlement;

        private Builder() {
            ResolvedBillTrade.applyDefaults(this);
        }

        private Builder(ResolvedBillTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
            this.quantity = beanToCopy.getQuantity();
            this.settlement = beanToCopy.settlement;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 73828649: {
                    return this.settlement;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (PortfolioItemInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (ResolvedBill)newValue;
                    break;
                }
                case -1285004149: {
                    this.quantity = (Double)newValue;
                    break;
                }
                case 73828649: {
                    this.settlement = (Payment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedBillTrade build() {
            ResolvedBillTrade.preBuild(this);
            return new ResolvedBillTrade(this.info, this.product, this.quantity, this.settlement);
        }

        public Builder info(PortfolioItemInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(ResolvedBill product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public Builder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder settlement(Payment settlement) {
            this.settlement = settlement;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ResolvedBillTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
            buf.append("settlement").append('=').append(JodaBeanUtils.toString((Object)this.settlement));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PortfolioItemInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", ResolvedBillTrade.class, PortfolioItemInfo.class);
        private final MetaProperty<ResolvedBill> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", ResolvedBillTrade.class, ResolvedBill.class);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quantity", ResolvedBillTrade.class, Double.TYPE);
        private final MetaProperty<Payment> settlement = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlement", ResolvedBillTrade.class, Payment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product", "quantity", "settlement"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 73828649: {
                    return this.settlement;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedBillTrade> beanType() {
            return ResolvedBillTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PortfolioItemInfo> info() {
            return this.info;
        }

        public MetaProperty<ResolvedBill> product() {
            return this.product;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        public MetaProperty<Payment> settlement() {
            return this.settlement;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((ResolvedBillTrade)bean).getInfo();
                }
                case -309474065: {
                    return ((ResolvedBillTrade)bean).getProduct();
                }
                case -1285004149: {
                    return ((ResolvedBillTrade)bean).getQuantity();
                }
                case 73828649: {
                    return ((ResolvedBillTrade)bean).settlement;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

