/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.bond.CapitalIndexedBondPaymentPeriod;
import com.opengamma.strata.product.bond.CapitalIndexedBondYieldConvention;
import com.opengamma.strata.product.swap.InflationRateCalculation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedCapitalIndexedBond
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SecurityId securityId;
    @PropertyDefinition(validate="notNull")
    private final CapitalIndexedBondPaymentPeriod nominalPayment;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<CapitalIndexedBondPaymentPeriod> periodicPayments;
    @PropertyDefinition(validate="notNull")
    private final Frequency frequency;
    @PropertyDefinition(validate="notNull")
    private final RollConvention rollConvention;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final CapitalIndexedBondYieldConvention yieldConvention;
    @PropertyDefinition(validate="notNull")
    private final LegalEntityId legalEntityId;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment settlementDateOffset;
    @PropertyDefinition(validate="notNull")
    private final InflationRateCalculation rateCalculation;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        Currency currencyNominal = this.nominalPayment.getCurrency();
        Set currencies = this.periodicPayments.stream().map(CapitalIndexedBondPaymentPeriod::getCurrency).collect(Collectors.toSet());
        currencies.add(currencyNominal);
        ArgChecker.isTrue((currencies.size() == 1 ? 1 : 0) != 0, (String)("Product must have a single currency, found: " + currencies));
        ArgChecker.isTrue((boolean)this.rateCalculation.getFirstIndexValue().isPresent(), (String)"Rate calculation must specify first index value");
    }

    public LocalDate getStartDate() {
        return ((CapitalIndexedBondPaymentPeriod)this.periodicPayments.get(0)).getStartDate();
    }

    public LocalDate getEndDate() {
        return ((CapitalIndexedBondPaymentPeriod)this.periodicPayments.get(this.periodicPayments.size() - 1)).getEndDate();
    }

    public LocalDate getUnadjustedStartDate() {
        return ((CapitalIndexedBondPaymentPeriod)this.periodicPayments.get(0)).getUnadjustedStartDate();
    }

    public LocalDate getUnadjustedEndDate() {
        return ((CapitalIndexedBondPaymentPeriod)this.periodicPayments.get(this.periodicPayments.size() - 1)).getUnadjustedEndDate();
    }

    public Currency getCurrency() {
        return this.nominalPayment.getCurrency();
    }

    public double getNotional() {
        return ((CapitalIndexedBondPaymentPeriod)this.periodicPayments.get(0)).getNotional();
    }

    public boolean hasExCouponPeriod() {
        return ((CapitalIndexedBondPaymentPeriod)this.periodicPayments.get(0)).hasExCouponPeriod();
    }

    public double getFirstIndexValue() {
        return this.rateCalculation.getFirstIndexValue().getAsDouble();
    }

    public Optional<CapitalIndexedBondPaymentPeriod> findPeriod(LocalDate date) {
        return this.periodicPayments.stream().filter(p -> p.contains(date)).reduce(Guavate.ensureOnlyOne());
    }

    public OptionalInt findPeriodIndex(LocalDate date) {
        for (int i = 0; i < this.periodicPayments.size(); ++i) {
            if (!((CapitalIndexedBondPaymentPeriod)this.periodicPayments.get(i)).contains(date)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public double yearFraction(LocalDate startDate, LocalDate endDate) {
        return this.yearFraction(startDate, endDate, this.dayCount);
    }

    public double yearFraction(LocalDate startDate, LocalDate endDate, DayCount dayCount) {
        ArgChecker.inOrderOrEqual((Comparable)this.getUnadjustedStartDate(), (Object)startDate, (String)"bond.unadjustedStartDate", (String)"startDate");
        ArgChecker.inOrderOrEqual((Comparable)startDate, (Object)endDate, (String)"startDate", (String)"endDate");
        ArgChecker.inOrderOrEqual((Comparable)endDate, (Object)this.getUnadjustedEndDate(), (String)"endDate", (String)"bond.unadjustedEndDate");
        DayCount.ScheduleInfo info = new DayCount.ScheduleInfo(){

            public LocalDate getStartDate() {
                return ResolvedCapitalIndexedBond.this.getUnadjustedStartDate();
            }

            public LocalDate getEndDate() {
                return ResolvedCapitalIndexedBond.this.getUnadjustedEndDate();
            }

            public Frequency getFrequency() {
                return ResolvedCapitalIndexedBond.this.frequency;
            }

            public LocalDate getPeriodEndDate(LocalDate date) {
                return ResolvedCapitalIndexedBond.this.periodicPayments.stream().filter(p -> p.contains(date)).map(p -> p.getUnadjustedEndDate()).findFirst().orElseThrow(() -> new IllegalArgumentException("Date is not contained in any period"));
            }

            public boolean isEndOfMonthConvention() {
                return ResolvedCapitalIndexedBond.this.rollConvention == RollConventions.EOM;
            }
        };
        return dayCount.yearFraction(startDate, endDate, info);
    }

    public LocalDate calculateSettlementDateFromValuation(LocalDate valuationDate, ReferenceData refData) {
        return this.settlementDateOffset.adjust(valuationDate, refData);
    }

    public double accruedInterest(LocalDate referenceDate) {
        if (this.getUnadjustedStartDate().isAfter(referenceDate)) {
            return 0.0;
        }
        double notional = this.getNotional();
        CapitalIndexedBondPaymentPeriod period = this.findPeriod(referenceDate).orElseThrow(() -> new IllegalArgumentException("Date outside range of bond"));
        LocalDate previousAccrualDate = period.getUnadjustedStartDate();
        double realCoupon = period.getRealCoupon();
        double couponPerYear = this.getFrequency().eventsPerYear();
        double rate = realCoupon * couponPerYear;
        double accruedInterest = this.yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.JP_IL_COMPOUND) || this.yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.JP_IL_SIMPLE) ? this.yearFraction(previousAccrualDate, referenceDate, DayCounts.ACT_365F) * rate * notional : this.yearFraction(previousAccrualDate, referenceDate) * rate * notional;
        double result = 0.0;
        result = this.hasExCouponPeriod() && !referenceDate.isBefore(period.getDetachmentDate()) ? accruedInterest - notional * rate * this.yearFraction(previousAccrualDate, period.getUnadjustedEndDate()) : accruedInterest;
        return result;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResolvedCapitalIndexedBond(SecurityId securityId, CapitalIndexedBondPaymentPeriod nominalPayment, List<CapitalIndexedBondPaymentPeriod> periodicPayments, Frequency frequency, RollConvention rollConvention, DayCount dayCount, CapitalIndexedBondYieldConvention yieldConvention, LegalEntityId legalEntityId, DaysAdjustment settlementDateOffset, InflationRateCalculation rateCalculation) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)nominalPayment, (String)"nominalPayment");
        JodaBeanUtils.notNull(periodicPayments, (String)"periodicPayments");
        JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
        JodaBeanUtils.notNull((Object)rollConvention, (String)"rollConvention");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        JodaBeanUtils.notNull((Object)rateCalculation, (String)"rateCalculation");
        this.securityId = securityId;
        this.nominalPayment = nominalPayment;
        this.periodicPayments = ImmutableList.copyOf(periodicPayments);
        this.frequency = frequency;
        this.rollConvention = rollConvention;
        this.dayCount = dayCount;
        this.yieldConvention = yieldConvention;
        this.legalEntityId = legalEntityId;
        this.settlementDateOffset = settlementDateOffset;
        this.rateCalculation = rateCalculation;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public CapitalIndexedBondPaymentPeriod getNominalPayment() {
        return this.nominalPayment;
    }

    public ImmutableList<CapitalIndexedBondPaymentPeriod> getPeriodicPayments() {
        return this.periodicPayments;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public RollConvention getRollConvention() {
        return this.rollConvention;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public CapitalIndexedBondYieldConvention getYieldConvention() {
        return this.yieldConvention;
    }

    public LegalEntityId getLegalEntityId() {
        return this.legalEntityId;
    }

    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public InflationRateCalculation getRateCalculation() {
        return this.rateCalculation;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedCapitalIndexedBond other = (ResolvedCapitalIndexedBond)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)this.nominalPayment, (Object)other.nominalPayment) && JodaBeanUtils.equal(this.periodicPayments, other.periodicPayments) && JodaBeanUtils.equal((Object)this.frequency, (Object)other.frequency) && JodaBeanUtils.equal((Object)this.rollConvention, (Object)other.rollConvention) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.yieldConvention), (Object)((Object)other.yieldConvention)) && JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset) && JodaBeanUtils.equal((Object)this.rateCalculation, (Object)other.rateCalculation);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.nominalPayment);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.periodicPayments);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.frequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rollConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yieldConvention));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rateCalculation);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("ResolvedCapitalIndexedBond{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("nominalPayment").append('=').append(JodaBeanUtils.toString((Object)this.nominalPayment)).append(',').append(' ');
        buf.append("periodicPayments").append('=').append(JodaBeanUtils.toString(this.periodicPayments)).append(',').append(' ');
        buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
        buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset)).append(',').append(' ');
        buf.append("rateCalculation").append('=').append(JodaBeanUtils.toString((Object)this.rateCalculation));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedCapitalIndexedBond> {
        private SecurityId securityId;
        private CapitalIndexedBondPaymentPeriod nominalPayment;
        private List<CapitalIndexedBondPaymentPeriod> periodicPayments = ImmutableList.of();
        private Frequency frequency;
        private RollConvention rollConvention;
        private DayCount dayCount;
        private CapitalIndexedBondYieldConvention yieldConvention;
        private LegalEntityId legalEntityId;
        private DaysAdjustment settlementDateOffset;
        private InflationRateCalculation rateCalculation;

        private Builder() {
        }

        private Builder(ResolvedCapitalIndexedBond beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.nominalPayment = beanToCopy.getNominalPayment();
            this.periodicPayments = beanToCopy.getPeriodicPayments();
            this.frequency = beanToCopy.getFrequency();
            this.rollConvention = beanToCopy.getRollConvention();
            this.dayCount = beanToCopy.getDayCount();
            this.yieldConvention = beanToCopy.getYieldConvention();
            this.legalEntityId = beanToCopy.getLegalEntityId();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
            this.rateCalculation = beanToCopy.getRateCalculation();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case -44199542: {
                    return this.nominalPayment;
                }
                case -367345944: {
                    return this.periodicPayments;
                }
                case -70023844: {
                    return this.frequency;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
                case -521703991: {
                    return this.rateCalculation;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case -44199542: {
                    this.nominalPayment = (CapitalIndexedBondPaymentPeriod)newValue;
                    break;
                }
                case -367345944: {
                    this.periodicPayments = (List)newValue;
                    break;
                }
                case -70023844: {
                    this.frequency = (Frequency)newValue;
                    break;
                }
                case -10223666: {
                    this.rollConvention = (RollConvention)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -1895216418: {
                    this.yieldConvention = (CapitalIndexedBondYieldConvention)((Object)newValue);
                    break;
                }
                case 866287159: {
                    this.legalEntityId = (LegalEntityId)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -521703991: {
                    this.rateCalculation = (InflationRateCalculation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedCapitalIndexedBond build() {
            return new ResolvedCapitalIndexedBond(this.securityId, this.nominalPayment, this.periodicPayments, this.frequency, this.rollConvention, this.dayCount, this.yieldConvention, this.legalEntityId, this.settlementDateOffset, this.rateCalculation);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder nominalPayment(CapitalIndexedBondPaymentPeriod nominalPayment) {
            JodaBeanUtils.notNull((Object)nominalPayment, (String)"nominalPayment");
            this.nominalPayment = nominalPayment;
            return this;
        }

        public Builder periodicPayments(List<CapitalIndexedBondPaymentPeriod> periodicPayments) {
            JodaBeanUtils.notNull(periodicPayments, (String)"periodicPayments");
            this.periodicPayments = periodicPayments;
            return this;
        }

        public Builder periodicPayments(CapitalIndexedBondPaymentPeriod ... periodicPayments) {
            return this.periodicPayments((List<CapitalIndexedBondPaymentPeriod>)ImmutableList.copyOf((Object[])periodicPayments));
        }

        public Builder frequency(Frequency frequency) {
            JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
            this.frequency = frequency;
            return this;
        }

        public Builder rollConvention(RollConvention rollConvention) {
            JodaBeanUtils.notNull((Object)rollConvention, (String)"rollConvention");
            this.rollConvention = rollConvention;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder yieldConvention(CapitalIndexedBondYieldConvention yieldConvention) {
            JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
            this.yieldConvention = yieldConvention;
            return this;
        }

        public Builder legalEntityId(LegalEntityId legalEntityId) {
            JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
            this.legalEntityId = legalEntityId;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public Builder rateCalculation(InflationRateCalculation rateCalculation) {
            JodaBeanUtils.notNull((Object)rateCalculation, (String)"rateCalculation");
            this.rateCalculation = rateCalculation;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("ResolvedCapitalIndexedBond.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("nominalPayment").append('=').append(JodaBeanUtils.toString((Object)this.nominalPayment)).append(',').append(' ');
            buf.append("periodicPayments").append('=').append(JodaBeanUtils.toString(this.periodicPayments)).append(',').append(' ');
            buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
            buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset)).append(',').append(' ');
            buf.append("rateCalculation").append('=').append(JodaBeanUtils.toString((Object)this.rateCalculation));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", ResolvedCapitalIndexedBond.class, SecurityId.class);
        private final MetaProperty<CapitalIndexedBondPaymentPeriod> nominalPayment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nominalPayment", ResolvedCapitalIndexedBond.class, CapitalIndexedBondPaymentPeriod.class);
        private final MetaProperty<ImmutableList<CapitalIndexedBondPaymentPeriod>> periodicPayments = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periodicPayments", ResolvedCapitalIndexedBond.class, ImmutableList.class);
        private final MetaProperty<Frequency> frequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"frequency", ResolvedCapitalIndexedBond.class, Frequency.class);
        private final MetaProperty<RollConvention> rollConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rollConvention", ResolvedCapitalIndexedBond.class, RollConvention.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ResolvedCapitalIndexedBond.class, DayCount.class);
        private final MetaProperty<CapitalIndexedBondYieldConvention> yieldConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yieldConvention", ResolvedCapitalIndexedBond.class, CapitalIndexedBondYieldConvention.class);
        private final MetaProperty<LegalEntityId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", ResolvedCapitalIndexedBond.class, LegalEntityId.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", ResolvedCapitalIndexedBond.class, DaysAdjustment.class);
        private final MetaProperty<InflationRateCalculation> rateCalculation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rateCalculation", ResolvedCapitalIndexedBond.class, InflationRateCalculation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "nominalPayment", "periodicPayments", "frequency", "rollConvention", "dayCount", "yieldConvention", "legalEntityId", "settlementDateOffset", "rateCalculation"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case -44199542: {
                    return this.nominalPayment;
                }
                case -367345944: {
                    return this.periodicPayments;
                }
                case -70023844: {
                    return this.frequency;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
                case -521703991: {
                    return this.rateCalculation;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedCapitalIndexedBond> beanType() {
            return ResolvedCapitalIndexedBond.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<CapitalIndexedBondPaymentPeriod> nominalPayment() {
            return this.nominalPayment;
        }

        public MetaProperty<ImmutableList<CapitalIndexedBondPaymentPeriod>> periodicPayments() {
            return this.periodicPayments;
        }

        public MetaProperty<Frequency> frequency() {
            return this.frequency;
        }

        public MetaProperty<RollConvention> rollConvention() {
            return this.rollConvention;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<CapitalIndexedBondYieldConvention> yieldConvention() {
            return this.yieldConvention;
        }

        public MetaProperty<LegalEntityId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        public MetaProperty<InflationRateCalculation> rateCalculation() {
            return this.rateCalculation;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((ResolvedCapitalIndexedBond)bean).getSecurityId();
                }
                case -44199542: {
                    return ((ResolvedCapitalIndexedBond)bean).getNominalPayment();
                }
                case -367345944: {
                    return ((ResolvedCapitalIndexedBond)bean).getPeriodicPayments();
                }
                case -70023844: {
                    return ((ResolvedCapitalIndexedBond)bean).getFrequency();
                }
                case -10223666: {
                    return ((ResolvedCapitalIndexedBond)bean).getRollConvention();
                }
                case 1905311443: {
                    return ((ResolvedCapitalIndexedBond)bean).getDayCount();
                }
                case -1895216418: {
                    return ((ResolvedCapitalIndexedBond)bean).getYieldConvention();
                }
                case 866287159: {
                    return ((ResolvedCapitalIndexedBond)bean).getLegalEntityId();
                }
                case 135924714: {
                    return ((ResolvedCapitalIndexedBond)bean).getSettlementDateOffset();
                }
                case -521703991: {
                    return ((ResolvedCapitalIndexedBond)bean).getRateCalculation();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

