/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.bond.FixedCouponBondPaymentPeriod;
import com.opengamma.strata.product.bond.FixedCouponBondYieldConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class ResolvedFixedCouponBond
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SecurityId securityId;
    @PropertyDefinition(validate="notNull")
    private final Payment nominalPayment;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<FixedCouponBondPaymentPeriod> periodicPayments;
    @PropertyDefinition(validate="notNull")
    private final Frequency frequency;
    @PropertyDefinition(validate="notNull")
    private final RollConvention rollConvention;
    @PropertyDefinition
    private final double fixedRate;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final FixedCouponBondYieldConvention yieldConvention;
    @PropertyDefinition(validate="notNull")
    private final LegalEntityId legalEntityId;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment settlementDateOffset;
    private static final long serialVersionUID = 1L;

    public LocalDate getStartDate() {
        return ((FixedCouponBondPaymentPeriod)this.periodicPayments.get(0)).getStartDate();
    }

    public LocalDate getEndDate() {
        return ((FixedCouponBondPaymentPeriod)this.periodicPayments.get(this.periodicPayments.size() - 1)).getEndDate();
    }

    public LocalDate getUnadjustedStartDate() {
        return ((FixedCouponBondPaymentPeriod)this.periodicPayments.get(0)).getUnadjustedStartDate();
    }

    public LocalDate getUnadjustedEndDate() {
        return ((FixedCouponBondPaymentPeriod)this.periodicPayments.get(this.periodicPayments.size() - 1)).getUnadjustedEndDate();
    }

    public Currency getCurrency() {
        return this.nominalPayment.getCurrency();
    }

    public double getNotional() {
        return this.nominalPayment.getAmount();
    }

    public boolean hasExCouponPeriod() {
        return ((FixedCouponBondPaymentPeriod)this.periodicPayments.get(0)).hasExCouponPeriod();
    }

    public Optional<FixedCouponBondPaymentPeriod> findPeriod(LocalDate date) {
        return this.periodicPayments.stream().filter(p -> p.contains(date)).reduce(Guavate.ensureOnlyOne());
    }

    public double yearFraction(LocalDate startDate, LocalDate endDate) {
        ArgChecker.inOrderOrEqual((Comparable)this.getUnadjustedStartDate(), (Object)startDate, (String)"bond.unadjustedStartDate", (String)"startDate");
        ArgChecker.inOrderOrEqual((Comparable)startDate, (Object)endDate, (String)"startDate", (String)"endDate");
        ArgChecker.inOrderOrEqual((Comparable)endDate, (Object)this.getUnadjustedEndDate(), (String)"endDate", (String)"bond.unadjustedEndDate");
        DayCount.ScheduleInfo info = new DayCount.ScheduleInfo(){

            public LocalDate getStartDate() {
                return ResolvedFixedCouponBond.this.getUnadjustedStartDate();
            }

            public LocalDate getEndDate() {
                return ResolvedFixedCouponBond.this.getUnadjustedEndDate();
            }

            public Frequency getFrequency() {
                return ResolvedFixedCouponBond.this.frequency;
            }

            public LocalDate getPeriodEndDate(LocalDate date) {
                return ResolvedFixedCouponBond.this.periodicPayments.stream().filter(p -> p.contains(date)).map(p -> p.getUnadjustedEndDate()).findFirst().orElseThrow(() -> new IllegalArgumentException("Date is not contained in any period"));
            }

            public boolean isEndOfMonthConvention() {
                return ResolvedFixedCouponBond.this.rollConvention == RollConventions.EOM;
            }
        };
        return this.dayCount.yearFraction(startDate, endDate, info);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    ResolvedFixedCouponBond(SecurityId securityId, Payment nominalPayment, List<FixedCouponBondPaymentPeriod> periodicPayments, Frequency frequency, RollConvention rollConvention, double fixedRate, DayCount dayCount, FixedCouponBondYieldConvention yieldConvention, LegalEntityId legalEntityId, DaysAdjustment settlementDateOffset) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)nominalPayment, (String)"nominalPayment");
        JodaBeanUtils.notNull(periodicPayments, (String)"periodicPayments");
        JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
        JodaBeanUtils.notNull((Object)rollConvention, (String)"rollConvention");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        this.securityId = securityId;
        this.nominalPayment = nominalPayment;
        this.periodicPayments = ImmutableList.copyOf(periodicPayments);
        this.frequency = frequency;
        this.rollConvention = rollConvention;
        this.fixedRate = fixedRate;
        this.dayCount = dayCount;
        this.yieldConvention = yieldConvention;
        this.legalEntityId = legalEntityId;
        this.settlementDateOffset = settlementDateOffset;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public Payment getNominalPayment() {
        return this.nominalPayment;
    }

    public ImmutableList<FixedCouponBondPaymentPeriod> getPeriodicPayments() {
        return this.periodicPayments;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public RollConvention getRollConvention() {
        return this.rollConvention;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public FixedCouponBondYieldConvention getYieldConvention() {
        return this.yieldConvention;
    }

    public LegalEntityId getLegalEntityId() {
        return this.legalEntityId;
    }

    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedFixedCouponBond other = (ResolvedFixedCouponBond)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)this.nominalPayment, (Object)other.nominalPayment) && JodaBeanUtils.equal(this.periodicPayments, other.periodicPayments) && JodaBeanUtils.equal((Object)this.frequency, (Object)other.frequency) && JodaBeanUtils.equal((Object)this.rollConvention, (Object)other.rollConvention) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.yieldConvention), (Object)((Object)other.yieldConvention)) && JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.nominalPayment);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.periodicPayments);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.frequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rollConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yieldConvention));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("ResolvedFixedCouponBond{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("nominalPayment").append('=').append(JodaBeanUtils.toString((Object)this.nominalPayment)).append(',').append(' ');
        buf.append("periodicPayments").append('=').append(JodaBeanUtils.toString(this.periodicPayments)).append(',').append(' ');
        buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
        buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedFixedCouponBond> {
        private SecurityId securityId;
        private Payment nominalPayment;
        private List<FixedCouponBondPaymentPeriod> periodicPayments = ImmutableList.of();
        private Frequency frequency;
        private RollConvention rollConvention;
        private double fixedRate;
        private DayCount dayCount;
        private FixedCouponBondYieldConvention yieldConvention;
        private LegalEntityId legalEntityId;
        private DaysAdjustment settlementDateOffset;

        private Builder() {
        }

        private Builder(ResolvedFixedCouponBond beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.nominalPayment = beanToCopy.getNominalPayment();
            this.periodicPayments = beanToCopy.getPeriodicPayments();
            this.frequency = beanToCopy.getFrequency();
            this.rollConvention = beanToCopy.getRollConvention();
            this.fixedRate = beanToCopy.getFixedRate();
            this.dayCount = beanToCopy.getDayCount();
            this.yieldConvention = beanToCopy.getYieldConvention();
            this.legalEntityId = beanToCopy.getLegalEntityId();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case -44199542: {
                    return this.nominalPayment;
                }
                case -367345944: {
                    return this.periodicPayments;
                }
                case -70023844: {
                    return this.frequency;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case -44199542: {
                    this.nominalPayment = (Payment)newValue;
                    break;
                }
                case -367345944: {
                    this.periodicPayments = (List)newValue;
                    break;
                }
                case -70023844: {
                    this.frequency = (Frequency)newValue;
                    break;
                }
                case -10223666: {
                    this.rollConvention = (RollConvention)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -1895216418: {
                    this.yieldConvention = (FixedCouponBondYieldConvention)((Object)newValue);
                    break;
                }
                case 866287159: {
                    this.legalEntityId = (LegalEntityId)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedFixedCouponBond build() {
            return new ResolvedFixedCouponBond(this.securityId, this.nominalPayment, this.periodicPayments, this.frequency, this.rollConvention, this.fixedRate, this.dayCount, this.yieldConvention, this.legalEntityId, this.settlementDateOffset);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder nominalPayment(Payment nominalPayment) {
            JodaBeanUtils.notNull((Object)nominalPayment, (String)"nominalPayment");
            this.nominalPayment = nominalPayment;
            return this;
        }

        public Builder periodicPayments(List<FixedCouponBondPaymentPeriod> periodicPayments) {
            JodaBeanUtils.notNull(periodicPayments, (String)"periodicPayments");
            this.periodicPayments = periodicPayments;
            return this;
        }

        public Builder periodicPayments(FixedCouponBondPaymentPeriod ... periodicPayments) {
            return this.periodicPayments((List<FixedCouponBondPaymentPeriod>)ImmutableList.copyOf((Object[])periodicPayments));
        }

        public Builder frequency(Frequency frequency) {
            JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
            this.frequency = frequency;
            return this;
        }

        public Builder rollConvention(RollConvention rollConvention) {
            JodaBeanUtils.notNull((Object)rollConvention, (String)"rollConvention");
            this.rollConvention = rollConvention;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder yieldConvention(FixedCouponBondYieldConvention yieldConvention) {
            JodaBeanUtils.notNull((Object)((Object)yieldConvention), (String)"yieldConvention");
            this.yieldConvention = yieldConvention;
            return this;
        }

        public Builder legalEntityId(LegalEntityId legalEntityId) {
            JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
            this.legalEntityId = legalEntityId;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("ResolvedFixedCouponBond.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("nominalPayment").append('=').append(JodaBeanUtils.toString((Object)this.nominalPayment)).append(',').append(' ');
            buf.append("periodicPayments").append('=').append(JodaBeanUtils.toString(this.periodicPayments)).append(',').append(' ');
            buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
            buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("yieldConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yieldConvention))).append(',').append(' ');
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", ResolvedFixedCouponBond.class, SecurityId.class);
        private final MetaProperty<Payment> nominalPayment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nominalPayment", ResolvedFixedCouponBond.class, Payment.class);
        private final MetaProperty<ImmutableList<FixedCouponBondPaymentPeriod>> periodicPayments = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periodicPayments", ResolvedFixedCouponBond.class, ImmutableList.class);
        private final MetaProperty<Frequency> frequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"frequency", ResolvedFixedCouponBond.class, Frequency.class);
        private final MetaProperty<RollConvention> rollConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rollConvention", ResolvedFixedCouponBond.class, RollConvention.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", ResolvedFixedCouponBond.class, Double.TYPE);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ResolvedFixedCouponBond.class, DayCount.class);
        private final MetaProperty<FixedCouponBondYieldConvention> yieldConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yieldConvention", ResolvedFixedCouponBond.class, FixedCouponBondYieldConvention.class);
        private final MetaProperty<LegalEntityId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", ResolvedFixedCouponBond.class, LegalEntityId.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", ResolvedFixedCouponBond.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "nominalPayment", "periodicPayments", "frequency", "rollConvention", "fixedRate", "dayCount", "yieldConvention", "legalEntityId", "settlementDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case -44199542: {
                    return this.nominalPayment;
                }
                case -367345944: {
                    return this.periodicPayments;
                }
                case -70023844: {
                    return this.frequency;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1895216418: {
                    return this.yieldConvention;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedFixedCouponBond> beanType() {
            return ResolvedFixedCouponBond.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<Payment> nominalPayment() {
            return this.nominalPayment;
        }

        public MetaProperty<ImmutableList<FixedCouponBondPaymentPeriod>> periodicPayments() {
            return this.periodicPayments;
        }

        public MetaProperty<Frequency> frequency() {
            return this.frequency;
        }

        public MetaProperty<RollConvention> rollConvention() {
            return this.rollConvention;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<FixedCouponBondYieldConvention> yieldConvention() {
            return this.yieldConvention;
        }

        public MetaProperty<LegalEntityId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((ResolvedFixedCouponBond)bean).getSecurityId();
                }
                case -44199542: {
                    return ((ResolvedFixedCouponBond)bean).getNominalPayment();
                }
                case -367345944: {
                    return ((ResolvedFixedCouponBond)bean).getPeriodicPayments();
                }
                case -70023844: {
                    return ((ResolvedFixedCouponBond)bean).getFrequency();
                }
                case -10223666: {
                    return ((ResolvedFixedCouponBond)bean).getRollConvention();
                }
                case 747425396: {
                    return ((ResolvedFixedCouponBond)bean).getFixedRate();
                }
                case 1905311443: {
                    return ((ResolvedFixedCouponBond)bean).getDayCount();
                }
                case -1895216418: {
                    return ((ResolvedFixedCouponBond)bean).getYieldConvention();
                }
                case 866287159: {
                    return ((ResolvedFixedCouponBond)bean).getLegalEntityId();
                }
                case 135924714: {
                    return ((ResolvedFixedCouponBond)bean).getSettlementDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

