/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBond;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondSettlement;
import com.opengamma.strata.product.common.LongShort;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedFixedCouponBondOption
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LongShort longShort;
    @PropertyDefinition(validate="notNull")
    private final ResolvedFixedCouponBond underlying;
    @PropertyDefinition(validate="notNull")
    private final ZonedDateTime expiry;
    @PropertyDefinition
    private final double quantity;
    @PropertyDefinition(validate="notNull")
    private final ResolvedFixedCouponBondSettlement settlement;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderOrEqual((Comparable)this.expiry.toLocalDate(), (Object)this.settlement.getSettlementDate(), (String)"expiry date", (String)"settlement date");
    }

    public Currency getCurrency() {
        return this.underlying.getCurrency();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResolvedFixedCouponBondOption(LongShort longShort, ResolvedFixedCouponBond underlying, ZonedDateTime expiry, double quantity, ResolvedFixedCouponBondSettlement settlement) {
        JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)settlement, (String)"settlement");
        this.longShort = longShort;
        this.underlying = underlying;
        this.expiry = expiry;
        this.quantity = quantity;
        this.settlement = settlement;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LongShort getLongShort() {
        return this.longShort;
    }

    public ResolvedFixedCouponBond getUnderlying() {
        return this.underlying;
    }

    public ZonedDateTime getExpiry() {
        return this.expiry;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public ResolvedFixedCouponBondSettlement getSettlement() {
        return this.settlement;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedFixedCouponBondOption other = (ResolvedFixedCouponBondOption)obj;
            return JodaBeanUtils.equal((Object)((Object)this.longShort), (Object)((Object)other.longShort)) && JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying) && JodaBeanUtils.equal((Object)this.expiry, (Object)other.expiry) && JodaBeanUtils.equal((double)this.quantity, (double)other.quantity) && JodaBeanUtils.equal((Object)this.settlement, (Object)other.settlement);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.longShort));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.quantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlement);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("ResolvedFixedCouponBondOption{");
        buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
        buf.append("settlement").append('=').append(JodaBeanUtils.toString((Object)this.settlement));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedFixedCouponBondOption> {
        private LongShort longShort;
        private ResolvedFixedCouponBond underlying;
        private ZonedDateTime expiry;
        private double quantity;
        private ResolvedFixedCouponBondSettlement settlement;

        private Builder() {
        }

        private Builder(ResolvedFixedCouponBondOption beanToCopy) {
            this.longShort = beanToCopy.getLongShort();
            this.underlying = beanToCopy.getUnderlying();
            this.expiry = beanToCopy.getExpiry();
            this.quantity = beanToCopy.getQuantity();
            this.settlement = beanToCopy.getSettlement();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1770633379: {
                    return this.underlying;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 73828649: {
                    return this.settlement;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    this.longShort = (LongShort)((Object)newValue);
                    break;
                }
                case -1770633379: {
                    this.underlying = (ResolvedFixedCouponBond)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (ZonedDateTime)newValue;
                    break;
                }
                case -1285004149: {
                    this.quantity = (Double)newValue;
                    break;
                }
                case 73828649: {
                    this.settlement = (ResolvedFixedCouponBondSettlement)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedFixedCouponBondOption build() {
            return new ResolvedFixedCouponBondOption(this.longShort, this.underlying, this.expiry, this.quantity, this.settlement);
        }

        public Builder longShort(LongShort longShort) {
            JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
            this.longShort = longShort;
            return this;
        }

        public Builder underlying(ResolvedFixedCouponBond underlying) {
            JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
            this.underlying = underlying;
            return this;
        }

        public Builder expiry(ZonedDateTime expiry) {
            JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
            this.expiry = expiry;
            return this;
        }

        public Builder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder settlement(ResolvedFixedCouponBondSettlement settlement) {
            JodaBeanUtils.notNull((Object)settlement, (String)"settlement");
            this.settlement = settlement;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ResolvedFixedCouponBondOption.Builder{");
            buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
            buf.append("settlement").append('=').append(JodaBeanUtils.toString((Object)this.settlement));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LongShort> longShort = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longShort", ResolvedFixedCouponBondOption.class, LongShort.class);
        private final MetaProperty<ResolvedFixedCouponBond> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", ResolvedFixedCouponBondOption.class, ResolvedFixedCouponBond.class);
        private final MetaProperty<ZonedDateTime> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", ResolvedFixedCouponBondOption.class, ZonedDateTime.class);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quantity", ResolvedFixedCouponBondOption.class, Double.TYPE);
        private final MetaProperty<ResolvedFixedCouponBondSettlement> settlement = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlement", ResolvedFixedCouponBondOption.class, ResolvedFixedCouponBondSettlement.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"longShort", "underlying", "expiry", "quantity", "settlement"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1770633379: {
                    return this.underlying;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 73828649: {
                    return this.settlement;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedFixedCouponBondOption> beanType() {
            return ResolvedFixedCouponBondOption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LongShort> longShort() {
            return this.longShort;
        }

        public MetaProperty<ResolvedFixedCouponBond> underlying() {
            return this.underlying;
        }

        public MetaProperty<ZonedDateTime> expiry() {
            return this.expiry;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        public MetaProperty<ResolvedFixedCouponBondSettlement> settlement() {
            return this.settlement;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return ((ResolvedFixedCouponBondOption)bean).getLongShort();
                }
                case -1770633379: {
                    return ((ResolvedFixedCouponBondOption)bean).getUnderlying();
                }
                case -1289159373: {
                    return ((ResolvedFixedCouponBondOption)bean).getExpiry();
                }
                case -1285004149: {
                    return ((ResolvedFixedCouponBondOption)bean).getQuantity();
                }
                case 73828649: {
                    return ((ResolvedFixedCouponBondOption)bean).getSettlement();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

