/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.capfloor;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.capfloor.IborCapFloorLeg;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloor;
import com.opengamma.strata.product.swap.SwapLeg;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IborCapFloor
implements Product,
Resolvable<ResolvedIborCapFloor>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final IborCapFloorLeg capFloorLeg;
    @PropertyDefinition(get="optional")
    private final SwapLeg payLeg;
    private static final long serialVersionUID = 1L;

    public static IborCapFloor of(IborCapFloorLeg capFloorLeg) {
        return new IborCapFloor(capFloorLeg, null);
    }

    public static IborCapFloor of(IborCapFloorLeg capFloorLeg, SwapLeg payLeg) {
        return new IborCapFloor(capFloorLeg, payLeg);
    }

    @ImmutableValidator
    private void validate() {
        if (this.payLeg != null) {
            ArgChecker.isFalse((boolean)this.payLeg.getPayReceive().equals((Object)this.capFloorLeg.getPayReceive()), (String)"Legs must have different Pay/Receive flag, but both were {}", (Object[])new Object[]{this.payLeg.getPayReceive()});
        }
    }

    @Override
    public ImmutableSet<Currency> allPaymentCurrencies() {
        if (this.payLeg == null) {
            return ImmutableSet.of((Object)this.capFloorLeg.getCurrency());
        }
        return ImmutableSet.of((Object)this.capFloorLeg.getCurrency(), (Object)this.payLeg.getCurrency());
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        if (this.payLeg == null) {
            return ImmutableSet.of((Object)this.capFloorLeg.getCurrency());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.capFloorLeg.getCurrency());
        builder.addAll(this.payLeg.allCurrencies());
        return builder.build();
    }

    public ImmutableSet<Index> allIndices() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.capFloorLeg.getCalculation().getIndex());
        if (this.payLeg != null) {
            this.payLeg.collectIndices((ImmutableSet.Builder<Index>)builder);
        }
        return builder.build();
    }

    public ResolvedIborCapFloor resolve(ReferenceData refData) {
        if (this.payLeg == null) {
            return ResolvedIborCapFloor.of(this.capFloorLeg.resolve(refData));
        }
        return ResolvedIborCapFloor.of(this.capFloorLeg.resolve(refData), this.payLeg.resolve(refData));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IborCapFloor(IborCapFloorLeg capFloorLeg, SwapLeg payLeg) {
        JodaBeanUtils.notNull((Object)capFloorLeg, (String)"capFloorLeg");
        this.capFloorLeg = capFloorLeg;
        this.payLeg = payLeg;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public IborCapFloorLeg getCapFloorLeg() {
        return this.capFloorLeg;
    }

    public Optional<SwapLeg> getPayLeg() {
        return Optional.ofNullable(this.payLeg);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborCapFloor other = (IborCapFloor)obj;
            return JodaBeanUtils.equal((Object)this.capFloorLeg, (Object)other.capFloorLeg) && JodaBeanUtils.equal((Object)this.payLeg, (Object)other.payLeg);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.capFloorLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.payLeg);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("IborCapFloor{");
        buf.append("capFloorLeg").append('=').append(JodaBeanUtils.toString((Object)this.capFloorLeg)).append(',').append(' ');
        buf.append("payLeg").append('=').append(JodaBeanUtils.toString((Object)this.payLeg));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IborCapFloor> {
        private IborCapFloorLeg capFloorLeg;
        private SwapLeg payLeg;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2124672084: {
                    return this.capFloorLeg;
                }
                case -995239866: {
                    return this.payLeg;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2124672084: {
                    this.capFloorLeg = (IborCapFloorLeg)newValue;
                    break;
                }
                case -995239866: {
                    this.payLeg = (SwapLeg)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IborCapFloor build() {
            return new IborCapFloor(this.capFloorLeg, this.payLeg);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("IborCapFloor.Builder{");
            buf.append("capFloorLeg").append('=').append(JodaBeanUtils.toString((Object)this.capFloorLeg)).append(',').append(' ');
            buf.append("payLeg").append('=').append(JodaBeanUtils.toString((Object)this.payLeg));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborCapFloorLeg> capFloorLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"capFloorLeg", IborCapFloor.class, IborCapFloorLeg.class);
        private final MetaProperty<SwapLeg> payLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payLeg", IborCapFloor.class, SwapLeg.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"capFloorLeg", "payLeg"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2124672084: {
                    return this.capFloorLeg;
                }
                case -995239866: {
                    return this.payLeg;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IborCapFloor> builder() {
            return new Builder();
        }

        public Class<? extends IborCapFloor> beanType() {
            return IborCapFloor.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborCapFloorLeg> capFloorLeg() {
            return this.capFloorLeg;
        }

        public MetaProperty<SwapLeg> payLeg() {
            return this.payLeg;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2124672084: {
                    return ((IborCapFloor)bean).getCapFloorLeg();
                }
                case -995239866: {
                    return ((IborCapFloor)bean).payLeg;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

