/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.capfloor;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorLeg;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.rate.IborRateComputation;
import com.opengamma.strata.product.swap.FixingRelativeTo;
import com.opengamma.strata.product.swap.IborRateCalculation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborCapFloorLeg
implements Resolvable<ResolvedIborCapFloorLeg>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notNull")
    private final PeriodicSchedule paymentSchedule;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment paymentDateOffset;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final ValueSchedule notional;
    @PropertyDefinition(validate="notNull")
    private final IborRateCalculation calculation;
    @PropertyDefinition(get="optional")
    private final ValueSchedule capSchedule;
    @PropertyDefinition(get="optional")
    private final ValueSchedule floorSchedule;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.paymentDateOffset(DaysAdjustment.NONE);
    }

    @ImmutableConstructor
    private IborCapFloorLeg(PayReceive payReceive, PeriodicSchedule paymentSchedule, DaysAdjustment paymentDateOffset, Currency currency, ValueSchedule notional, IborRateCalculation calculation, ValueSchedule capSchedule, ValueSchedule floorSchedule) {
        this.payReceive = (PayReceive)((Object)ArgChecker.notNull((Object)((Object)payReceive), (String)"payReceive"));
        this.paymentSchedule = (PeriodicSchedule)ArgChecker.notNull((Object)paymentSchedule, (String)"paymentSchedule");
        this.paymentDateOffset = (DaysAdjustment)ArgChecker.notNull((Object)paymentDateOffset, (String)"paymentDateOffset");
        this.currency = currency != null ? currency : calculation.getIndex().getCurrency();
        this.notional = notional;
        this.calculation = (IborRateCalculation)ArgChecker.notNull((Object)calculation, (String)"calculation");
        this.capSchedule = capSchedule;
        this.floorSchedule = floorSchedule;
        ArgChecker.isTrue((!this.getPaymentSchedule().getStubConvention().isPresent() || ((StubConvention)this.getPaymentSchedule().getStubConvention().get()).equals((Object)StubConvention.NONE) ? 1 : 0) != 0, (String)"Stub period is not allowed");
        ArgChecker.isFalse((this.getCapSchedule().isPresent() == this.getFloorSchedule().isPresent() ? 1 : 0) != 0, (String)"One of cap schedule and floor schedule should be empty");
        ArgChecker.isTrue((boolean)this.getCalculation().getIndex().getTenor().getPeriod().equals(this.getPaymentSchedule().getFrequency().getPeriod()), (String)"Payment frequency period should be the same as index tenor period");
    }

    public AdjustableDate getStartDate() {
        return this.paymentSchedule.calculatedStartDate();
    }

    public AdjustableDate getEndDate() {
        return this.paymentSchedule.calculatedEndDate();
    }

    public IborIndex getIndex() {
        return this.calculation.getIndex();
    }

    public ResolvedIborCapFloorLeg resolve(ReferenceData refData) {
        Schedule adjustedSchedule = this.paymentSchedule.createSchedule(refData);
        DoubleArray cap = this.getCapSchedule().isPresent() ? this.capSchedule.resolveValues(adjustedSchedule) : null;
        DoubleArray floor = this.getFloorSchedule().isPresent() ? this.floorSchedule.resolveValues(adjustedSchedule) : null;
        DoubleArray notionals = this.notional.resolveValues(adjustedSchedule);
        DateAdjuster fixingDateAdjuster = this.calculation.getFixingDateOffset().resolve(refData);
        DateAdjuster paymentDateAdjuster = this.paymentDateOffset.resolve(refData);
        Function obsFn = this.calculation.getIndex().resolve(refData);
        ImmutableList.Builder periodsBuild = ImmutableList.builder();
        for (int i = 0; i < adjustedSchedule.size(); ++i) {
            SchedulePeriod period = adjustedSchedule.getPeriod(i);
            LocalDate paymentDate = paymentDateAdjuster.adjust(period.getEndDate());
            LocalDate fixingDate = fixingDateAdjuster.adjust(this.calculation.getFixingRelativeTo().equals((Object)FixingRelativeTo.PERIOD_START) ? period.getStartDate() : period.getEndDate());
            double signedNotional = this.payReceive.normalize(notionals.get(i));
            periodsBuild.add((Object)IborCapletFloorletPeriod.builder().unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate()).startDate(period.getStartDate()).endDate(period.getEndDate()).iborRate(IborRateComputation.of((IborIndexObservation)obsFn.apply(fixingDate))).paymentDate(paymentDate).notional(signedNotional).currency(this.currency).yearFraction(period.yearFraction(this.calculation.getDayCount(), adjustedSchedule)).caplet(cap != null ? Double.valueOf(cap.get(i)) : null).floorlet(floor != null ? Double.valueOf(floor.get(i)) : null).build());
        }
        return ResolvedIborCapFloorLeg.builder().capletFloorletPeriods((List<IborCapletFloorletPeriod>)periodsBuild.build()).payReceive(this.payReceive).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    public PeriodicSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public DaysAdjustment getPaymentDateOffset() {
        return this.paymentDateOffset;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public ValueSchedule getNotional() {
        return this.notional;
    }

    public IborRateCalculation getCalculation() {
        return this.calculation;
    }

    public Optional<ValueSchedule> getCapSchedule() {
        return Optional.ofNullable(this.capSchedule);
    }

    public Optional<ValueSchedule> getFloorSchedule() {
        return Optional.ofNullable(this.floorSchedule);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborCapFloorLeg other = (IborCapFloorLeg)obj;
            return JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal((Object)this.paymentSchedule, (Object)other.paymentSchedule) && JodaBeanUtils.equal((Object)this.paymentDateOffset, (Object)other.paymentDateOffset) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.notional, (Object)other.notional) && JodaBeanUtils.equal((Object)this.calculation, (Object)other.calculation) && JodaBeanUtils.equal((Object)this.capSchedule, (Object)other.capSchedule) && JodaBeanUtils.equal((Object)this.floorSchedule, (Object)other.floorSchedule);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.calculation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.capSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.floorSchedule);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("IborCapFloorLeg{");
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
        buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("calculation").append('=').append(JodaBeanUtils.toString((Object)this.calculation)).append(',').append(' ');
        buf.append("capSchedule").append('=').append(JodaBeanUtils.toString((Object)this.capSchedule)).append(',').append(' ');
        buf.append("floorSchedule").append('=').append(JodaBeanUtils.toString((Object)this.floorSchedule));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborCapFloorLeg> {
        private PayReceive payReceive;
        private PeriodicSchedule paymentSchedule;
        private DaysAdjustment paymentDateOffset;
        private Currency currency;
        private ValueSchedule notional;
        private IborRateCalculation calculation;
        private ValueSchedule capSchedule;
        private ValueSchedule floorSchedule;

        private Builder() {
            IborCapFloorLeg.applyDefaults(this);
        }

        private Builder(IborCapFloorLeg beanToCopy) {
            this.payReceive = beanToCopy.getPayReceive();
            this.paymentSchedule = beanToCopy.getPaymentSchedule();
            this.paymentDateOffset = beanToCopy.getPaymentDateOffset();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.calculation = beanToCopy.getCalculation();
            this.capSchedule = beanToCopy.capSchedule;
            this.floorSchedule = beanToCopy.floorSchedule;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -934682935: {
                    return this.calculation;
                }
                case -596212599: {
                    return this.capSchedule;
                }
                case -1562227005: {
                    return this.floorSchedule;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case -1499086147: {
                    this.paymentSchedule = (PeriodicSchedule)newValue;
                    break;
                }
                case -716438393: {
                    this.paymentDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (ValueSchedule)newValue;
                    break;
                }
                case -934682935: {
                    this.calculation = (IborRateCalculation)newValue;
                    break;
                }
                case -596212599: {
                    this.capSchedule = (ValueSchedule)newValue;
                    break;
                }
                case -1562227005: {
                    this.floorSchedule = (ValueSchedule)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborCapFloorLeg build() {
            return new IborCapFloorLeg(this.payReceive, this.paymentSchedule, this.paymentDateOffset, this.currency, this.notional, this.calculation, this.capSchedule, this.floorSchedule);
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder paymentSchedule(PeriodicSchedule paymentSchedule) {
            JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
            this.paymentSchedule = paymentSchedule;
            return this;
        }

        public Builder paymentDateOffset(DaysAdjustment paymentDateOffset) {
            JodaBeanUtils.notNull((Object)paymentDateOffset, (String)"paymentDateOffset");
            this.paymentDateOffset = paymentDateOffset;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(ValueSchedule notional) {
            JodaBeanUtils.notNull((Object)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder calculation(IborRateCalculation calculation) {
            JodaBeanUtils.notNull((Object)calculation, (String)"calculation");
            this.calculation = calculation;
            return this;
        }

        public Builder capSchedule(ValueSchedule capSchedule) {
            this.capSchedule = capSchedule;
            return this;
        }

        public Builder floorSchedule(ValueSchedule floorSchedule) {
            this.floorSchedule = floorSchedule;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("IborCapFloorLeg.Builder{");
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
            buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("calculation").append('=').append(JodaBeanUtils.toString((Object)this.calculation)).append(',').append(' ');
            buf.append("capSchedule").append('=').append(JodaBeanUtils.toString((Object)this.capSchedule)).append(',').append(' ');
            buf.append("floorSchedule").append('=').append(JodaBeanUtils.toString((Object)this.floorSchedule));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", IborCapFloorLeg.class, PayReceive.class);
        private final MetaProperty<PeriodicSchedule> paymentSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentSchedule", IborCapFloorLeg.class, PeriodicSchedule.class);
        private final MetaProperty<DaysAdjustment> paymentDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDateOffset", IborCapFloorLeg.class, DaysAdjustment.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IborCapFloorLeg.class, Currency.class);
        private final MetaProperty<ValueSchedule> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", IborCapFloorLeg.class, ValueSchedule.class);
        private final MetaProperty<IborRateCalculation> calculation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"calculation", IborCapFloorLeg.class, IborRateCalculation.class);
        private final MetaProperty<ValueSchedule> capSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"capSchedule", IborCapFloorLeg.class, ValueSchedule.class);
        private final MetaProperty<ValueSchedule> floorSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"floorSchedule", IborCapFloorLeg.class, ValueSchedule.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payReceive", "paymentSchedule", "paymentDateOffset", "currency", "notional", "calculation", "capSchedule", "floorSchedule"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -934682935: {
                    return this.calculation;
                }
                case -596212599: {
                    return this.capSchedule;
                }
                case -1562227005: {
                    return this.floorSchedule;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborCapFloorLeg> beanType() {
            return IborCapFloorLeg.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<PeriodicSchedule> paymentSchedule() {
            return this.paymentSchedule;
        }

        public MetaProperty<DaysAdjustment> paymentDateOffset() {
            return this.paymentDateOffset;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<ValueSchedule> notional() {
            return this.notional;
        }

        public MetaProperty<IborRateCalculation> calculation() {
            return this.calculation;
        }

        public MetaProperty<ValueSchedule> capSchedule() {
            return this.capSchedule;
        }

        public MetaProperty<ValueSchedule> floorSchedule() {
            return this.floorSchedule;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return ((IborCapFloorLeg)bean).getPayReceive();
                }
                case -1499086147: {
                    return ((IborCapFloorLeg)bean).getPaymentSchedule();
                }
                case -716438393: {
                    return ((IborCapFloorLeg)bean).getPaymentDateOffset();
                }
                case 575402001: {
                    return ((IborCapFloorLeg)bean).getCurrency();
                }
                case 1585636160: {
                    return ((IborCapFloorLeg)bean).getNotional();
                }
                case -934682935: {
                    return ((IborCapFloorLeg)bean).getCalculation();
                }
                case -596212599: {
                    return ((IborCapFloorLeg)bean).capSchedule;
                }
                case -1562227005: {
                    return ((IborCapFloorLeg)bean).floorSchedule;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

