/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.capfloor;

import com.google.common.base.MoreObjects;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.rate.OvernightCompoundedRateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class OvernightInArrearsCapletFloorletPeriod
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedEndDate;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double yearFraction;
    @PropertyDefinition(validate="notNull")
    private final LocalDate paymentDate;
    @PropertyDefinition(get="optional")
    private final Double caplet;
    @PropertyDefinition(get="optional")
    private final Double floorlet;
    @PropertyDefinition(validate="notNull")
    private final OvernightCompoundedRateComputation overnightRate;
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.overnightRate != null) {
            OvernightIndex index = builder.overnightRate.getIndex();
            if (builder.currency == null) {
                builder.currency = index.getCurrency();
            }
        }
        if (builder.paymentDate == null) {
            builder.paymentDate = builder.endDate;
        }
        if (builder.unadjustedStartDate == null) {
            builder.unadjustedStartDate = builder.startDate;
        }
        if (builder.unadjustedEndDate == null) {
            builder.unadjustedEndDate = builder.endDate;
        }
        ArgChecker.isFalse((builder.caplet != null && builder.floorlet != null ? 1 : 0) != 0, (String)"Only caplet or floorlet must be set, not both");
        ArgChecker.isFalse((builder.caplet == null && builder.floorlet == null ? 1 : 0) != 0, (String)"Either caplet or floorlet must be set");
    }

    public OvernightIndex getIndex() {
        return this.overnightRate.getIndex();
    }

    public double getStrike() {
        return (Double)MoreObjects.firstNonNull((Object)this.caplet, (Object)this.floorlet);
    }

    public PutCall getPutCall() {
        return this.getCaplet().isPresent() ? PutCall.CALL : PutCall.PUT;
    }

    public CurrencyAmount payoff(double rate) {
        double unitpayoff = this.getCaplet().isPresent() ? Math.max(rate - this.caplet, 0.0) : Math.max(this.floorlet - rate, 0.0);
        return CurrencyAmount.of((Currency)this.currency, (double)(unitpayoff * this.yearFraction * this.notional));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OvernightInArrearsCapletFloorletPeriod(Currency currency, double notional, LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate, double yearFraction, LocalDate paymentDate, Double caplet, Double floorlet, OvernightCompoundedRateComputation overnightRate) {
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
        JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
        ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
        JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
        JodaBeanUtils.notNull((Object)overnightRate, (String)"overnightRate");
        this.currency = currency;
        this.notional = notional;
        this.startDate = startDate;
        this.endDate = endDate;
        this.unadjustedStartDate = unadjustedStartDate;
        this.unadjustedEndDate = unadjustedEndDate;
        this.yearFraction = yearFraction;
        this.paymentDate = paymentDate;
        this.caplet = caplet;
        this.floorlet = floorlet;
        this.overnightRate = overnightRate;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalDate getUnadjustedStartDate() {
        return this.unadjustedStartDate;
    }

    public LocalDate getUnadjustedEndDate() {
        return this.unadjustedEndDate;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public OptionalDouble getCaplet() {
        return this.caplet != null ? OptionalDouble.of(this.caplet) : OptionalDouble.empty();
    }

    public OptionalDouble getFloorlet() {
        return this.floorlet != null ? OptionalDouble.of(this.floorlet) : OptionalDouble.empty();
    }

    public OvernightCompoundedRateComputation getOvernightRate() {
        return this.overnightRate;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightInArrearsCapletFloorletPeriod other = (OvernightInArrearsCapletFloorletPeriod)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.unadjustedStartDate, (Object)other.unadjustedStartDate) && JodaBeanUtils.equal((Object)this.unadjustedEndDate, (Object)other.unadjustedEndDate) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate) && JodaBeanUtils.equal((Object)this.caplet, (Object)other.caplet) && JodaBeanUtils.equal((Object)this.floorlet, (Object)other.floorlet) && JodaBeanUtils.equal((Object)this.overnightRate, (Object)other.overnightRate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.caplet);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.floorlet);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.overnightRate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(384);
        buf.append("OvernightInArrearsCapletFloorletPeriod{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
        buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
        buf.append("caplet").append('=').append(JodaBeanUtils.toString((Object)this.caplet)).append(',').append(' ');
        buf.append("floorlet").append('=').append(JodaBeanUtils.toString((Object)this.floorlet)).append(',').append(' ');
        buf.append("overnightRate").append('=').append(JodaBeanUtils.toString((Object)this.overnightRate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<OvernightInArrearsCapletFloorletPeriod> {
        private Currency currency;
        private double notional;
        private LocalDate startDate;
        private LocalDate endDate;
        private LocalDate unadjustedStartDate;
        private LocalDate unadjustedEndDate;
        private double yearFraction;
        private LocalDate paymentDate;
        private Double caplet;
        private Double floorlet;
        private OvernightCompoundedRateComputation overnightRate;

        private Builder() {
        }

        private Builder(OvernightInArrearsCapletFloorletPeriod beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.unadjustedStartDate = beanToCopy.getUnadjustedStartDate();
            this.unadjustedEndDate = beanToCopy.getUnadjustedEndDate();
            this.yearFraction = beanToCopy.getYearFraction();
            this.paymentDate = beanToCopy.getPaymentDate();
            this.caplet = beanToCopy.caplet;
            this.floorlet = beanToCopy.floorlet;
            this.overnightRate = beanToCopy.getOvernightRate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case -1367656183: {
                    return this.caplet;
                }
                case 2022994575: {
                    return this.floorlet;
                }
                case -821605692: {
                    return this.overnightRate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 1457691881: {
                    this.unadjustedStartDate = (LocalDate)newValue;
                    break;
                }
                case 31758114: {
                    this.unadjustedEndDate = (LocalDate)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case -1540873516: {
                    this.paymentDate = (LocalDate)newValue;
                    break;
                }
                case -1367656183: {
                    this.caplet = (Double)newValue;
                    break;
                }
                case 2022994575: {
                    this.floorlet = (Double)newValue;
                    break;
                }
                case -821605692: {
                    this.overnightRate = (OvernightCompoundedRateComputation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public OvernightInArrearsCapletFloorletPeriod build() {
            OvernightInArrearsCapletFloorletPeriod.preBuild(this);
            return new OvernightInArrearsCapletFloorletPeriod(this.currency, this.notional, this.startDate, this.endDate, this.unadjustedStartDate, this.unadjustedEndDate, this.yearFraction, this.paymentDate, this.caplet, this.floorlet, this.overnightRate);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            this.notional = notional;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder unadjustedStartDate(LocalDate unadjustedStartDate) {
            JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
            this.unadjustedStartDate = unadjustedStartDate;
            return this;
        }

        public Builder unadjustedEndDate(LocalDate unadjustedEndDate) {
            JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
            this.unadjustedEndDate = unadjustedEndDate;
            return this;
        }

        public Builder yearFraction(double yearFraction) {
            ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
            this.yearFraction = yearFraction;
            return this;
        }

        public Builder paymentDate(LocalDate paymentDate) {
            JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
            this.paymentDate = paymentDate;
            return this;
        }

        public Builder caplet(Double caplet) {
            this.caplet = caplet;
            return this;
        }

        public Builder floorlet(Double floorlet) {
            this.floorlet = floorlet;
            return this;
        }

        public Builder overnightRate(OvernightCompoundedRateComputation overnightRate) {
            JodaBeanUtils.notNull((Object)overnightRate, (String)"overnightRate");
            this.overnightRate = overnightRate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(384);
            buf.append("OvernightInArrearsCapletFloorletPeriod.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
            buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
            buf.append("caplet").append('=').append(JodaBeanUtils.toString((Object)this.caplet)).append(',').append(' ');
            buf.append("floorlet").append('=').append(JodaBeanUtils.toString((Object)this.floorlet)).append(',').append(' ');
            buf.append("overnightRate").append('=').append(JodaBeanUtils.toString((Object)this.overnightRate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", OvernightInArrearsCapletFloorletPeriod.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", OvernightInArrearsCapletFloorletPeriod.class, Double.TYPE);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", OvernightInArrearsCapletFloorletPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", OvernightInArrearsCapletFloorletPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedStartDate", OvernightInArrearsCapletFloorletPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedEndDate", OvernightInArrearsCapletFloorletPeriod.class, LocalDate.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", OvernightInArrearsCapletFloorletPeriod.class, Double.TYPE);
        private final MetaProperty<LocalDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", OvernightInArrearsCapletFloorletPeriod.class, LocalDate.class);
        private final MetaProperty<Double> caplet = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"caplet", OvernightInArrearsCapletFloorletPeriod.class, Double.class);
        private final MetaProperty<Double> floorlet = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"floorlet", OvernightInArrearsCapletFloorletPeriod.class, Double.class);
        private final MetaProperty<OvernightCompoundedRateComputation> overnightRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"overnightRate", OvernightInArrearsCapletFloorletPeriod.class, OvernightCompoundedRateComputation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "notional", "startDate", "endDate", "unadjustedStartDate", "unadjustedEndDate", "yearFraction", "paymentDate", "caplet", "floorlet", "overnightRate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case -1367656183: {
                    return this.caplet;
                }
                case 2022994575: {
                    return this.floorlet;
                }
                case -821605692: {
                    return this.overnightRate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends OvernightInArrearsCapletFloorletPeriod> beanType() {
            return OvernightInArrearsCapletFloorletPeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<LocalDate> unadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        public MetaProperty<LocalDate> unadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<LocalDate> paymentDate() {
            return this.paymentDate;
        }

        public MetaProperty<Double> caplet() {
            return this.caplet;
        }

        public MetaProperty<Double> floorlet() {
            return this.floorlet;
        }

        public MetaProperty<OvernightCompoundedRateComputation> overnightRate() {
            return this.overnightRate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getCurrency();
                }
                case 1585636160: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getNotional();
                }
                case -2129778896: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getStartDate();
                }
                case -1607727319: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getEndDate();
                }
                case 1457691881: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getUnadjustedStartDate();
                }
                case 31758114: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getUnadjustedEndDate();
                }
                case -1731780257: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getYearFraction();
                }
                case -1540873516: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getPaymentDate();
                }
                case -1367656183: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).caplet;
                }
                case 2022994575: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).floorlet;
                }
                case -821605692: {
                    return ((OvernightInArrearsCapletFloorletPeriod)bean).getOvernightRate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

