/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.capfloor;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorLeg;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ResolvedIborCapFloor
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ResolvedIborCapFloorLeg capFloorLeg;
    @PropertyDefinition(get="optional")
    private final ResolvedSwapLeg payLeg;
    private final transient ImmutableSet<Currency> currencies;
    private final transient ImmutableSet<Index> indices;
    private static final long serialVersionUID = 1L;

    public static ResolvedIborCapFloor of(ResolvedIborCapFloorLeg capFloorLeg) {
        ArgChecker.notNull((Object)capFloorLeg, (String)"capFloorLeg");
        return new ResolvedIborCapFloor(capFloorLeg, null);
    }

    public static ResolvedIborCapFloor of(ResolvedIborCapFloorLeg capFloorLeg, ResolvedSwapLeg payLeg) {
        ArgChecker.notNull((Object)capFloorLeg, (String)"capFloorLeg");
        ArgChecker.notNull((Object)payLeg, (String)"payLeg");
        return new ResolvedIborCapFloor(capFloorLeg, payLeg);
    }

    @ImmutableConstructor
    private ResolvedIborCapFloor(ResolvedIborCapFloorLeg capFloorLeg, ResolvedSwapLeg payLeg) {
        JodaBeanUtils.notNull((Object)capFloorLeg, (String)"capFloorLeg");
        if (payLeg != null) {
            ArgChecker.isFalse((boolean)payLeg.getPayReceive().equals((Object)capFloorLeg.getPayReceive()), (String)"Legs must have different Pay/Receive flag, but both were {}", (Object[])new Object[]{payLeg.getPayReceive()});
        }
        this.capFloorLeg = capFloorLeg;
        this.payLeg = payLeg;
        this.currencies = ResolvedIborCapFloor.buildCurrencies(capFloorLeg, payLeg);
        this.indices = ResolvedIborCapFloor.buildIndices(capFloorLeg, payLeg);
    }

    private static ImmutableSet<Currency> buildCurrencies(ResolvedIborCapFloorLeg capFloorLeg, ResolvedSwapLeg payLeg) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)capFloorLeg.getCurrency());
        if (payLeg != null) {
            builder.add((Object)payLeg.getCurrency());
        }
        return builder.build();
    }

    private static ImmutableSet<Index> buildIndices(ResolvedIborCapFloorLeg capFloorLeg, ResolvedSwapLeg payLeg) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)capFloorLeg.getIndex());
        if (payLeg != null) {
            payLeg.collectIndices((ImmutableSet.Builder<Index>)builder);
        }
        return builder.build();
    }

    private Object readResolve() {
        return new ResolvedIborCapFloor(this.capFloorLeg, this.payLeg);
    }

    public ImmutableSet<Currency> allPaymentCurrencies() {
        return this.currencies;
    }

    public ImmutableSet<Index> allIndices() {
        return this.indices;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ResolvedIborCapFloorLeg getCapFloorLeg() {
        return this.capFloorLeg;
    }

    public Optional<ResolvedSwapLeg> getPayLeg() {
        return Optional.ofNullable(this.payLeg);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedIborCapFloor other = (ResolvedIborCapFloor)obj;
            return JodaBeanUtils.equal((Object)this.capFloorLeg, (Object)other.capFloorLeg) && JodaBeanUtils.equal((Object)this.payLeg, (Object)other.payLeg);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.capFloorLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.payLeg);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ResolvedIborCapFloor{");
        buf.append("capFloorLeg").append('=').append(JodaBeanUtils.toString((Object)this.capFloorLeg)).append(',').append(' ');
        buf.append("payLeg").append('=').append(JodaBeanUtils.toString((Object)this.payLeg));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ResolvedIborCapFloor> {
        private ResolvedIborCapFloorLeg capFloorLeg;
        private ResolvedSwapLeg payLeg;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2124672084: {
                    return this.capFloorLeg;
                }
                case -995239866: {
                    return this.payLeg;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2124672084: {
                    this.capFloorLeg = (ResolvedIborCapFloorLeg)newValue;
                    break;
                }
                case -995239866: {
                    this.payLeg = (ResolvedSwapLeg)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ResolvedIborCapFloor build() {
            return new ResolvedIborCapFloor(this.capFloorLeg, this.payLeg);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ResolvedIborCapFloor.Builder{");
            buf.append("capFloorLeg").append('=').append(JodaBeanUtils.toString((Object)this.capFloorLeg)).append(',').append(' ');
            buf.append("payLeg").append('=').append(JodaBeanUtils.toString((Object)this.payLeg));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ResolvedIborCapFloorLeg> capFloorLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"capFloorLeg", ResolvedIborCapFloor.class, ResolvedIborCapFloorLeg.class);
        private final MetaProperty<ResolvedSwapLeg> payLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payLeg", ResolvedIborCapFloor.class, ResolvedSwapLeg.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"capFloorLeg", "payLeg"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2124672084: {
                    return this.capFloorLeg;
                }
                case -995239866: {
                    return this.payLeg;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ResolvedIborCapFloor> builder() {
            return new Builder();
        }

        public Class<? extends ResolvedIborCapFloor> beanType() {
            return ResolvedIborCapFloor.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ResolvedIborCapFloorLeg> capFloorLeg() {
            return this.capFloorLeg;
        }

        public MetaProperty<ResolvedSwapLeg> payLeg() {
            return this.payLeg;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2124672084: {
                    return ((ResolvedIborCapFloor)bean).getCapFloorLeg();
                }
                case -995239866: {
                    return ((ResolvedIborCapFloor)bean).payLeg;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

