/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.capfloor;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import com.opengamma.strata.product.common.PayReceive;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedIborCapFloorLeg
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<IborCapletFloorletPeriod> capletFloorletPeriods;
    private static final long serialVersionUID = 1L;

    @ImmutableConstructor
    private ResolvedIborCapFloorLeg(PayReceive payReceive, List<IborCapletFloorletPeriod> capletFloorletPeriods) {
        this.payReceive = (PayReceive)((Object)ArgChecker.notNull((Object)((Object)payReceive), (String)"payReceive"));
        this.capletFloorletPeriods = ImmutableList.copyOf(capletFloorletPeriods);
        Set currencies = this.capletFloorletPeriods.stream().map(IborCapletFloorletPeriod::getCurrency).collect(Collectors.toSet());
        ArgChecker.isTrue((currencies.size() == 1 ? 1 : 0) != 0, (String)("Leg must have a single currency, found: " + currencies));
        Set iborIndices = this.capletFloorletPeriods.stream().map(IborCapletFloorletPeriod::getIndex).collect(Collectors.toSet());
        ArgChecker.isTrue((iborIndices.size() == 1 ? 1 : 0) != 0, (String)("Leg must have a single Ibor index: " + iborIndices));
    }

    public LocalDate getStartDate() {
        return ((IborCapletFloorletPeriod)this.capletFloorletPeriods.get(0)).getStartDate();
    }

    public LocalDate getEndDate() {
        return ((IborCapletFloorletPeriod)this.capletFloorletPeriods.get(this.capletFloorletPeriods.size() - 1)).getEndDate();
    }

    public ZonedDateTime getFinalFixingDateTime() {
        return ((IborCapletFloorletPeriod)this.capletFloorletPeriods.get(this.capletFloorletPeriods.size() - 1)).getFixingDateTime();
    }

    public IborCapletFloorletPeriod getFinalPeriod() {
        return (IborCapletFloorletPeriod)this.capletFloorletPeriods.get(this.capletFloorletPeriods.size() - 1);
    }

    public Currency getCurrency() {
        return ((IborCapletFloorletPeriod)this.capletFloorletPeriods.get(0)).getCurrency();
    }

    public IborIndex getIndex() {
        return ((IborCapletFloorletPeriod)this.capletFloorletPeriods.get(0)).getIndex();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    public ImmutableList<IborCapletFloorletPeriod> getCapletFloorletPeriods() {
        return this.capletFloorletPeriods;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedIborCapFloorLeg other = (ResolvedIborCapFloorLeg)obj;
            return JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal(this.capletFloorletPeriods, other.capletFloorletPeriods);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.capletFloorletPeriods);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ResolvedIborCapFloorLeg{");
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("capletFloorletPeriods").append('=').append(JodaBeanUtils.toString(this.capletFloorletPeriods));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedIborCapFloorLeg> {
        private PayReceive payReceive;
        private List<IborCapletFloorletPeriod> capletFloorletPeriods = ImmutableList.of();

        private Builder() {
        }

        private Builder(ResolvedIborCapFloorLeg beanToCopy) {
            this.payReceive = beanToCopy.getPayReceive();
            this.capletFloorletPeriods = beanToCopy.getCapletFloorletPeriods();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 1504863482: {
                    return this.capletFloorletPeriods;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case 1504863482: {
                    this.capletFloorletPeriods = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedIborCapFloorLeg build() {
            return new ResolvedIborCapFloorLeg(this.payReceive, this.capletFloorletPeriods);
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder capletFloorletPeriods(List<IborCapletFloorletPeriod> capletFloorletPeriods) {
            JodaBeanUtils.notEmpty(capletFloorletPeriods, (String)"capletFloorletPeriods");
            this.capletFloorletPeriods = capletFloorletPeriods;
            return this;
        }

        public Builder capletFloorletPeriods(IborCapletFloorletPeriod ... capletFloorletPeriods) {
            return this.capletFloorletPeriods((List<IborCapletFloorletPeriod>)ImmutableList.copyOf((Object[])capletFloorletPeriods));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ResolvedIborCapFloorLeg.Builder{");
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("capletFloorletPeriods").append('=').append(JodaBeanUtils.toString(this.capletFloorletPeriods));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", ResolvedIborCapFloorLeg.class, PayReceive.class);
        private final MetaProperty<ImmutableList<IborCapletFloorletPeriod>> capletFloorletPeriods = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"capletFloorletPeriods", ResolvedIborCapFloorLeg.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payReceive", "capletFloorletPeriods"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 1504863482: {
                    return this.capletFloorletPeriods;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedIborCapFloorLeg> beanType() {
            return ResolvedIborCapFloorLeg.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<ImmutableList<IborCapletFloorletPeriod>> capletFloorletPeriods() {
            return this.capletFloorletPeriods;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return ((ResolvedIborCapFloorLeg)bean).getPayReceive();
                }
                case 1504863482: {
                    return ((ResolvedIborCapFloorLeg)bean).getCapletFloorletPeriods();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

