/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.cms;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.cms.CmsLeg;
import com.opengamma.strata.product.cms.ResolvedCms;
import com.opengamma.strata.product.swap.SwapLeg;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class Cms
implements Product,
Resolvable<ResolvedCms>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CmsLeg cmsLeg;
    @PropertyDefinition(get="optional")
    private final SwapLeg payLeg;
    private static final long serialVersionUID = 1L;

    public static Cms of(CmsLeg cmsLeg) {
        return new Cms(cmsLeg, null);
    }

    public static Cms of(CmsLeg cmsLeg, SwapLeg payLeg) {
        return new Cms(cmsLeg, payLeg);
    }

    @ImmutableValidator
    private void validate() {
        if (this.getPayLeg().isPresent()) {
            ArgChecker.isFalse((boolean)this.payLeg.getPayReceive().equals((Object)this.cmsLeg.getPayReceive()), (String)"Two legs should have different Pay/Receive flags");
        }
    }

    public ResolvedCms resolve(ReferenceData refData) {
        if (this.payLeg == null) {
            return ResolvedCms.of(this.cmsLeg.resolve(refData));
        }
        return ResolvedCms.of(this.cmsLeg.resolve(refData), this.payLeg.resolve(refData));
    }

    @Override
    public ImmutableSet<Currency> allPaymentCurrencies() {
        if (this.payLeg == null) {
            return ImmutableSet.of((Object)this.cmsLeg.getCurrency());
        }
        return ImmutableSet.of((Object)this.cmsLeg.getCurrency(), (Object)this.payLeg.getCurrency());
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        if (this.payLeg == null) {
            return ImmutableSet.of((Object)this.cmsLeg.getCurrency());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.cmsLeg.getCurrency());
        builder.addAll(this.payLeg.allCurrencies());
        return builder.build();
    }

    public ImmutableSet<Index> allRateIndices() {
        RateIndex cmsIndex = this.cmsLeg.getUnderlyingIndex();
        if (this.payLeg == null) {
            return ImmutableSet.of((Object)cmsIndex);
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.payLeg.collectIndices((ImmutableSet.Builder<Index>)builder);
        builder.add((Object)cmsIndex);
        return builder.build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private Cms(CmsLeg cmsLeg, SwapLeg payLeg) {
        JodaBeanUtils.notNull((Object)cmsLeg, (String)"cmsLeg");
        this.cmsLeg = cmsLeg;
        this.payLeg = payLeg;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CmsLeg getCmsLeg() {
        return this.cmsLeg;
    }

    public Optional<SwapLeg> getPayLeg() {
        return Optional.ofNullable(this.payLeg);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Cms other = (Cms)obj;
            return JodaBeanUtils.equal((Object)this.cmsLeg, (Object)other.cmsLeg) && JodaBeanUtils.equal((Object)this.payLeg, (Object)other.payLeg);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.cmsLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.payLeg);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("Cms{");
        buf.append("cmsLeg").append('=').append(JodaBeanUtils.toString((Object)this.cmsLeg)).append(',').append(' ');
        buf.append("payLeg").append('=').append(JodaBeanUtils.toString((Object)this.payLeg));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<Cms> {
        private CmsLeg cmsLeg;
        private SwapLeg payLeg;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1356515323: {
                    return this.cmsLeg;
                }
                case -995239866: {
                    return this.payLeg;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1356515323: {
                    this.cmsLeg = (CmsLeg)newValue;
                    break;
                }
                case -995239866: {
                    this.payLeg = (SwapLeg)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Cms build() {
            return new Cms(this.cmsLeg, this.payLeg);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("Cms.Builder{");
            buf.append("cmsLeg").append('=').append(JodaBeanUtils.toString((Object)this.cmsLeg)).append(',').append(' ');
            buf.append("payLeg").append('=').append(JodaBeanUtils.toString((Object)this.payLeg));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CmsLeg> cmsLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cmsLeg", Cms.class, CmsLeg.class);
        private final MetaProperty<SwapLeg> payLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payLeg", Cms.class, SwapLeg.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"cmsLeg", "payLeg"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1356515323: {
                    return this.cmsLeg;
                }
                case -995239866: {
                    return this.payLeg;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends Cms> builder() {
            return new Builder();
        }

        public Class<? extends Cms> beanType() {
            return Cms.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CmsLeg> cmsLeg() {
            return this.cmsLeg;
        }

        public MetaProperty<SwapLeg> payLeg() {
            return this.payLeg;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1356515323: {
                    return ((Cms)bean).getCmsLeg();
                }
                case -995239866: {
                    return ((Cms)bean).payLeg;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

