/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.cms;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.product.cms.CmsPeriod;
import com.opengamma.strata.product.cms.ResolvedCmsLeg;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.FixingRelativeTo;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapIndex;
import com.opengamma.strata.product.swap.type.FixedFloatSwapConvention;
import com.opengamma.strata.product.swap.type.FloatRateSwapLegConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CmsLeg
implements Resolvable<ResolvedCmsLeg>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notNull")
    private final PeriodicSchedule paymentSchedule;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment paymentDateOffset;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final ValueSchedule notional;
    @PropertyDefinition(validate="notNull")
    private final SwapIndex index;
    @PropertyDefinition(validate="notNull")
    private final FixingRelativeTo fixingRelativeTo;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment fixingDateOffset;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(get="optional")
    private final ValueSchedule capSchedule;
    @PropertyDefinition(get="optional")
    private final ValueSchedule floorSchedule;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.fixingRelativeTo = FixingRelativeTo.PERIOD_START;
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null) {
            FixedFloatSwapConvention swapConvention = builder.index.getTemplate().getConvention();
            FloatRateSwapLegConvention floatLeg = builder.index.getTemplate().getConvention().getFloatingLeg();
            if (builder.fixingDateOffset == null) {
                DaysAdjustment offset = swapConvention.getSpotDateOffset();
                builder.fixingDateOffset = offset.toBuilder().days(-offset.getDays()).build();
            }
            if (builder.dayCount == null) {
                builder.dayCount = floatLeg.getDayCount();
            }
            if (builder.paymentDateOffset == null) {
                builder.paymentDateOffset = floatLeg.getPaymentDateOffset();
            }
            if (builder.currency == null) {
                builder.currency = floatLeg.getCurrency();
            }
        }
    }

    @ImmutableConstructor
    private CmsLeg(PayReceive payReceive, PeriodicSchedule paymentSchedule, DaysAdjustment paymentDateOffset, Currency currency, ValueSchedule notional, SwapIndex index, FixingRelativeTo fixingRelativeTo, DaysAdjustment fixingDateOffset, DayCount dayCount, ValueSchedule capSchedule, ValueSchedule floorSchedule) {
        this.payReceive = (PayReceive)((Object)ArgChecker.notNull((Object)((Object)payReceive), (String)"payReceive"));
        this.paymentSchedule = (PeriodicSchedule)ArgChecker.notNull((Object)paymentSchedule, (String)"paymentSchedule");
        this.paymentDateOffset = paymentDateOffset;
        this.currency = currency;
        this.notional = (ValueSchedule)ArgChecker.notNull((Object)notional, (String)"notional");
        this.index = (SwapIndex)ArgChecker.notNull((Object)index, (String)"index");
        this.fixingRelativeTo = fixingRelativeTo;
        this.fixingDateOffset = fixingDateOffset;
        this.dayCount = dayCount;
        this.capSchedule = capSchedule;
        this.floorSchedule = floorSchedule;
        ArgChecker.isTrue((!this.getPaymentSchedule().getStubConvention().isPresent() || ((StubConvention)this.getPaymentSchedule().getStubConvention().get()).equals((Object)StubConvention.NONE) ? 1 : 0) != 0, (String)"Stub period is not allowed");
        ArgChecker.isFalse((this.getCapSchedule().isPresent() && this.getFloorSchedule().isPresent() ? 1 : 0) != 0, (String)"At least one of cap schedule and floor schedule should be empty");
    }

    public AdjustableDate getStartDate() {
        return this.paymentSchedule.calculatedStartDate();
    }

    public AdjustableDate getEndDate() {
        return this.paymentSchedule.calculatedEndDate();
    }

    public RateIndex getUnderlyingIndex() {
        return this.index.getTemplate().getConvention().getFloatingLeg().getIndex();
    }

    public ResolvedCmsLeg resolve(ReferenceData refData) {
        Schedule adjustedSchedule = this.paymentSchedule.createSchedule(refData);
        DoubleArray cap = this.getCapSchedule().isPresent() ? this.capSchedule.resolveValues(adjustedSchedule) : null;
        DoubleArray floor = this.getFloorSchedule().isPresent() ? this.floorSchedule.resolveValues(adjustedSchedule) : null;
        DoubleArray notionals = this.notional.resolveValues(adjustedSchedule);
        DateAdjuster fixingDateAdjuster = this.fixingDateOffset.resolve(refData);
        DateAdjuster paymentDateAdjuster = this.paymentDateOffset.resolve(refData);
        ImmutableList.Builder cmsPeriodsBuild = ImmutableList.builder();
        for (int i = 0; i < adjustedSchedule.size(); ++i) {
            SchedulePeriod period = adjustedSchedule.getPeriod(i);
            LocalDate fixingDate = fixingDateAdjuster.adjust(this.fixingRelativeTo.equals((Object)FixingRelativeTo.PERIOD_START) ? period.getStartDate() : period.getEndDate());
            LocalDate paymentDate = paymentDateAdjuster.adjust(period.getEndDate());
            double signedNotional = this.payReceive.normalize(notionals.get(i));
            cmsPeriodsBuild.add((Object)CmsPeriod.builder().currency(this.currency).notional(signedNotional).startDate(period.getStartDate()).endDate(period.getEndDate()).unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate()).yearFraction(period.yearFraction(this.dayCount, adjustedSchedule)).paymentDate(paymentDate).fixingDate(fixingDate).caplet(cap != null ? Double.valueOf(cap.get(i)) : null).floorlet(floor != null ? Double.valueOf(floor.get(i)) : null).dayCount(this.dayCount).index(this.index).underlyingSwap(this.createUnderlyingSwap(fixingDate, refData)).build());
        }
        return ResolvedCmsLeg.builder().cmsPeriods((List<CmsPeriod>)cmsPeriodsBuild.build()).payReceive(this.payReceive).build();
    }

    private ResolvedSwap createUnderlyingSwap(LocalDate fixingDate, ReferenceData refData) {
        FixedFloatSwapConvention conv = this.index.getTemplate().getConvention();
        LocalDate effectiveDate = conv.calculateSpotDateFromTradeDate(fixingDate, refData);
        LocalDate maturityDate = effectiveDate.plus((TemporalAmount)this.index.getTemplate().getTenor());
        Swap swap = conv.toTrade(fixingDate, effectiveDate, maturityDate, BuySell.BUY, 1.0, 1.0).getProduct();
        return swap.resolve(refData);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    public PeriodicSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public DaysAdjustment getPaymentDateOffset() {
        return this.paymentDateOffset;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public ValueSchedule getNotional() {
        return this.notional;
    }

    public SwapIndex getIndex() {
        return this.index;
    }

    public FixingRelativeTo getFixingRelativeTo() {
        return this.fixingRelativeTo;
    }

    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public Optional<ValueSchedule> getCapSchedule() {
        return Optional.ofNullable(this.capSchedule);
    }

    public Optional<ValueSchedule> getFloorSchedule() {
        return Optional.ofNullable(this.floorSchedule);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CmsLeg other = (CmsLeg)obj;
            return JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal((Object)this.paymentSchedule, (Object)other.paymentSchedule) && JodaBeanUtils.equal((Object)this.paymentDateOffset, (Object)other.paymentDateOffset) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.notional, (Object)other.notional) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)((Object)this.fixingRelativeTo), (Object)((Object)other.fixingRelativeTo)) && JodaBeanUtils.equal((Object)this.fixingDateOffset, (Object)other.fixingDateOffset) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.capSchedule, (Object)other.capSchedule) && JodaBeanUtils.equal((Object)this.floorSchedule, (Object)other.floorSchedule);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.fixingRelativeTo));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.capSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.floorSchedule);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(384);
        buf.append("CmsLeg{");
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
        buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("fixingRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fixingRelativeTo))).append(',').append(' ');
        buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("capSchedule").append('=').append(JodaBeanUtils.toString((Object)this.capSchedule)).append(',').append(' ');
        buf.append("floorSchedule").append('=').append(JodaBeanUtils.toString((Object)this.floorSchedule));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CmsLeg> {
        private PayReceive payReceive;
        private PeriodicSchedule paymentSchedule;
        private DaysAdjustment paymentDateOffset;
        private Currency currency;
        private ValueSchedule notional;
        private SwapIndex index;
        private FixingRelativeTo fixingRelativeTo;
        private DaysAdjustment fixingDateOffset;
        private DayCount dayCount;
        private ValueSchedule capSchedule;
        private ValueSchedule floorSchedule;

        private Builder() {
            CmsLeg.applyDefaults(this);
        }

        private Builder(CmsLeg beanToCopy) {
            this.payReceive = beanToCopy.getPayReceive();
            this.paymentSchedule = beanToCopy.getPaymentSchedule();
            this.paymentDateOffset = beanToCopy.getPaymentDateOffset();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.index = beanToCopy.getIndex();
            this.fixingRelativeTo = beanToCopy.getFixingRelativeTo();
            this.fixingDateOffset = beanToCopy.getFixingDateOffset();
            this.dayCount = beanToCopy.getDayCount();
            this.capSchedule = beanToCopy.capSchedule;
            this.floorSchedule = beanToCopy.floorSchedule;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 100346066: {
                    return this.index;
                }
                case 232554996: {
                    return this.fixingRelativeTo;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -596212599: {
                    return this.capSchedule;
                }
                case -1562227005: {
                    return this.floorSchedule;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case -1499086147: {
                    this.paymentSchedule = (PeriodicSchedule)newValue;
                    break;
                }
                case -716438393: {
                    this.paymentDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (ValueSchedule)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (SwapIndex)newValue;
                    break;
                }
                case 232554996: {
                    this.fixingRelativeTo = (FixingRelativeTo)((Object)newValue);
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -596212599: {
                    this.capSchedule = (ValueSchedule)newValue;
                    break;
                }
                case -1562227005: {
                    this.floorSchedule = (ValueSchedule)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CmsLeg build() {
            CmsLeg.preBuild(this);
            return new CmsLeg(this.payReceive, this.paymentSchedule, this.paymentDateOffset, this.currency, this.notional, this.index, this.fixingRelativeTo, this.fixingDateOffset, this.dayCount, this.capSchedule, this.floorSchedule);
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder paymentSchedule(PeriodicSchedule paymentSchedule) {
            JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
            this.paymentSchedule = paymentSchedule;
            return this;
        }

        public Builder paymentDateOffset(DaysAdjustment paymentDateOffset) {
            JodaBeanUtils.notNull((Object)paymentDateOffset, (String)"paymentDateOffset");
            this.paymentDateOffset = paymentDateOffset;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(ValueSchedule notional) {
            JodaBeanUtils.notNull((Object)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder index(SwapIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder fixingRelativeTo(FixingRelativeTo fixingRelativeTo) {
            JodaBeanUtils.notNull((Object)((Object)fixingRelativeTo), (String)"fixingRelativeTo");
            this.fixingRelativeTo = fixingRelativeTo;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder capSchedule(ValueSchedule capSchedule) {
            this.capSchedule = capSchedule;
            return this;
        }

        public Builder floorSchedule(ValueSchedule floorSchedule) {
            this.floorSchedule = floorSchedule;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(384);
            buf.append("CmsLeg.Builder{");
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
            buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("fixingRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fixingRelativeTo))).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("capSchedule").append('=').append(JodaBeanUtils.toString((Object)this.capSchedule)).append(',').append(' ');
            buf.append("floorSchedule").append('=').append(JodaBeanUtils.toString((Object)this.floorSchedule));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", CmsLeg.class, PayReceive.class);
        private final MetaProperty<PeriodicSchedule> paymentSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentSchedule", CmsLeg.class, PeriodicSchedule.class);
        private final MetaProperty<DaysAdjustment> paymentDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDateOffset", CmsLeg.class, DaysAdjustment.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CmsLeg.class, Currency.class);
        private final MetaProperty<ValueSchedule> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", CmsLeg.class, ValueSchedule.class);
        private final MetaProperty<SwapIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", CmsLeg.class, SwapIndex.class);
        private final MetaProperty<FixingRelativeTo> fixingRelativeTo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingRelativeTo", CmsLeg.class, FixingRelativeTo.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", CmsLeg.class, DaysAdjustment.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", CmsLeg.class, DayCount.class);
        private final MetaProperty<ValueSchedule> capSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"capSchedule", CmsLeg.class, ValueSchedule.class);
        private final MetaProperty<ValueSchedule> floorSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"floorSchedule", CmsLeg.class, ValueSchedule.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payReceive", "paymentSchedule", "paymentDateOffset", "currency", "notional", "index", "fixingRelativeTo", "fixingDateOffset", "dayCount", "capSchedule", "floorSchedule"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case 100346066: {
                    return this.index;
                }
                case 232554996: {
                    return this.fixingRelativeTo;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -596212599: {
                    return this.capSchedule;
                }
                case -1562227005: {
                    return this.floorSchedule;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CmsLeg> beanType() {
            return CmsLeg.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<PeriodicSchedule> paymentSchedule() {
            return this.paymentSchedule;
        }

        public MetaProperty<DaysAdjustment> paymentDateOffset() {
            return this.paymentDateOffset;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<ValueSchedule> notional() {
            return this.notional;
        }

        public MetaProperty<SwapIndex> index() {
            return this.index;
        }

        public MetaProperty<FixingRelativeTo> fixingRelativeTo() {
            return this.fixingRelativeTo;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<ValueSchedule> capSchedule() {
            return this.capSchedule;
        }

        public MetaProperty<ValueSchedule> floorSchedule() {
            return this.floorSchedule;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return ((CmsLeg)bean).getPayReceive();
                }
                case -1499086147: {
                    return ((CmsLeg)bean).getPaymentSchedule();
                }
                case -716438393: {
                    return ((CmsLeg)bean).getPaymentDateOffset();
                }
                case 575402001: {
                    return ((CmsLeg)bean).getCurrency();
                }
                case 1585636160: {
                    return ((CmsLeg)bean).getNotional();
                }
                case 100346066: {
                    return ((CmsLeg)bean).getIndex();
                }
                case 232554996: {
                    return ((CmsLeg)bean).getFixingRelativeTo();
                }
                case 873743726: {
                    return ((CmsLeg)bean).getFixingDateOffset();
                }
                case 1905311443: {
                    return ((CmsLeg)bean).getDayCount();
                }
                case -596212599: {
                    return ((CmsLeg)bean).capSchedule;
                }
                case -1562227005: {
                    return ((CmsLeg)bean).floorSchedule;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

