/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.cms;

import com.google.common.base.MoreObjects;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.cms.CmsPeriodType;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.SwapIndex;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CmsPeriod
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedEndDate;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double yearFraction;
    @PropertyDefinition(validate="notNull")
    private final LocalDate paymentDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate fixingDate;
    @PropertyDefinition(get="optional")
    private final Double caplet;
    @PropertyDefinition(get="optional")
    private final Double floorlet;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final SwapIndex index;
    @PropertyDefinition(validate="notNull")
    private final ResolvedSwap underlyingSwap;
    private static final long serialVersionUID = 1L;

    @ImmutableConstructor
    private CmsPeriod(Currency currency, double notional, LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate, double yearFraction, LocalDate paymentDate, LocalDate fixingDate, Double caplet, Double floorlet, DayCount dayCount, SwapIndex index, ResolvedSwap underlyingSwap) {
        this.index = (SwapIndex)ArgChecker.notNull((Object)index, (String)"index");
        this.currency = (Currency)ArgChecker.notNull((Object)currency, (String)"currency");
        this.notional = notional;
        this.startDate = (LocalDate)ArgChecker.notNull((Object)startDate, (String)"startDate");
        this.endDate = (LocalDate)ArgChecker.notNull((Object)endDate, (String)"endDate");
        this.unadjustedStartDate = (LocalDate)MoreObjects.firstNonNull((Object)unadjustedStartDate, (Object)startDate);
        this.unadjustedEndDate = (LocalDate)MoreObjects.firstNonNull((Object)unadjustedEndDate, (Object)endDate);
        this.yearFraction = ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
        this.paymentDate = (LocalDate)ArgChecker.notNull((Object)paymentDate, (String)"paymentDate");
        this.fixingDate = (LocalDate)ArgChecker.notNull((Object)fixingDate, (String)"fixingDate");
        this.caplet = caplet;
        this.floorlet = floorlet;
        this.dayCount = (DayCount)ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        this.underlyingSwap = (ResolvedSwap)ArgChecker.notNull((Object)underlyingSwap, (String)"underlyingSwap");
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
        ArgChecker.inOrderNotEqual((Comparable)this.unadjustedStartDate, (Object)this.unadjustedEndDate, (String)"unadjustedStartDate", (String)"unadjustedEndDate");
        ArgChecker.isFalse((this.getCaplet().isPresent() && this.getFloorlet().isPresent() ? 1 : 0) != 0, (String)"At least one of cap and floor should be null");
    }

    public CmsPeriodType getCmsPeriodType() {
        if (this.getCaplet().isPresent()) {
            return CmsPeriodType.CAPLET;
        }
        if (this.getFloorlet().isPresent()) {
            return CmsPeriodType.FLOORLET;
        }
        return CmsPeriodType.COUPON;
    }

    public double getStrike() {
        CmsPeriodType type = this.getCmsPeriodType();
        if (type.equals((Object)CmsPeriodType.CAPLET)) {
            return this.caplet;
        }
        if (type.equals((Object)CmsPeriodType.FLOORLET)) {
            return this.floorlet;
        }
        return 0.0;
    }

    public CmsPeriod toCouponEquivalent() {
        return this.toBuilder().floorlet(null).caplet(null).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalDate getUnadjustedStartDate() {
        return this.unadjustedStartDate;
    }

    public LocalDate getUnadjustedEndDate() {
        return this.unadjustedEndDate;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public LocalDate getFixingDate() {
        return this.fixingDate;
    }

    public OptionalDouble getCaplet() {
        return this.caplet != null ? OptionalDouble.of(this.caplet) : OptionalDouble.empty();
    }

    public OptionalDouble getFloorlet() {
        return this.floorlet != null ? OptionalDouble.of(this.floorlet) : OptionalDouble.empty();
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public SwapIndex getIndex() {
        return this.index;
    }

    public ResolvedSwap getUnderlyingSwap() {
        return this.underlyingSwap;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CmsPeriod other = (CmsPeriod)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.unadjustedStartDate, (Object)other.unadjustedStartDate) && JodaBeanUtils.equal((Object)this.unadjustedEndDate, (Object)other.unadjustedEndDate) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate) && JodaBeanUtils.equal((Object)this.fixingDate, (Object)other.fixingDate) && JodaBeanUtils.equal((Object)this.caplet, (Object)other.caplet) && JodaBeanUtils.equal((Object)this.floorlet, (Object)other.floorlet) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.underlyingSwap, (Object)other.underlyingSwap);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.caplet);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.floorlet);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingSwap);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(480);
        buf.append("CmsPeriod{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
        buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
        buf.append("fixingDate").append('=').append(JodaBeanUtils.toString((Object)this.fixingDate)).append(',').append(' ');
        buf.append("caplet").append('=').append(JodaBeanUtils.toString((Object)this.caplet)).append(',').append(' ');
        buf.append("floorlet").append('=').append(JodaBeanUtils.toString((Object)this.floorlet)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("underlyingSwap").append('=').append(JodaBeanUtils.toString((Object)this.underlyingSwap));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CmsPeriod> {
        private Currency currency;
        private double notional;
        private LocalDate startDate;
        private LocalDate endDate;
        private LocalDate unadjustedStartDate;
        private LocalDate unadjustedEndDate;
        private double yearFraction;
        private LocalDate paymentDate;
        private LocalDate fixingDate;
        private Double caplet;
        private Double floorlet;
        private DayCount dayCount;
        private SwapIndex index;
        private ResolvedSwap underlyingSwap;

        private Builder() {
        }

        private Builder(CmsPeriod beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.unadjustedStartDate = beanToCopy.getUnadjustedStartDate();
            this.unadjustedEndDate = beanToCopy.getUnadjustedEndDate();
            this.yearFraction = beanToCopy.getYearFraction();
            this.paymentDate = beanToCopy.getPaymentDate();
            this.fixingDate = beanToCopy.getFixingDate();
            this.caplet = beanToCopy.caplet;
            this.floorlet = beanToCopy.floorlet;
            this.dayCount = beanToCopy.getDayCount();
            this.index = beanToCopy.getIndex();
            this.underlyingSwap = beanToCopy.getUnderlyingSwap();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case -1367656183: {
                    return this.caplet;
                }
                case 2022994575: {
                    return this.floorlet;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 100346066: {
                    return this.index;
                }
                case 1497421456: {
                    return this.underlyingSwap;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 1457691881: {
                    this.unadjustedStartDate = (LocalDate)newValue;
                    break;
                }
                case 31758114: {
                    this.unadjustedEndDate = (LocalDate)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case -1540873516: {
                    this.paymentDate = (LocalDate)newValue;
                    break;
                }
                case 1255202043: {
                    this.fixingDate = (LocalDate)newValue;
                    break;
                }
                case -1367656183: {
                    this.caplet = (Double)newValue;
                    break;
                }
                case 2022994575: {
                    this.floorlet = (Double)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (SwapIndex)newValue;
                    break;
                }
                case 1497421456: {
                    this.underlyingSwap = (ResolvedSwap)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CmsPeriod build() {
            return new CmsPeriod(this.currency, this.notional, this.startDate, this.endDate, this.unadjustedStartDate, this.unadjustedEndDate, this.yearFraction, this.paymentDate, this.fixingDate, this.caplet, this.floorlet, this.dayCount, this.index, this.underlyingSwap);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            this.notional = notional;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder unadjustedStartDate(LocalDate unadjustedStartDate) {
            JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
            this.unadjustedStartDate = unadjustedStartDate;
            return this;
        }

        public Builder unadjustedEndDate(LocalDate unadjustedEndDate) {
            JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
            this.unadjustedEndDate = unadjustedEndDate;
            return this;
        }

        public Builder yearFraction(double yearFraction) {
            ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
            this.yearFraction = yearFraction;
            return this;
        }

        public Builder paymentDate(LocalDate paymentDate) {
            JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
            this.paymentDate = paymentDate;
            return this;
        }

        public Builder fixingDate(LocalDate fixingDate) {
            JodaBeanUtils.notNull((Object)fixingDate, (String)"fixingDate");
            this.fixingDate = fixingDate;
            return this;
        }

        public Builder caplet(Double caplet) {
            this.caplet = caplet;
            return this;
        }

        public Builder floorlet(Double floorlet) {
            this.floorlet = floorlet;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder index(SwapIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder underlyingSwap(ResolvedSwap underlyingSwap) {
            JodaBeanUtils.notNull((Object)underlyingSwap, (String)"underlyingSwap");
            this.underlyingSwap = underlyingSwap;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(480);
            buf.append("CmsPeriod.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
            buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
            buf.append("fixingDate").append('=').append(JodaBeanUtils.toString((Object)this.fixingDate)).append(',').append(' ');
            buf.append("caplet").append('=').append(JodaBeanUtils.toString((Object)this.caplet)).append(',').append(' ');
            buf.append("floorlet").append('=').append(JodaBeanUtils.toString((Object)this.floorlet)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("underlyingSwap").append('=').append(JodaBeanUtils.toString((Object)this.underlyingSwap));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CmsPeriod.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", CmsPeriod.class, Double.TYPE);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", CmsPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", CmsPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedStartDate", CmsPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedEndDate", CmsPeriod.class, LocalDate.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", CmsPeriod.class, Double.TYPE);
        private final MetaProperty<LocalDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", CmsPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> fixingDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDate", CmsPeriod.class, LocalDate.class);
        private final MetaProperty<Double> caplet = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"caplet", CmsPeriod.class, Double.class);
        private final MetaProperty<Double> floorlet = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"floorlet", CmsPeriod.class, Double.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", CmsPeriod.class, DayCount.class);
        private final MetaProperty<SwapIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", CmsPeriod.class, SwapIndex.class);
        private final MetaProperty<ResolvedSwap> underlyingSwap = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingSwap", CmsPeriod.class, ResolvedSwap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "notional", "startDate", "endDate", "unadjustedStartDate", "unadjustedEndDate", "yearFraction", "paymentDate", "fixingDate", "caplet", "floorlet", "dayCount", "index", "underlyingSwap"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case -1367656183: {
                    return this.caplet;
                }
                case 2022994575: {
                    return this.floorlet;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 100346066: {
                    return this.index;
                }
                case 1497421456: {
                    return this.underlyingSwap;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CmsPeriod> beanType() {
            return CmsPeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<LocalDate> unadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        public MetaProperty<LocalDate> unadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<LocalDate> paymentDate() {
            return this.paymentDate;
        }

        public MetaProperty<LocalDate> fixingDate() {
            return this.fixingDate;
        }

        public MetaProperty<Double> caplet() {
            return this.caplet;
        }

        public MetaProperty<Double> floorlet() {
            return this.floorlet;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<SwapIndex> index() {
            return this.index;
        }

        public MetaProperty<ResolvedSwap> underlyingSwap() {
            return this.underlyingSwap;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((CmsPeriod)bean).getCurrency();
                }
                case 1585636160: {
                    return ((CmsPeriod)bean).getNotional();
                }
                case -2129778896: {
                    return ((CmsPeriod)bean).getStartDate();
                }
                case -1607727319: {
                    return ((CmsPeriod)bean).getEndDate();
                }
                case 1457691881: {
                    return ((CmsPeriod)bean).getUnadjustedStartDate();
                }
                case 31758114: {
                    return ((CmsPeriod)bean).getUnadjustedEndDate();
                }
                case -1731780257: {
                    return ((CmsPeriod)bean).getYearFraction();
                }
                case -1540873516: {
                    return ((CmsPeriod)bean).getPaymentDate();
                }
                case 1255202043: {
                    return ((CmsPeriod)bean).getFixingDate();
                }
                case -1367656183: {
                    return ((CmsPeriod)bean).caplet;
                }
                case 2022994575: {
                    return ((CmsPeriod)bean).floorlet;
                }
                case 1905311443: {
                    return ((CmsPeriod)bean).getDayCount();
                }
                case 100346066: {
                    return ((CmsPeriod)bean).getIndex();
                }
                case 1497421456: {
                    return ((CmsPeriod)bean).getUnderlyingSwap();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

