/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.cms;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.AdjustablePayment;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.ProductTrade;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.ResolvableTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.cms.Cms;
import com.opengamma.strata.product.cms.CmsLeg;
import com.opengamma.strata.product.cms.ResolvedCmsTrade;
import com.opengamma.strata.product.common.SummarizerUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CmsTrade
implements ProductTrade,
ResolvableTrade<ResolvedCmsTrade>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TradeInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Cms product;
    @PropertyDefinition(get="optional")
    private final AdjustablePayment premium;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    @Override
    public CmsTrade withInfo(PortfolioItemInfo info) {
        return new CmsTrade(TradeInfo.from(info), this.product, this.premium);
    }

    @Override
    public PortfolioItemSummary summarize() {
        StringBuilder buf = new StringBuilder(96);
        CmsLeg mainLeg = this.product.getCmsLeg();
        buf.append(SummarizerUtils.datePeriod(mainLeg.getStartDate().getUnadjusted(), mainLeg.getEndDate().getUnadjusted()));
        buf.append(' ');
        buf.append(SummarizerUtils.amount(mainLeg.getCurrency(), mainLeg.getNotional().getInitialValue()));
        buf.append(' ');
        if (mainLeg.getPayReceive().isReceive()) {
            buf.append("Rec ");
            this.summarizeMainLeg(mainLeg, buf);
            buf.append(this.getPremium().isPresent() ? " / Pay Premium" : (this.product.getPayLeg().isPresent() ? " /  Pay Periodic" : ""));
        } else {
            buf.append(this.getPremium().isPresent() ? "Rec Premium / Pay " : (this.product.getPayLeg().isPresent() ? "Rec Periodic / Pay " : ""));
            this.summarizeMainLeg(mainLeg, buf);
        }
        buf.append(" : ");
        buf.append(SummarizerUtils.dateRange(mainLeg.getStartDate().getUnadjusted(), mainLeg.getEndDate().getUnadjusted()));
        return SummarizerUtils.summary(this, ProductType.CMS, buf.toString(), mainLeg.getCurrency());
    }

    private void summarizeMainLeg(CmsLeg mainLeg, StringBuilder buf) {
        buf.append(mainLeg.getIndex());
        buf.append(' ');
        if (mainLeg.getCapSchedule().isPresent()) {
            buf.append("Cap ");
            buf.append(SummarizerUtils.percent(mainLeg.getCapSchedule().get().getInitialValue()));
        }
        if (mainLeg.getFloorSchedule().isPresent()) {
            buf.append("Floor ");
            buf.append(SummarizerUtils.percent(mainLeg.getFloorSchedule().get().getInitialValue()));
        }
    }

    @Override
    public ResolvedCmsTrade resolve(ReferenceData refData) {
        return ResolvedCmsTrade.builder().info(this.info).product(this.product.resolve(refData)).premium(this.premium != null ? this.premium.resolve(refData) : null).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private CmsTrade(TradeInfo info, Cms product, AdjustablePayment premium) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        this.info = info;
        this.product = product;
        this.premium = premium;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public TradeInfo getInfo() {
        return this.info;
    }

    @Override
    public Cms getProduct() {
        return this.product;
    }

    public Optional<AdjustablePayment> getPremium() {
        return Optional.ofNullable(this.premium);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CmsTrade other = (CmsTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product) && JodaBeanUtils.equal((Object)this.premium, (Object)other.premium);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.premium);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("CmsTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
        buf.append("premium").append('=').append(JodaBeanUtils.toString((Object)this.premium));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CmsTrade> {
        private TradeInfo info;
        private Cms product;
        private AdjustablePayment premium;

        private Builder() {
            CmsTrade.applyDefaults(this);
        }

        private Builder(CmsTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
            this.premium = beanToCopy.premium;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -318452137: {
                    return this.premium;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (TradeInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (Cms)newValue;
                    break;
                }
                case -318452137: {
                    this.premium = (AdjustablePayment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CmsTrade build() {
            return new CmsTrade(this.info, this.product, this.premium);
        }

        public Builder info(TradeInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(Cms product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public Builder premium(AdjustablePayment premium) {
            this.premium = premium;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("CmsTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
            buf.append("premium").append('=').append(JodaBeanUtils.toString((Object)this.premium));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<TradeInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", CmsTrade.class, TradeInfo.class);
        private final MetaProperty<Cms> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", CmsTrade.class, Cms.class);
        private final MetaProperty<AdjustablePayment> premium = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"premium", CmsTrade.class, AdjustablePayment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product", "premium"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -318452137: {
                    return this.premium;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CmsTrade> beanType() {
            return CmsTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<TradeInfo> info() {
            return this.info;
        }

        public MetaProperty<Cms> product() {
            return this.product;
        }

        public MetaProperty<AdjustablePayment> premium() {
            return this.premium;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((CmsTrade)bean).getInfo();
                }
                case -309474065: {
                    return ((CmsTrade)bean).getProduct();
                }
                case -318452137: {
                    return ((CmsTrade)bean).premium;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

