/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.cms;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.cms.ResolvedCmsLeg;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ResolvedCms
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ResolvedCmsLeg cmsLeg;
    @PropertyDefinition(get="optional")
    private final ResolvedSwapLeg payLeg;
    private static final long serialVersionUID = 1L;

    public static ResolvedCms of(ResolvedCmsLeg cmsLeg) {
        return new ResolvedCms(cmsLeg, null);
    }

    public static ResolvedCms of(ResolvedCmsLeg cmsLeg, ResolvedSwapLeg payLeg) {
        ArgChecker.notNull((Object)cmsLeg, (String)"cmsLeg");
        ArgChecker.notNull((Object)payLeg, (String)"payLeg");
        return new ResolvedCms(cmsLeg, payLeg);
    }

    @ImmutableValidator
    private void validate() {
        if (this.getPayLeg().isPresent()) {
            ArgChecker.isFalse((boolean)this.payLeg.getPayReceive().equals((Object)this.cmsLeg.getPayReceive()), (String)"Two legs should have different Pay/Receive flags");
        }
    }

    public ImmutableSet<Currency> allPaymentCurrencies() {
        if (this.payLeg == null) {
            return ImmutableSet.of((Object)this.cmsLeg.getCurrency());
        }
        return ImmutableSet.of((Object)this.cmsLeg.getCurrency(), (Object)this.payLeg.getCurrency());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ResolvedCms(ResolvedCmsLeg cmsLeg, ResolvedSwapLeg payLeg) {
        JodaBeanUtils.notNull((Object)cmsLeg, (String)"cmsLeg");
        this.cmsLeg = cmsLeg;
        this.payLeg = payLeg;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ResolvedCmsLeg getCmsLeg() {
        return this.cmsLeg;
    }

    public Optional<ResolvedSwapLeg> getPayLeg() {
        return Optional.ofNullable(this.payLeg);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedCms other = (ResolvedCms)obj;
            return JodaBeanUtils.equal((Object)this.cmsLeg, (Object)other.cmsLeg) && JodaBeanUtils.equal((Object)this.payLeg, (Object)other.payLeg);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.cmsLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.payLeg);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ResolvedCms{");
        buf.append("cmsLeg").append('=').append(JodaBeanUtils.toString((Object)this.cmsLeg)).append(',').append(' ');
        buf.append("payLeg").append('=').append(JodaBeanUtils.toString((Object)this.payLeg));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ResolvedCms> {
        private ResolvedCmsLeg cmsLeg;
        private ResolvedSwapLeg payLeg;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1356515323: {
                    return this.cmsLeg;
                }
                case -995239866: {
                    return this.payLeg;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1356515323: {
                    this.cmsLeg = (ResolvedCmsLeg)newValue;
                    break;
                }
                case -995239866: {
                    this.payLeg = (ResolvedSwapLeg)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ResolvedCms build() {
            return new ResolvedCms(this.cmsLeg, this.payLeg);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ResolvedCms.Builder{");
            buf.append("cmsLeg").append('=').append(JodaBeanUtils.toString((Object)this.cmsLeg)).append(',').append(' ');
            buf.append("payLeg").append('=').append(JodaBeanUtils.toString((Object)this.payLeg));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ResolvedCmsLeg> cmsLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cmsLeg", ResolvedCms.class, ResolvedCmsLeg.class);
        private final MetaProperty<ResolvedSwapLeg> payLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payLeg", ResolvedCms.class, ResolvedSwapLeg.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"cmsLeg", "payLeg"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1356515323: {
                    return this.cmsLeg;
                }
                case -995239866: {
                    return this.payLeg;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ResolvedCms> builder() {
            return new Builder();
        }

        public Class<? extends ResolvedCms> beanType() {
            return ResolvedCms.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ResolvedCmsLeg> cmsLeg() {
            return this.cmsLeg;
        }

        public MetaProperty<ResolvedSwapLeg> payLeg() {
            return this.payLeg;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1356515323: {
                    return ((ResolvedCms)bean).getCmsLeg();
                }
                case -995239866: {
                    return ((ResolvedCms)bean).payLeg;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

