/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.cms;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.cms.CmsPeriod;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.SwapIndex;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedCmsLeg
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<CmsPeriod> cmsPeriods;
    private static final long serialVersionUID = 1L;

    @ImmutableConstructor
    private ResolvedCmsLeg(PayReceive payReceive, List<CmsPeriod> cmsPeriods) {
        this.payReceive = (PayReceive)((Object)ArgChecker.notNull((Object)((Object)payReceive), (String)"payReceive"));
        this.cmsPeriods = ImmutableList.copyOf(cmsPeriods);
        Set currencies = this.cmsPeriods.stream().map(CmsPeriod::getCurrency).collect(Collectors.toSet());
        ArgChecker.isTrue((currencies.size() == 1 ? 1 : 0) != 0, (String)("Leg must have a single currency, found: " + currencies));
        Set swapIndices = this.cmsPeriods.stream().map(CmsPeriod::getIndex).collect(Collectors.toSet());
        ArgChecker.isTrue((swapIndices.size() == 1 ? 1 : 0) != 0, (String)("Leg must have a single swap index: " + swapIndices));
    }

    public LocalDate getStartDate() {
        return ((CmsPeriod)this.cmsPeriods.get(0)).getStartDate();
    }

    public LocalDate getEndDate() {
        return ((CmsPeriod)this.cmsPeriods.get(this.cmsPeriods.size() - 1)).getEndDate();
    }

    public Currency getCurrency() {
        return ((CmsPeriod)this.cmsPeriods.get(0)).getCurrency();
    }

    public SwapIndex getIndex() {
        return ((CmsPeriod)this.cmsPeriods.get(0)).getIndex();
    }

    public RateIndex getUnderlyingIndex() {
        return this.getIndex().getTemplate().getConvention().getFloatingLeg().getIndex();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    public ImmutableList<CmsPeriod> getCmsPeriods() {
        return this.cmsPeriods;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedCmsLeg other = (ResolvedCmsLeg)obj;
            return JodaBeanUtils.equal((Object)((Object)this.payReceive), (Object)((Object)other.payReceive)) && JodaBeanUtils.equal(this.cmsPeriods, other.cmsPeriods);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.payReceive));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.cmsPeriods);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ResolvedCmsLeg{");
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
        buf.append("cmsPeriods").append('=').append(JodaBeanUtils.toString(this.cmsPeriods));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedCmsLeg> {
        private PayReceive payReceive;
        private List<CmsPeriod> cmsPeriods = ImmutableList.of();

        private Builder() {
        }

        private Builder(ResolvedCmsLeg beanToCopy) {
            this.payReceive = beanToCopy.getPayReceive();
            this.cmsPeriods = beanToCopy.getCmsPeriods();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 2121598281: {
                    return this.cmsPeriods;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    this.payReceive = (PayReceive)((Object)newValue);
                    break;
                }
                case 2121598281: {
                    this.cmsPeriods = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedCmsLeg build() {
            return new ResolvedCmsLeg(this.payReceive, this.cmsPeriods);
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)((Object)payReceive), (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder cmsPeriods(List<CmsPeriod> cmsPeriods) {
            JodaBeanUtils.notEmpty(cmsPeriods, (String)"cmsPeriods");
            this.cmsPeriods = cmsPeriods;
            return this;
        }

        public Builder cmsPeriods(CmsPeriod ... cmsPeriods) {
            return this.cmsPeriods((List<CmsPeriod>)ImmutableList.copyOf((Object[])cmsPeriods));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ResolvedCmsLeg.Builder{");
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)((Object)this.payReceive))).append(',').append(' ');
            buf.append("cmsPeriods").append('=').append(JodaBeanUtils.toString(this.cmsPeriods));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", ResolvedCmsLeg.class, PayReceive.class);
        private final MetaProperty<ImmutableList<CmsPeriod>> cmsPeriods = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cmsPeriods", ResolvedCmsLeg.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"payReceive", "cmsPeriods"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return this.payReceive;
                }
                case 2121598281: {
                    return this.cmsPeriods;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedCmsLeg> beanType() {
            return ResolvedCmsLeg.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<ImmutableList<CmsPeriod>> cmsPeriods() {
            return this.cmsPeriods;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -885469925: {
                    return ((ResolvedCmsLeg)bean).getPayReceive();
                }
                case 2121598281: {
                    return ((ResolvedCmsLeg)bean).getCmsPeriods();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

