/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.common;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum BuySell implements NamedEnum
{
    BUY,
    SELL;

    private static final EnumNames<BuySell> NAMES;

    @FromString
    public static BuySell of(String name) {
        return (BuySell)NAMES.parse(name);
    }

    public static BuySell ofBuy(boolean isBuy) {
        return isBuy ? BUY : SELL;
    }

    public double normalize(double amount) {
        double normalized = Math.abs(amount);
        if (normalized == 0.0) {
            return 0.0;
        }
        return this.isBuy() ? normalized : -normalized;
    }

    public CurrencyAmount normalize(CurrencyAmount amount) {
        return this.isBuy() ? amount.positive() : amount.negative();
    }

    public boolean isBuy() {
        return this == BUY;
    }

    public boolean isSell() {
        return this == SELL;
    }

    public BuySell opposite() {
        return this.isBuy() ? SELL : BUY;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(BuySell.class);
    }
}

