/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.common;

import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum CapFloor implements NamedEnum
{
    CAP,
    FLOOR;

    private static final EnumNames<CapFloor> NAMES;

    @FromString
    public static CapFloor of(String name) {
        return (CapFloor)NAMES.parse(name.toUpperCase(Locale.ENGLISH));
    }

    public boolean isCap() {
        return this == CAP;
    }

    public boolean isFloor() {
        return this == FLOOR;
    }

    public CapFloor opposite() {
        return this.isCap() ? FLOOR : CAP;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(CapFloor.class);
    }
}

