/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.common;

import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum LongShort implements NamedEnum
{
    LONG(1),
    SHORT(-1);

    private static final EnumNames<LongShort> NAMES;
    private final boolean isLong;
    private final int sign;

    @FromString
    public static LongShort of(String name) {
        return (LongShort)NAMES.parse(name);
    }

    public static LongShort ofLong(boolean isLong) {
        return isLong ? LONG : SHORT;
    }

    private LongShort(int sign) {
        this.isLong = sign == 1;
        this.sign = sign;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isShort() {
        return !this.isLong;
    }

    public int sign() {
        return this.sign;
    }

    public LongShort opposite() {
        return this.isLong() ? SHORT : LONG;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(LongShort.class);
    }
}

