/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.common;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum PayReceive implements NamedEnum
{
    PAY,
    RECEIVE;

    private static final EnumNames<PayReceive> NAMES;

    @FromString
    public static PayReceive of(String name) {
        return (PayReceive)NAMES.parse(name);
    }

    public static PayReceive ofPay(boolean isPay) {
        return isPay ? PAY : RECEIVE;
    }

    public static PayReceive ofSignedAmount(double amount) {
        return Double.compare(amount, 0.0) < 0 ? PAY : RECEIVE;
    }

    public double normalize(double amount) {
        double normalized = Math.abs(amount);
        if (normalized == 0.0) {
            return 0.0;
        }
        return this.isPay() ? -normalized : normalized;
    }

    public CurrencyAmount normalize(CurrencyAmount amount) {
        return this.isPay() ? amount.negative() : amount.positive();
    }

    public boolean isPay() {
        return this == PAY;
    }

    public boolean isReceive() {
        return this == RECEIVE;
    }

    public PayReceive opposite() {
        return this.isPay() ? RECEIVE : PAY;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(PayReceive.class);
    }
}

