/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.common;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.Decimal;
import com.opengamma.strata.collect.Percentage;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.PortfolioItemType;
import com.opengamma.strata.product.Position;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.Trade;
import com.opengamma.strata.product.common.PayReceive;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Set;

public final class SummarizerUtils {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dMMMuu", Locale.ENGLISH);

    private SummarizerUtils() {
    }

    public static String date(LocalDate date) {
        return date.format(DATE_FORMAT);
    }

    public static String dateRange(LocalDate start, LocalDate end) {
        return SummarizerUtils.date(start) + "-" + SummarizerUtils.date(end);
    }

    public static String datePeriod(LocalDate start, LocalDate end) {
        int months = Math.toIntExact(ChronoUnit.MONTHS.between(start, end.plusDays(3L)));
        if (months > 0) {
            return Tenor.of((Period)Period.ofMonths(months)).normalized().toString();
        }
        return Tenor.of((Period)Period.ofDays((int)start.until(end, ChronoUnit.DAYS))).toString();
    }

    public static String amount(CurrencyAmount currencyAmount) {
        return SummarizerUtils.amount(currencyAmount.getCurrency(), currencyAmount.getAmount());
    }

    public static String amount(Currency currency, double value) {
        BigDecimal dec = BigDecimal.valueOf(value).stripTrailingZeros();
        String symbol = currency.getCode() + " ";
        if (dec.scale() <= -3) {
            if (Math.abs(dec.longValue()) >= 1000000L) {
                dec = dec.movePointLeft(6);
                return symbol + dec.toPlainString() + "mm";
            }
            dec = dec.movePointLeft(3);
            return symbol + dec.toPlainString() + "k";
        }
        if (dec.scale() > currency.getMinorUnitDigits()) {
            dec = dec.setScale(currency.getMinorUnitDigits(), RoundingMode.HALF_UP);
        }
        DecimalFormat formatter = new DecimalFormat("###,###.###", new DecimalFormatSymbols(Locale.ENGLISH));
        return symbol + formatter.format(dec);
    }

    public static String value(double value) {
        Decimal dec = Decimal.of((double)value);
        return dec.roundToScale(6, RoundingMode.HALF_UP).toString();
    }

    public static String percent(double decimalForm) {
        Percentage pct = Percentage.fromDecimalForm((double)decimalForm);
        return pct.map(dec -> dec.roundToScale(4, RoundingMode.HALF_UP)).toString();
    }

    public static String payReceive(PayReceive payReceive) {
        return payReceive.toString().substring(0, 3);
    }

    public static String fx(CurrencyAmount base, CurrencyAmount counter) {
        BigDecimal rateDec = BigDecimal.valueOf(counter.getAmount() / base.getAmount()).setScale(base.getCurrency().getMinorUnitDigits() + 2, RoundingMode.HALF_UP).abs();
        FxRate rate = FxRate.of((Currency)base.getCurrency(), (Currency)counter.getCurrency(), (double)rateDec.doubleValue());
        BigDecimal baseDec = BigDecimal.valueOf(base.getAmount()).stripTrailingZeros();
        BigDecimal counterDec = BigDecimal.valueOf(counter.getAmount()).stripTrailingZeros();
        boolean roundBase = baseDec.scale() < counterDec.scale();
        CurrencyAmount round = roundBase ? base : counter;
        return (round.getAmount() < 0.0 ? "Pay " : "Rec ") + SummarizerUtils.amount(round.mapAmount(a -> Math.abs(a))) + " @ " + rate;
    }

    public static PortfolioItemSummary summary(Position position, ProductType type, String description, Currency ... currencies) {
        return PortfolioItemSummary.of(position.getId().orElse(null), PortfolioItemType.POSITION, type, (Set<Currency>)ImmutableSet.copyOf((Object[])currencies), description);
    }

    public static PortfolioItemSummary summary(Trade trade, ProductType type, String description, Currency ... currencies) {
        return PortfolioItemSummary.of(trade.getId().orElse(null), PortfolioItemType.TRADE, type, (Set<Currency>)ImmutableSet.copyOf((Object[])currencies), description);
    }
}

