/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.credit.CreditCouponPaymentPeriod;
import com.opengamma.strata.product.credit.PaymentOnDefault;
import com.opengamma.strata.product.credit.ProtectionStartOfDay;
import com.opengamma.strata.product.credit.ResolvedCds;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class Cds
implements Product,
Resolvable<ResolvedCds>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final BuySell buySell;
    @PropertyDefinition(validate="notNull")
    private final StandardId legalEntityId;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final PeriodicSchedule paymentSchedule;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double fixedRate;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final PaymentOnDefault paymentOnDefault;
    @PropertyDefinition(validate="notNull")
    private final ProtectionStartOfDay protectionStart;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment stepinDateOffset;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment settlementDateOffset;
    private static final long serialVersionUID = 1L;

    public static Cds of(BuySell buySell, StandardId legalEntityId, Currency currency, double notional, LocalDate startDate, LocalDate endDate, Frequency paymentFrequency, HolidayCalendarId calendar, double fixedRate) {
        PeriodicSchedule accrualSchedule = PeriodicSchedule.builder().businessDayAdjustment(BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)calendar)).startDate(startDate).endDate(endDate).startDateBusinessDayAdjustment(BusinessDayAdjustment.NONE).endDateBusinessDayAdjustment(BusinessDayAdjustment.NONE).frequency(paymentFrequency).rollConvention(RollConventions.NONE).stubConvention(StubConvention.SMART_INITIAL).build();
        return new Cds(buySell, legalEntityId, currency, notional, accrualSchedule, fixedRate, DayCounts.ACT_360, PaymentOnDefault.ACCRUED_PREMIUM, ProtectionStartOfDay.BEGINNING, DaysAdjustment.ofCalendarDays((int)1), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)calendar));
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.dayCount = DayCounts.ACT_360;
        builder.paymentOnDefault = PaymentOnDefault.ACCRUED_PREMIUM;
        builder.protectionStart = ProtectionStartOfDay.BEGINNING;
        builder.stepinDateOffset = DaysAdjustment.ofCalendarDays((int)1);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.settlementDateOffset == null && builder.paymentSchedule != null) {
            builder.settlementDateOffset = DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)builder.paymentSchedule.getBusinessDayAdjustment().getCalendar());
        }
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        return ImmutableSet.of((Object)this.currency);
    }

    public ResolvedCds resolve(ReferenceData refData) {
        Schedule adjustedSchedule = this.paymentSchedule.createSchedule(refData);
        ImmutableList.Builder accrualPeriods = ImmutableList.builder();
        int nPeriods = adjustedSchedule.size();
        for (int i = 0; i < nPeriods - 1; ++i) {
            SchedulePeriod period = adjustedSchedule.getPeriod(i);
            accrualPeriods.add((Object)CreditCouponPaymentPeriod.builder().startDate(period.getStartDate()).endDate(period.getEndDate()).unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate()).effectiveStartDate(this.protectionStart.isBeginning() ? period.getStartDate().minusDays(1L) : period.getStartDate()).effectiveEndDate(this.protectionStart.isBeginning() ? period.getEndDate().minusDays(1L) : period.getEndDate()).paymentDate(period.getEndDate()).notional(this.notional).currency(this.currency).fixedRate(this.fixedRate).yearFraction(period.yearFraction(this.dayCount, adjustedSchedule)).build());
        }
        SchedulePeriod lastPeriod = adjustedSchedule.getPeriod(nPeriods - 1);
        LocalDate accEndDate = this.protectionStart.isBeginning() ? lastPeriod.getEndDate().plusDays(1L) : lastPeriod.getEndDate();
        SchedulePeriod modifiedPeriod = lastPeriod.toBuilder().endDate(accEndDate).build();
        accrualPeriods.add((Object)CreditCouponPaymentPeriod.builder().startDate(modifiedPeriod.getStartDate()).endDate(modifiedPeriod.getEndDate()).unadjustedStartDate(modifiedPeriod.getUnadjustedStartDate()).unadjustedEndDate(modifiedPeriod.getUnadjustedEndDate()).effectiveStartDate(this.protectionStart.isBeginning() ? lastPeriod.getStartDate().minusDays(1L) : lastPeriod.getStartDate()).effectiveEndDate(lastPeriod.getEndDate()).paymentDate(this.paymentSchedule.getBusinessDayAdjustment().adjust(lastPeriod.getEndDate(), refData)).notional(this.notional).currency(this.currency).fixedRate(this.fixedRate).yearFraction(modifiedPeriod.yearFraction(this.dayCount, adjustedSchedule)).build());
        ImmutableList paymentPeriods = accrualPeriods.build();
        return ResolvedCds.builder().buySell(this.buySell).legalEntityId(this.legalEntityId).protectionStart(this.protectionStart).paymentOnDefault(this.paymentOnDefault).paymentPeriods((List<CreditCouponPaymentPeriod>)paymentPeriods).protectionEndDate(lastPeriod.getEndDate()).settlementDateOffset(this.settlementDateOffset).stepinDateOffset(this.stepinDateOffset).dayCount(this.dayCount).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Cds(BuySell buySell, StandardId legalEntityId, Currency currency, double notional, PeriodicSchedule paymentSchedule, double fixedRate, DayCount dayCount, PaymentOnDefault paymentOnDefault, ProtectionStartOfDay protectionStart, DaysAdjustment stepinDateOffset, DaysAdjustment settlementDateOffset) {
        JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
        ArgChecker.notNegative((double)fixedRate, (String)"fixedRate");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)paymentOnDefault), (String)"paymentOnDefault");
        JodaBeanUtils.notNull((Object)((Object)protectionStart), (String)"protectionStart");
        JodaBeanUtils.notNull((Object)stepinDateOffset, (String)"stepinDateOffset");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        this.buySell = buySell;
        this.legalEntityId = legalEntityId;
        this.currency = currency;
        this.notional = notional;
        this.paymentSchedule = paymentSchedule;
        this.fixedRate = fixedRate;
        this.dayCount = dayCount;
        this.paymentOnDefault = paymentOnDefault;
        this.protectionStart = protectionStart;
        this.stepinDateOffset = stepinDateOffset;
        this.settlementDateOffset = settlementDateOffset;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public BuySell getBuySell() {
        return this.buySell;
    }

    public StandardId getLegalEntityId() {
        return this.legalEntityId;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public PeriodicSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public PaymentOnDefault getPaymentOnDefault() {
        return this.paymentOnDefault;
    }

    public ProtectionStartOfDay getProtectionStart() {
        return this.protectionStart;
    }

    public DaysAdjustment getStepinDateOffset() {
        return this.stepinDateOffset;
    }

    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Cds other = (Cds)obj;
            return JodaBeanUtils.equal((Object)((Object)this.buySell), (Object)((Object)other.buySell)) && JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.paymentSchedule, (Object)other.paymentSchedule) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.paymentOnDefault), (Object)((Object)other.paymentOnDefault)) && JodaBeanUtils.equal((Object)((Object)this.protectionStart), (Object)((Object)other.protectionStart)) && JodaBeanUtils.equal((Object)this.stepinDateOffset, (Object)other.stepinDateOffset) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.buySell));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.paymentOnDefault));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.protectionStart));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stepinDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(384);
        buf.append("Cds{");
        buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("paymentOnDefault").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentOnDefault))).append(',').append(' ');
        buf.append("protectionStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.protectionStart))).append(',').append(' ');
        buf.append("stepinDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.stepinDateOffset)).append(',').append(' ');
        buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<Cds> {
        private BuySell buySell;
        private StandardId legalEntityId;
        private Currency currency;
        private double notional;
        private PeriodicSchedule paymentSchedule;
        private double fixedRate;
        private DayCount dayCount;
        private PaymentOnDefault paymentOnDefault;
        private ProtectionStartOfDay protectionStart;
        private DaysAdjustment stepinDateOffset;
        private DaysAdjustment settlementDateOffset;

        private Builder() {
            Cds.applyDefaults(this);
        }

        private Builder(Cds beanToCopy) {
            this.buySell = beanToCopy.getBuySell();
            this.legalEntityId = beanToCopy.getLegalEntityId();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.paymentSchedule = beanToCopy.getPaymentSchedule();
            this.fixedRate = beanToCopy.getFixedRate();
            this.dayCount = beanToCopy.getDayCount();
            this.paymentOnDefault = beanToCopy.getPaymentOnDefault();
            this.protectionStart = beanToCopy.getProtectionStart();
            this.stepinDateOffset = beanToCopy.getStepinDateOffset();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -480203780: {
                    return this.paymentOnDefault;
                }
                case 2103482633: {
                    return this.protectionStart;
                }
                case 852621746: {
                    return this.stepinDateOffset;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    this.buySell = (BuySell)((Object)newValue);
                    break;
                }
                case 866287159: {
                    this.legalEntityId = (StandardId)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1499086147: {
                    this.paymentSchedule = (PeriodicSchedule)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -480203780: {
                    this.paymentOnDefault = (PaymentOnDefault)((Object)newValue);
                    break;
                }
                case 2103482633: {
                    this.protectionStart = (ProtectionStartOfDay)((Object)newValue);
                    break;
                }
                case 852621746: {
                    this.stepinDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public Cds build() {
            Cds.preBuild(this);
            return new Cds(this.buySell, this.legalEntityId, this.currency, this.notional, this.paymentSchedule, this.fixedRate, this.dayCount, this.paymentOnDefault, this.protectionStart, this.stepinDateOffset, this.settlementDateOffset);
        }

        public Builder buySell(BuySell buySell) {
            JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
            this.buySell = buySell;
            return this;
        }

        public Builder legalEntityId(StandardId legalEntityId) {
            JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
            this.legalEntityId = legalEntityId;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder paymentSchedule(PeriodicSchedule paymentSchedule) {
            JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
            this.paymentSchedule = paymentSchedule;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            ArgChecker.notNegative((double)fixedRate, (String)"fixedRate");
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder paymentOnDefault(PaymentOnDefault paymentOnDefault) {
            JodaBeanUtils.notNull((Object)((Object)paymentOnDefault), (String)"paymentOnDefault");
            this.paymentOnDefault = paymentOnDefault;
            return this;
        }

        public Builder protectionStart(ProtectionStartOfDay protectionStart) {
            JodaBeanUtils.notNull((Object)((Object)protectionStart), (String)"protectionStart");
            this.protectionStart = protectionStart;
            return this;
        }

        public Builder stepinDateOffset(DaysAdjustment stepinDateOffset) {
            JodaBeanUtils.notNull((Object)stepinDateOffset, (String)"stepinDateOffset");
            this.stepinDateOffset = stepinDateOffset;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(384);
            buf.append("Cds.Builder{");
            buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("paymentOnDefault").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentOnDefault))).append(',').append(' ');
            buf.append("protectionStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.protectionStart))).append(',').append(' ');
            buf.append("stepinDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.stepinDateOffset)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BuySell> buySell = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"buySell", Cds.class, BuySell.class);
        private final MetaProperty<StandardId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", Cds.class, StandardId.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", Cds.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", Cds.class, Double.TYPE);
        private final MetaProperty<PeriodicSchedule> paymentSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentSchedule", Cds.class, PeriodicSchedule.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", Cds.class, Double.TYPE);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", Cds.class, DayCount.class);
        private final MetaProperty<PaymentOnDefault> paymentOnDefault = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentOnDefault", Cds.class, PaymentOnDefault.class);
        private final MetaProperty<ProtectionStartOfDay> protectionStart = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"protectionStart", Cds.class, ProtectionStartOfDay.class);
        private final MetaProperty<DaysAdjustment> stepinDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stepinDateOffset", Cds.class, DaysAdjustment.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", Cds.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"buySell", "legalEntityId", "currency", "notional", "paymentSchedule", "fixedRate", "dayCount", "paymentOnDefault", "protectionStart", "stepinDateOffset", "settlementDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case 866287159: {
                    return this.legalEntityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -480203780: {
                    return this.paymentOnDefault;
                }
                case 2103482633: {
                    return this.protectionStart;
                }
                case 852621746: {
                    return this.stepinDateOffset;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends Cds> beanType() {
            return Cds.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BuySell> buySell() {
            return this.buySell;
        }

        public MetaProperty<StandardId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<PeriodicSchedule> paymentSchedule() {
            return this.paymentSchedule;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<PaymentOnDefault> paymentOnDefault() {
            return this.paymentOnDefault;
        }

        public MetaProperty<ProtectionStartOfDay> protectionStart() {
            return this.protectionStart;
        }

        public MetaProperty<DaysAdjustment> stepinDateOffset() {
            return this.stepinDateOffset;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return ((Cds)bean).getBuySell();
                }
                case 866287159: {
                    return ((Cds)bean).getLegalEntityId();
                }
                case 575402001: {
                    return ((Cds)bean).getCurrency();
                }
                case 1585636160: {
                    return ((Cds)bean).getNotional();
                }
                case -1499086147: {
                    return ((Cds)bean).getPaymentSchedule();
                }
                case 747425396: {
                    return ((Cds)bean).getFixedRate();
                }
                case 1905311443: {
                    return ((Cds)bean).getDayCount();
                }
                case -480203780: {
                    return ((Cds)bean).getPaymentOnDefault();
                }
                case 2103482633: {
                    return ((Cds)bean).getProtectionStart();
                }
                case 852621746: {
                    return ((Cds)bean).getStepinDateOffset();
                }
                case 135924714: {
                    return ((Cds)bean).getSettlementDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

