/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.Trade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.SummarizerUtils;
import com.opengamma.strata.product.credit.CdsQuote;
import com.opengamma.strata.product.credit.CdsTrade;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CdsCalibrationTrade
implements Trade,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CdsTrade underlyingTrade;
    @PropertyDefinition(validate="notNull")
    private final CdsQuote quote;
    private static final long serialVersionUID = 1L;

    public static CdsCalibrationTrade of(CdsTrade trade, CdsQuote quote) {
        return new CdsCalibrationTrade(trade, quote);
    }

    @Override
    public TradeInfo getInfo() {
        return this.underlyingTrade.getInfo();
    }

    @Override
    public CdsCalibrationTrade withInfo(PortfolioItemInfo info) {
        return new CdsCalibrationTrade(this.underlyingTrade.withInfo(info), this.quote);
    }

    @Override
    public PortfolioItemSummary summarize() {
        String description = "CDS calibration trade";
        Currency currency = this.underlyingTrade.getProduct().getCurrency();
        return SummarizerUtils.summary(this, ProductType.CALIBRATION, description, currency);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CdsCalibrationTrade(CdsTrade underlyingTrade, CdsQuote quote) {
        JodaBeanUtils.notNull((Object)underlyingTrade, (String)"underlyingTrade");
        JodaBeanUtils.notNull((Object)quote, (String)"quote");
        this.underlyingTrade = underlyingTrade;
        this.quote = quote;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CdsTrade getUnderlyingTrade() {
        return this.underlyingTrade;
    }

    public CdsQuote getQuote() {
        return this.quote;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CdsCalibrationTrade other = (CdsCalibrationTrade)obj;
            return JodaBeanUtils.equal((Object)this.underlyingTrade, (Object)other.underlyingTrade) && JodaBeanUtils.equal((Object)this.quote, (Object)other.quote);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingTrade);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.quote);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CdsCalibrationTrade{");
        buf.append("underlyingTrade").append('=').append(JodaBeanUtils.toString((Object)this.underlyingTrade)).append(',').append(' ');
        buf.append("quote").append('=').append(JodaBeanUtils.toString((Object)this.quote));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CdsCalibrationTrade> {
        private CdsTrade underlyingTrade;
        private CdsQuote quote;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -823800825: {
                    return this.underlyingTrade;
                }
                case 107953788: {
                    return this.quote;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -823800825: {
                    this.underlyingTrade = (CdsTrade)newValue;
                    break;
                }
                case 107953788: {
                    this.quote = (CdsQuote)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CdsCalibrationTrade build() {
            return new CdsCalibrationTrade(this.underlyingTrade, this.quote);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CdsCalibrationTrade.Builder{");
            buf.append("underlyingTrade").append('=').append(JodaBeanUtils.toString((Object)this.underlyingTrade)).append(',').append(' ');
            buf.append("quote").append('=').append(JodaBeanUtils.toString((Object)this.quote));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CdsTrade> underlyingTrade = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingTrade", CdsCalibrationTrade.class, CdsTrade.class);
        private final MetaProperty<CdsQuote> quote = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quote", CdsCalibrationTrade.class, CdsQuote.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"underlyingTrade", "quote"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -823800825: {
                    return this.underlyingTrade;
                }
                case 107953788: {
                    return this.quote;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CdsCalibrationTrade> builder() {
            return new Builder();
        }

        public Class<? extends CdsCalibrationTrade> beanType() {
            return CdsCalibrationTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CdsTrade> underlyingTrade() {
            return this.underlyingTrade;
        }

        public MetaProperty<CdsQuote> quote() {
            return this.quote;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -823800825: {
                    return ((CdsCalibrationTrade)bean).getUnderlyingTrade();
                }
                case 107953788: {
                    return ((CdsCalibrationTrade)bean).getQuote();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

