/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.credit.CreditCouponPaymentPeriod;
import com.opengamma.strata.product.credit.PaymentOnDefault;
import com.opengamma.strata.product.credit.ProtectionStartOfDay;
import com.opengamma.strata.product.credit.ResolvedCdsIndex;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CdsIndex
implements Product,
Resolvable<ResolvedCdsIndex>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final BuySell buySell;
    @PropertyDefinition(validate="notNull")
    private final StandardId cdsIndexId;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<StandardId> legalEntityIds;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final PeriodicSchedule paymentSchedule;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double fixedRate;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final PaymentOnDefault paymentOnDefault;
    @PropertyDefinition(validate="notNull")
    private final ProtectionStartOfDay protectionStart;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment stepinDateOffset;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment settlementDateOffset;
    private static final long serialVersionUID = 1L;

    public static CdsIndex of(BuySell buySell, StandardId cdsIndexId, List<StandardId> legalEntityIds, Currency currency, double notional, LocalDate startDate, LocalDate endDate, Frequency paymentFrequency, HolidayCalendarId calendar, double fixedRate) {
        PeriodicSchedule accrualSchedule = PeriodicSchedule.builder().businessDayAdjustment(BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)calendar)).startDate(startDate).endDate(endDate).startDateBusinessDayAdjustment(BusinessDayAdjustment.NONE).endDateBusinessDayAdjustment(BusinessDayAdjustment.NONE).frequency(paymentFrequency).rollConvention(RollConventions.NONE).stubConvention(StubConvention.SMART_INITIAL).build();
        return new CdsIndex(buySell, cdsIndexId, legalEntityIds, currency, notional, accrualSchedule, fixedRate, DayCounts.ACT_360, PaymentOnDefault.ACCRUED_PREMIUM, ProtectionStartOfDay.BEGINNING, DaysAdjustment.ofCalendarDays((int)1), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)calendar));
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.dayCount = DayCounts.ACT_360;
        builder.paymentOnDefault = PaymentOnDefault.ACCRUED_PREMIUM;
        builder.protectionStart = ProtectionStartOfDay.BEGINNING;
        builder.stepinDateOffset = DaysAdjustment.ofCalendarDays((int)1);
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        return ImmutableSet.of((Object)this.currency);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.settlementDateOffset == null && builder.paymentSchedule != null) {
            builder.settlementDateOffset = DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)builder.paymentSchedule.getBusinessDayAdjustment().getCalendar());
        }
    }

    public ResolvedCdsIndex resolve(ReferenceData refData) {
        Schedule adjustedSchedule = this.paymentSchedule.createSchedule(refData);
        ImmutableList.Builder accrualPeriods = ImmutableList.builder();
        int nPeriods = adjustedSchedule.size();
        for (int i = 0; i < nPeriods - 1; ++i) {
            SchedulePeriod period = adjustedSchedule.getPeriod(i);
            accrualPeriods.add((Object)CreditCouponPaymentPeriod.builder().startDate(period.getStartDate()).endDate(period.getEndDate()).unadjustedStartDate(period.getUnadjustedStartDate()).unadjustedEndDate(period.getUnadjustedEndDate()).effectiveStartDate(this.protectionStart.isBeginning() ? period.getStartDate().minusDays(1L) : period.getStartDate()).effectiveEndDate(this.protectionStart.isBeginning() ? period.getEndDate().minusDays(1L) : period.getEndDate()).paymentDate(period.getEndDate()).notional(this.notional).currency(this.currency).fixedRate(this.fixedRate).yearFraction(period.yearFraction(this.dayCount, adjustedSchedule)).build());
        }
        SchedulePeriod lastPeriod = adjustedSchedule.getPeriod(nPeriods - 1);
        LocalDate accEndDate = this.protectionStart.isBeginning() ? lastPeriod.getEndDate().plusDays(1L) : lastPeriod.getEndDate();
        SchedulePeriod modifiedPeriod = lastPeriod.toBuilder().endDate(accEndDate).build();
        accrualPeriods.add((Object)CreditCouponPaymentPeriod.builder().startDate(modifiedPeriod.getStartDate()).endDate(modifiedPeriod.getEndDate()).unadjustedStartDate(modifiedPeriod.getUnadjustedStartDate()).unadjustedEndDate(modifiedPeriod.getUnadjustedEndDate()).effectiveStartDate(this.protectionStart.isBeginning() ? lastPeriod.getStartDate().minusDays(1L) : lastPeriod.getStartDate()).effectiveEndDate(lastPeriod.getEndDate()).paymentDate(this.paymentSchedule.getBusinessDayAdjustment().adjust(lastPeriod.getEndDate(), refData)).notional(this.notional).currency(this.currency).fixedRate(this.fixedRate).yearFraction(modifiedPeriod.yearFraction(this.dayCount, adjustedSchedule)).build());
        ImmutableList paymentPeriods = accrualPeriods.build();
        return ResolvedCdsIndex.builder().buySell(this.buySell).cdsIndexId(this.cdsIndexId).legalEntityIds((List<StandardId>)this.legalEntityIds).protectionStart(this.protectionStart).paymentOnDefault(this.paymentOnDefault).paymentPeriods((List<CreditCouponPaymentPeriod>)paymentPeriods).protectionEndDate(lastPeriod.getEndDate()).settlementDateOffset(this.settlementDateOffset).stepinDateOffset(this.stepinDateOffset).dayCount(this.dayCount).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private CdsIndex(BuySell buySell, StandardId cdsIndexId, List<StandardId> legalEntityIds, Currency currency, double notional, PeriodicSchedule paymentSchedule, double fixedRate, DayCount dayCount, PaymentOnDefault paymentOnDefault, ProtectionStartOfDay protectionStart, DaysAdjustment stepinDateOffset, DaysAdjustment settlementDateOffset) {
        JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
        JodaBeanUtils.notNull((Object)cdsIndexId, (String)"cdsIndexId");
        JodaBeanUtils.notNull(legalEntityIds, (String)"legalEntityIds");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
        ArgChecker.notNegative((double)fixedRate, (String)"fixedRate");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)paymentOnDefault), (String)"paymentOnDefault");
        JodaBeanUtils.notNull((Object)((Object)protectionStart), (String)"protectionStart");
        JodaBeanUtils.notNull((Object)stepinDateOffset, (String)"stepinDateOffset");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        this.buySell = buySell;
        this.cdsIndexId = cdsIndexId;
        this.legalEntityIds = ImmutableList.copyOf(legalEntityIds);
        this.currency = currency;
        this.notional = notional;
        this.paymentSchedule = paymentSchedule;
        this.fixedRate = fixedRate;
        this.dayCount = dayCount;
        this.paymentOnDefault = paymentOnDefault;
        this.protectionStart = protectionStart;
        this.stepinDateOffset = stepinDateOffset;
        this.settlementDateOffset = settlementDateOffset;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public BuySell getBuySell() {
        return this.buySell;
    }

    public StandardId getCdsIndexId() {
        return this.cdsIndexId;
    }

    public ImmutableList<StandardId> getLegalEntityIds() {
        return this.legalEntityIds;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public PeriodicSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public PaymentOnDefault getPaymentOnDefault() {
        return this.paymentOnDefault;
    }

    public ProtectionStartOfDay getProtectionStart() {
        return this.protectionStart;
    }

    public DaysAdjustment getStepinDateOffset() {
        return this.stepinDateOffset;
    }

    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CdsIndex other = (CdsIndex)obj;
            return JodaBeanUtils.equal((Object)((Object)this.buySell), (Object)((Object)other.buySell)) && JodaBeanUtils.equal((Object)this.cdsIndexId, (Object)other.cdsIndexId) && JodaBeanUtils.equal(this.legalEntityIds, other.legalEntityIds) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.paymentSchedule, (Object)other.paymentSchedule) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.paymentOnDefault), (Object)((Object)other.paymentOnDefault)) && JodaBeanUtils.equal((Object)((Object)this.protectionStart), (Object)((Object)other.protectionStart)) && JodaBeanUtils.equal((Object)this.stepinDateOffset, (Object)other.stepinDateOffset) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.buySell));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.cdsIndexId);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.legalEntityIds);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentSchedule);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.paymentOnDefault));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.protectionStart));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stepinDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(416);
        buf.append("CdsIndex{");
        buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
        buf.append("cdsIndexId").append('=').append(JodaBeanUtils.toString((Object)this.cdsIndexId)).append(',').append(' ');
        buf.append("legalEntityIds").append('=').append(JodaBeanUtils.toString(this.legalEntityIds)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("paymentOnDefault").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentOnDefault))).append(',').append(' ');
        buf.append("protectionStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.protectionStart))).append(',').append(' ');
        buf.append("stepinDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.stepinDateOffset)).append(',').append(' ');
        buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CdsIndex> {
        private BuySell buySell;
        private StandardId cdsIndexId;
        private List<StandardId> legalEntityIds = ImmutableList.of();
        private Currency currency;
        private double notional;
        private PeriodicSchedule paymentSchedule;
        private double fixedRate;
        private DayCount dayCount;
        private PaymentOnDefault paymentOnDefault;
        private ProtectionStartOfDay protectionStart;
        private DaysAdjustment stepinDateOffset;
        private DaysAdjustment settlementDateOffset;

        private Builder() {
            CdsIndex.applyDefaults(this);
        }

        private Builder(CdsIndex beanToCopy) {
            this.buySell = beanToCopy.getBuySell();
            this.cdsIndexId = beanToCopy.getCdsIndexId();
            this.legalEntityIds = beanToCopy.getLegalEntityIds();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.paymentSchedule = beanToCopy.getPaymentSchedule();
            this.fixedRate = beanToCopy.getFixedRate();
            this.dayCount = beanToCopy.getDayCount();
            this.paymentOnDefault = beanToCopy.getPaymentOnDefault();
            this.protectionStart = beanToCopy.getProtectionStart();
            this.stepinDateOffset = beanToCopy.getStepinDateOffset();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case -464117509: {
                    return this.cdsIndexId;
                }
                case 1085098268: {
                    return this.legalEntityIds;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -480203780: {
                    return this.paymentOnDefault;
                }
                case 2103482633: {
                    return this.protectionStart;
                }
                case 852621746: {
                    return this.stepinDateOffset;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    this.buySell = (BuySell)((Object)newValue);
                    break;
                }
                case -464117509: {
                    this.cdsIndexId = (StandardId)newValue;
                    break;
                }
                case 1085098268: {
                    this.legalEntityIds = (List)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1499086147: {
                    this.paymentSchedule = (PeriodicSchedule)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -480203780: {
                    this.paymentOnDefault = (PaymentOnDefault)((Object)newValue);
                    break;
                }
                case 2103482633: {
                    this.protectionStart = (ProtectionStartOfDay)((Object)newValue);
                    break;
                }
                case 852621746: {
                    this.stepinDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CdsIndex build() {
            CdsIndex.preBuild(this);
            return new CdsIndex(this.buySell, this.cdsIndexId, this.legalEntityIds, this.currency, this.notional, this.paymentSchedule, this.fixedRate, this.dayCount, this.paymentOnDefault, this.protectionStart, this.stepinDateOffset, this.settlementDateOffset);
        }

        public Builder buySell(BuySell buySell) {
            JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
            this.buySell = buySell;
            return this;
        }

        public Builder cdsIndexId(StandardId cdsIndexId) {
            JodaBeanUtils.notNull((Object)cdsIndexId, (String)"cdsIndexId");
            this.cdsIndexId = cdsIndexId;
            return this;
        }

        public Builder legalEntityIds(List<StandardId> legalEntityIds) {
            JodaBeanUtils.notNull(legalEntityIds, (String)"legalEntityIds");
            this.legalEntityIds = legalEntityIds;
            return this;
        }

        public Builder legalEntityIds(StandardId ... legalEntityIds) {
            return this.legalEntityIds((List<StandardId>)ImmutableList.copyOf((Object[])legalEntityIds));
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder paymentSchedule(PeriodicSchedule paymentSchedule) {
            JodaBeanUtils.notNull((Object)paymentSchedule, (String)"paymentSchedule");
            this.paymentSchedule = paymentSchedule;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            ArgChecker.notNegative((double)fixedRate, (String)"fixedRate");
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder paymentOnDefault(PaymentOnDefault paymentOnDefault) {
            JodaBeanUtils.notNull((Object)((Object)paymentOnDefault), (String)"paymentOnDefault");
            this.paymentOnDefault = paymentOnDefault;
            return this;
        }

        public Builder protectionStart(ProtectionStartOfDay protectionStart) {
            JodaBeanUtils.notNull((Object)((Object)protectionStart), (String)"protectionStart");
            this.protectionStart = protectionStart;
            return this;
        }

        public Builder stepinDateOffset(DaysAdjustment stepinDateOffset) {
            JodaBeanUtils.notNull((Object)stepinDateOffset, (String)"stepinDateOffset");
            this.stepinDateOffset = stepinDateOffset;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(416);
            buf.append("CdsIndex.Builder{");
            buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
            buf.append("cdsIndexId").append('=').append(JodaBeanUtils.toString((Object)this.cdsIndexId)).append(',').append(' ');
            buf.append("legalEntityIds").append('=').append(JodaBeanUtils.toString(this.legalEntityIds)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("paymentSchedule").append('=').append(JodaBeanUtils.toString((Object)this.paymentSchedule)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("paymentOnDefault").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentOnDefault))).append(',').append(' ');
            buf.append("protectionStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.protectionStart))).append(',').append(' ');
            buf.append("stepinDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.stepinDateOffset)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BuySell> buySell = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"buySell", CdsIndex.class, BuySell.class);
        private final MetaProperty<StandardId> cdsIndexId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cdsIndexId", CdsIndex.class, StandardId.class);
        private final MetaProperty<ImmutableList<StandardId>> legalEntityIds = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityIds", CdsIndex.class, ImmutableList.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CdsIndex.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", CdsIndex.class, Double.TYPE);
        private final MetaProperty<PeriodicSchedule> paymentSchedule = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentSchedule", CdsIndex.class, PeriodicSchedule.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", CdsIndex.class, Double.TYPE);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", CdsIndex.class, DayCount.class);
        private final MetaProperty<PaymentOnDefault> paymentOnDefault = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentOnDefault", CdsIndex.class, PaymentOnDefault.class);
        private final MetaProperty<ProtectionStartOfDay> protectionStart = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"protectionStart", CdsIndex.class, ProtectionStartOfDay.class);
        private final MetaProperty<DaysAdjustment> stepinDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stepinDateOffset", CdsIndex.class, DaysAdjustment.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", CdsIndex.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"buySell", "cdsIndexId", "legalEntityIds", "currency", "notional", "paymentSchedule", "fixedRate", "dayCount", "paymentOnDefault", "protectionStart", "stepinDateOffset", "settlementDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case -464117509: {
                    return this.cdsIndexId;
                }
                case 1085098268: {
                    return this.legalEntityIds;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1499086147: {
                    return this.paymentSchedule;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -480203780: {
                    return this.paymentOnDefault;
                }
                case 2103482633: {
                    return this.protectionStart;
                }
                case 852621746: {
                    return this.stepinDateOffset;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CdsIndex> beanType() {
            return CdsIndex.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BuySell> buySell() {
            return this.buySell;
        }

        public MetaProperty<StandardId> cdsIndexId() {
            return this.cdsIndexId;
        }

        public MetaProperty<ImmutableList<StandardId>> legalEntityIds() {
            return this.legalEntityIds;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<PeriodicSchedule> paymentSchedule() {
            return this.paymentSchedule;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<PaymentOnDefault> paymentOnDefault() {
            return this.paymentOnDefault;
        }

        public MetaProperty<ProtectionStartOfDay> protectionStart() {
            return this.protectionStart;
        }

        public MetaProperty<DaysAdjustment> stepinDateOffset() {
            return this.stepinDateOffset;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return ((CdsIndex)bean).getBuySell();
                }
                case -464117509: {
                    return ((CdsIndex)bean).getCdsIndexId();
                }
                case 1085098268: {
                    return ((CdsIndex)bean).getLegalEntityIds();
                }
                case 575402001: {
                    return ((CdsIndex)bean).getCurrency();
                }
                case 1585636160: {
                    return ((CdsIndex)bean).getNotional();
                }
                case -1499086147: {
                    return ((CdsIndex)bean).getPaymentSchedule();
                }
                case 747425396: {
                    return ((CdsIndex)bean).getFixedRate();
                }
                case 1905311443: {
                    return ((CdsIndex)bean).getDayCount();
                }
                case -480203780: {
                    return ((CdsIndex)bean).getPaymentOnDefault();
                }
                case 2103482633: {
                    return ((CdsIndex)bean).getProtectionStart();
                }
                case 852621746: {
                    return ((CdsIndex)bean).getStepinDateOffset();
                }
                case 135924714: {
                    return ((CdsIndex)bean).getSettlementDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

