/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.AdjustablePayment;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.ProductTrade;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.ResolvableTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.SummarizerUtils;
import com.opengamma.strata.product.credit.CdsIndex;
import com.opengamma.strata.product.credit.ResolvedCdsIndexTrade;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CdsIndexTrade
implements ProductTrade,
ResolvableTrade<ResolvedCdsIndexTrade>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TradeInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CdsIndex product;
    @PropertyDefinition(get="optional")
    private final AdjustablePayment upfrontFee;
    private static final long serialVersionUID = 1L;

    @Override
    public CdsIndexTrade withInfo(PortfolioItemInfo info) {
        return new CdsIndexTrade(TradeInfo.from(info), this.product, this.upfrontFee);
    }

    @Override
    public PortfolioItemSummary summarize() {
        PeriodicSchedule paymentSchedule = this.product.getPaymentSchedule();
        StringBuilder buf = new StringBuilder(96);
        buf.append(SummarizerUtils.datePeriod(paymentSchedule.getStartDate(), paymentSchedule.getEndDate()));
        buf.append(' ');
        buf.append((Object)this.product.getBuySell());
        buf.append(' ');
        buf.append(SummarizerUtils.amount(this.product.getCurrency(), this.product.getNotional()));
        buf.append(' ');
        buf.append(this.product.getCdsIndexId().getValue());
        buf.append(" / ");
        buf.append(SummarizerUtils.percent(this.product.getFixedRate()));
        buf.append(" : ");
        buf.append(SummarizerUtils.dateRange(paymentSchedule.getStartDate(), paymentSchedule.getEndDate()));
        return SummarizerUtils.summary(this, ProductType.CDS_INDEX, buf.toString(), this.product.getCurrency());
    }

    @Override
    public ResolvedCdsIndexTrade resolve(ReferenceData refData) {
        return ResolvedCdsIndexTrade.builder().info(this.info).product(this.product.resolve(refData)).upfrontFee(this.upfrontFee != null ? this.upfrontFee.resolve(refData) : null).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private CdsIndexTrade(TradeInfo info, CdsIndex product, AdjustablePayment upfrontFee) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        this.info = info;
        this.product = product;
        this.upfrontFee = upfrontFee;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public TradeInfo getInfo() {
        return this.info;
    }

    @Override
    public CdsIndex getProduct() {
        return this.product;
    }

    public Optional<AdjustablePayment> getUpfrontFee() {
        return Optional.ofNullable(this.upfrontFee);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CdsIndexTrade other = (CdsIndexTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product) && JodaBeanUtils.equal((Object)this.upfrontFee, (Object)other.upfrontFee);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.upfrontFee);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("CdsIndexTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
        buf.append("upfrontFee").append('=').append(JodaBeanUtils.toString((Object)this.upfrontFee));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CdsIndexTrade> {
        private TradeInfo info;
        private CdsIndex product;
        private AdjustablePayment upfrontFee;

        private Builder() {
        }

        private Builder(CdsIndexTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
            this.upfrontFee = beanToCopy.upfrontFee;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case 963468344: {
                    return this.upfrontFee;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (TradeInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (CdsIndex)newValue;
                    break;
                }
                case 963468344: {
                    this.upfrontFee = (AdjustablePayment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CdsIndexTrade build() {
            return new CdsIndexTrade(this.info, this.product, this.upfrontFee);
        }

        public Builder info(TradeInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(CdsIndex product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public Builder upfrontFee(AdjustablePayment upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("CdsIndexTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
            buf.append("upfrontFee").append('=').append(JodaBeanUtils.toString((Object)this.upfrontFee));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<TradeInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", CdsIndexTrade.class, TradeInfo.class);
        private final MetaProperty<CdsIndex> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", CdsIndexTrade.class, CdsIndex.class);
        private final MetaProperty<AdjustablePayment> upfrontFee = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"upfrontFee", CdsIndexTrade.class, AdjustablePayment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product", "upfrontFee"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case 963468344: {
                    return this.upfrontFee;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CdsIndexTrade> beanType() {
            return CdsIndexTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<TradeInfo> info() {
            return this.info;
        }

        public MetaProperty<CdsIndex> product() {
            return this.product;
        }

        public MetaProperty<AdjustablePayment> upfrontFee() {
            return this.upfrontFee;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((CdsIndexTrade)bean).getInfo();
                }
                case -309474065: {
                    return ((CdsIndexTrade)bean).getProduct();
                }
                case 963468344: {
                    return ((CdsIndexTrade)bean).upfrontFee;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

