/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CreditCouponPaymentPeriod
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedEndDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate effectiveStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate effectiveEndDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate paymentDate;
    @PropertyDefinition
    private final double fixedRate;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double yearFraction;
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.unadjustedStartDate == null) {
            builder.unadjustedStartDate = builder.startDate;
        }
        if (builder.unadjustedEndDate == null) {
            builder.unadjustedEndDate = builder.endDate;
        }
    }

    boolean contains(LocalDate date) {
        return !date.isBefore(this.startDate) && date.isBefore(this.endDate);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private CreditCouponPaymentPeriod(Currency currency, double notional, LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate, LocalDate effectiveStartDate, LocalDate effectiveEndDate, LocalDate paymentDate, double fixedRate, double yearFraction) {
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegative((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
        JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
        JodaBeanUtils.notNull((Object)effectiveStartDate, (String)"effectiveStartDate");
        JodaBeanUtils.notNull((Object)effectiveEndDate, (String)"effectiveEndDate");
        JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
        ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
        this.currency = currency;
        this.notional = notional;
        this.startDate = startDate;
        this.endDate = endDate;
        this.unadjustedStartDate = unadjustedStartDate;
        this.unadjustedEndDate = unadjustedEndDate;
        this.effectiveStartDate = effectiveStartDate;
        this.effectiveEndDate = effectiveEndDate;
        this.paymentDate = paymentDate;
        this.fixedRate = fixedRate;
        this.yearFraction = yearFraction;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalDate getUnadjustedStartDate() {
        return this.unadjustedStartDate;
    }

    public LocalDate getUnadjustedEndDate() {
        return this.unadjustedEndDate;
    }

    public LocalDate getEffectiveStartDate() {
        return this.effectiveStartDate;
    }

    public LocalDate getEffectiveEndDate() {
        return this.effectiveEndDate;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CreditCouponPaymentPeriod other = (CreditCouponPaymentPeriod)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.unadjustedStartDate, (Object)other.unadjustedStartDate) && JodaBeanUtils.equal((Object)this.unadjustedEndDate, (Object)other.unadjustedEndDate) && JodaBeanUtils.equal((Object)this.effectiveStartDate, (Object)other.effectiveStartDate) && JodaBeanUtils.equal((Object)this.effectiveEndDate, (Object)other.effectiveEndDate) && JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.effectiveStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.effectiveEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(384);
        buf.append("CreditCouponPaymentPeriod{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
        buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
        buf.append("effectiveStartDate").append('=').append(JodaBeanUtils.toString((Object)this.effectiveStartDate)).append(',').append(' ');
        buf.append("effectiveEndDate").append('=').append(JodaBeanUtils.toString((Object)this.effectiveEndDate)).append(',').append(' ');
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CreditCouponPaymentPeriod> {
        private Currency currency;
        private double notional;
        private LocalDate startDate;
        private LocalDate endDate;
        private LocalDate unadjustedStartDate;
        private LocalDate unadjustedEndDate;
        private LocalDate effectiveStartDate;
        private LocalDate effectiveEndDate;
        private LocalDate paymentDate;
        private double fixedRate;
        private double yearFraction;

        private Builder() {
        }

        private Builder(CreditCouponPaymentPeriod beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.unadjustedStartDate = beanToCopy.getUnadjustedStartDate();
            this.unadjustedEndDate = beanToCopy.getUnadjustedEndDate();
            this.effectiveStartDate = beanToCopy.getEffectiveStartDate();
            this.effectiveEndDate = beanToCopy.getEffectiveEndDate();
            this.paymentDate = beanToCopy.getPaymentDate();
            this.fixedRate = beanToCopy.getFixedRate();
            this.yearFraction = beanToCopy.getYearFraction();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -1815017143: {
                    return this.effectiveStartDate;
                }
                case -566060158: {
                    return this.effectiveEndDate;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 1457691881: {
                    this.unadjustedStartDate = (LocalDate)newValue;
                    break;
                }
                case 31758114: {
                    this.unadjustedEndDate = (LocalDate)newValue;
                    break;
                }
                case -1815017143: {
                    this.effectiveStartDate = (LocalDate)newValue;
                    break;
                }
                case -566060158: {
                    this.effectiveEndDate = (LocalDate)newValue;
                    break;
                }
                case -1540873516: {
                    this.paymentDate = (LocalDate)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CreditCouponPaymentPeriod build() {
            CreditCouponPaymentPeriod.preBuild(this);
            return new CreditCouponPaymentPeriod(this.currency, this.notional, this.startDate, this.endDate, this.unadjustedStartDate, this.unadjustedEndDate, this.effectiveStartDate, this.effectiveEndDate, this.paymentDate, this.fixedRate, this.yearFraction);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegative((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder unadjustedStartDate(LocalDate unadjustedStartDate) {
            JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
            this.unadjustedStartDate = unadjustedStartDate;
            return this;
        }

        public Builder unadjustedEndDate(LocalDate unadjustedEndDate) {
            JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
            this.unadjustedEndDate = unadjustedEndDate;
            return this;
        }

        public Builder effectiveStartDate(LocalDate effectiveStartDate) {
            JodaBeanUtils.notNull((Object)effectiveStartDate, (String)"effectiveStartDate");
            this.effectiveStartDate = effectiveStartDate;
            return this;
        }

        public Builder effectiveEndDate(LocalDate effectiveEndDate) {
            JodaBeanUtils.notNull((Object)effectiveEndDate, (String)"effectiveEndDate");
            this.effectiveEndDate = effectiveEndDate;
            return this;
        }

        public Builder paymentDate(LocalDate paymentDate) {
            JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
            this.paymentDate = paymentDate;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder yearFraction(double yearFraction) {
            ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
            this.yearFraction = yearFraction;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(384);
            buf.append("CreditCouponPaymentPeriod.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
            buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate)).append(',').append(' ');
            buf.append("effectiveStartDate").append('=').append(JodaBeanUtils.toString((Object)this.effectiveStartDate)).append(',').append(' ');
            buf.append("effectiveEndDate").append('=').append(JodaBeanUtils.toString((Object)this.effectiveEndDate)).append(',').append(' ');
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CreditCouponPaymentPeriod.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", CreditCouponPaymentPeriod.class, Double.TYPE);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", CreditCouponPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", CreditCouponPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedStartDate", CreditCouponPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedEndDate", CreditCouponPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> effectiveStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"effectiveStartDate", CreditCouponPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> effectiveEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"effectiveEndDate", CreditCouponPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", CreditCouponPaymentPeriod.class, LocalDate.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", CreditCouponPaymentPeriod.class, Double.TYPE);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", CreditCouponPaymentPeriod.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "notional", "startDate", "endDate", "unadjustedStartDate", "unadjustedEndDate", "effectiveStartDate", "effectiveEndDate", "paymentDate", "fixedRate", "yearFraction"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
                case -1815017143: {
                    return this.effectiveStartDate;
                }
                case -566060158: {
                    return this.effectiveEndDate;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CreditCouponPaymentPeriod> beanType() {
            return CreditCouponPaymentPeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<LocalDate> unadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        public MetaProperty<LocalDate> unadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        public MetaProperty<LocalDate> effectiveStartDate() {
            return this.effectiveStartDate;
        }

        public MetaProperty<LocalDate> effectiveEndDate() {
            return this.effectiveEndDate;
        }

        public MetaProperty<LocalDate> paymentDate() {
            return this.paymentDate;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((CreditCouponPaymentPeriod)bean).getCurrency();
                }
                case 1585636160: {
                    return ((CreditCouponPaymentPeriod)bean).getNotional();
                }
                case -2129778896: {
                    return ((CreditCouponPaymentPeriod)bean).getStartDate();
                }
                case -1607727319: {
                    return ((CreditCouponPaymentPeriod)bean).getEndDate();
                }
                case 1457691881: {
                    return ((CreditCouponPaymentPeriod)bean).getUnadjustedStartDate();
                }
                case 31758114: {
                    return ((CreditCouponPaymentPeriod)bean).getUnadjustedEndDate();
                }
                case -1815017143: {
                    return ((CreditCouponPaymentPeriod)bean).getEffectiveStartDate();
                }
                case -566060158: {
                    return ((CreditCouponPaymentPeriod)bean).getEffectiveEndDate();
                }
                case -1540873516: {
                    return ((CreditCouponPaymentPeriod)bean).getPaymentDate();
                }
                case 747425396: {
                    return ((CreditCouponPaymentPeriod)bean).getFixedRate();
                }
                case -1731780257: {
                    return ((CreditCouponPaymentPeriod)bean).getYearFraction();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

