/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.credit.CreditCouponPaymentPeriod;
import com.opengamma.strata.product.credit.PaymentOnDefault;
import com.opengamma.strata.product.credit.ProtectionStartOfDay;
import com.opengamma.strata.product.credit.ResolvedCds;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedCdsIndex
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final BuySell buySell;
    @PropertyDefinition(validate="notNull")
    private final StandardId cdsIndexId;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<StandardId> legalEntityIds;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<CreditCouponPaymentPeriod> paymentPeriods;
    @PropertyDefinition(validate="notNull")
    private final LocalDate protectionEndDate;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final PaymentOnDefault paymentOnDefault;
    @PropertyDefinition(validate="notNull")
    private final ProtectionStartOfDay protectionStart;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment stepinDateOffset;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment settlementDateOffset;
    private static final long serialVersionUID = 1L;

    public LocalDate getAccrualStartDate() {
        return ((CreditCouponPaymentPeriod)this.paymentPeriods.get(0)).getStartDate();
    }

    public LocalDate getAccrualEndDate() {
        return ((CreditCouponPaymentPeriod)this.paymentPeriods.get(this.paymentPeriods.size() - 1)).getEndDate();
    }

    public double getNotional() {
        return ((CreditCouponPaymentPeriod)this.paymentPeriods.get(0)).getNotional();
    }

    public Currency getCurrency() {
        return ((CreditCouponPaymentPeriod)this.paymentPeriods.get(0)).getCurrency();
    }

    public double getFixedRate() {
        return ((CreditCouponPaymentPeriod)this.paymentPeriods.get(0)).getFixedRate();
    }

    public LocalDate calculateEffectiveStartDate(LocalDate stepinDate) {
        LocalDate startDate = stepinDate.isAfter(this.getAccrualStartDate()) ? stepinDate : this.getAccrualStartDate();
        return this.protectionStart.isBeginning() ? startDate.minusDays(1L) : startDate;
    }

    public LocalDate calculateSettlementDateFromValuation(LocalDate valuationDate, ReferenceData refData) {
        return this.settlementDateOffset.adjust(valuationDate, refData);
    }

    public Optional<CreditCouponPaymentPeriod> findPeriod(LocalDate date) {
        return this.paymentPeriods.stream().filter(p -> p.contains(date)).reduce(Guavate.ensureOnlyOne());
    }

    public double accruedYearFraction(LocalDate stepinDate) {
        if (stepinDate.isBefore(this.getAccrualStartDate())) {
            return 0.0;
        }
        if (stepinDate.isEqual(this.getAccrualEndDate())) {
            return ((CreditCouponPaymentPeriod)this.paymentPeriods.get(this.paymentPeriods.size() - 1)).getYearFraction();
        }
        CreditCouponPaymentPeriod period = this.findPeriod(stepinDate).orElseThrow(() -> new IllegalArgumentException("Date outside range"));
        return this.dayCount.relativeYearFraction(period.getStartDate(), stepinDate);
    }

    public ResolvedCds toSingleNameCds() {
        return ResolvedCds.builder().buySell(this.getBuySell()).dayCount(this.getDayCount()).legalEntityId(this.getCdsIndexId()).paymentOnDefault(this.getPaymentOnDefault()).paymentPeriods((List<CreditCouponPaymentPeriod>)this.getPaymentPeriods()).protectionEndDate(this.getProtectionEndDate()).protectionStart(this.getProtectionStart()).stepinDateOffset(this.getStepinDateOffset()).settlementDateOffset(this.getSettlementDateOffset()).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResolvedCdsIndex(BuySell buySell, StandardId cdsIndexId, List<StandardId> legalEntityIds, List<CreditCouponPaymentPeriod> paymentPeriods, LocalDate protectionEndDate, DayCount dayCount, PaymentOnDefault paymentOnDefault, ProtectionStartOfDay protectionStart, DaysAdjustment stepinDateOffset, DaysAdjustment settlementDateOffset) {
        JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
        JodaBeanUtils.notNull((Object)cdsIndexId, (String)"cdsIndexId");
        JodaBeanUtils.notNull(legalEntityIds, (String)"legalEntityIds");
        JodaBeanUtils.notEmpty(paymentPeriods, (String)"paymentPeriods");
        JodaBeanUtils.notNull((Object)protectionEndDate, (String)"protectionEndDate");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)paymentOnDefault), (String)"paymentOnDefault");
        JodaBeanUtils.notNull((Object)((Object)protectionStart), (String)"protectionStart");
        JodaBeanUtils.notNull((Object)stepinDateOffset, (String)"stepinDateOffset");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        this.buySell = buySell;
        this.cdsIndexId = cdsIndexId;
        this.legalEntityIds = ImmutableList.copyOf(legalEntityIds);
        this.paymentPeriods = ImmutableList.copyOf(paymentPeriods);
        this.protectionEndDate = protectionEndDate;
        this.dayCount = dayCount;
        this.paymentOnDefault = paymentOnDefault;
        this.protectionStart = protectionStart;
        this.stepinDateOffset = stepinDateOffset;
        this.settlementDateOffset = settlementDateOffset;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public BuySell getBuySell() {
        return this.buySell;
    }

    public StandardId getCdsIndexId() {
        return this.cdsIndexId;
    }

    public ImmutableList<StandardId> getLegalEntityIds() {
        return this.legalEntityIds;
    }

    public ImmutableList<CreditCouponPaymentPeriod> getPaymentPeriods() {
        return this.paymentPeriods;
    }

    public LocalDate getProtectionEndDate() {
        return this.protectionEndDate;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public PaymentOnDefault getPaymentOnDefault() {
        return this.paymentOnDefault;
    }

    public ProtectionStartOfDay getProtectionStart() {
        return this.protectionStart;
    }

    public DaysAdjustment getStepinDateOffset() {
        return this.stepinDateOffset;
    }

    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedCdsIndex other = (ResolvedCdsIndex)obj;
            return JodaBeanUtils.equal((Object)((Object)this.buySell), (Object)((Object)other.buySell)) && JodaBeanUtils.equal((Object)this.cdsIndexId, (Object)other.cdsIndexId) && JodaBeanUtils.equal(this.legalEntityIds, other.legalEntityIds) && JodaBeanUtils.equal(this.paymentPeriods, other.paymentPeriods) && JodaBeanUtils.equal((Object)this.protectionEndDate, (Object)other.protectionEndDate) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.paymentOnDefault), (Object)((Object)other.paymentOnDefault)) && JodaBeanUtils.equal((Object)((Object)this.protectionStart), (Object)((Object)other.protectionStart)) && JodaBeanUtils.equal((Object)this.stepinDateOffset, (Object)other.stepinDateOffset) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.buySell));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.cdsIndexId);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.legalEntityIds);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.paymentPeriods);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.protectionEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.paymentOnDefault));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.protectionStart));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stepinDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("ResolvedCdsIndex{");
        buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
        buf.append("cdsIndexId").append('=').append(JodaBeanUtils.toString((Object)this.cdsIndexId)).append(',').append(' ');
        buf.append("legalEntityIds").append('=').append(JodaBeanUtils.toString(this.legalEntityIds)).append(',').append(' ');
        buf.append("paymentPeriods").append('=').append(JodaBeanUtils.toString(this.paymentPeriods)).append(',').append(' ');
        buf.append("protectionEndDate").append('=').append(JodaBeanUtils.toString((Object)this.protectionEndDate)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("paymentOnDefault").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentOnDefault))).append(',').append(' ');
        buf.append("protectionStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.protectionStart))).append(',').append(' ');
        buf.append("stepinDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.stepinDateOffset)).append(',').append(' ');
        buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedCdsIndex> {
        private BuySell buySell;
        private StandardId cdsIndexId;
        private List<StandardId> legalEntityIds = ImmutableList.of();
        private List<CreditCouponPaymentPeriod> paymentPeriods = ImmutableList.of();
        private LocalDate protectionEndDate;
        private DayCount dayCount;
        private PaymentOnDefault paymentOnDefault;
        private ProtectionStartOfDay protectionStart;
        private DaysAdjustment stepinDateOffset;
        private DaysAdjustment settlementDateOffset;

        private Builder() {
        }

        private Builder(ResolvedCdsIndex beanToCopy) {
            this.buySell = beanToCopy.getBuySell();
            this.cdsIndexId = beanToCopy.getCdsIndexId();
            this.legalEntityIds = beanToCopy.getLegalEntityIds();
            this.paymentPeriods = beanToCopy.getPaymentPeriods();
            this.protectionEndDate = beanToCopy.getProtectionEndDate();
            this.dayCount = beanToCopy.getDayCount();
            this.paymentOnDefault = beanToCopy.getPaymentOnDefault();
            this.protectionStart = beanToCopy.getProtectionStart();
            this.stepinDateOffset = beanToCopy.getStepinDateOffset();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case -464117509: {
                    return this.cdsIndexId;
                }
                case 1085098268: {
                    return this.legalEntityIds;
                }
                case -1674414612: {
                    return this.paymentPeriods;
                }
                case -1193325040: {
                    return this.protectionEndDate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -480203780: {
                    return this.paymentOnDefault;
                }
                case 2103482633: {
                    return this.protectionStart;
                }
                case 852621746: {
                    return this.stepinDateOffset;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    this.buySell = (BuySell)((Object)newValue);
                    break;
                }
                case -464117509: {
                    this.cdsIndexId = (StandardId)newValue;
                    break;
                }
                case 1085098268: {
                    this.legalEntityIds = (List)newValue;
                    break;
                }
                case -1674414612: {
                    this.paymentPeriods = (List)newValue;
                    break;
                }
                case -1193325040: {
                    this.protectionEndDate = (LocalDate)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -480203780: {
                    this.paymentOnDefault = (PaymentOnDefault)((Object)newValue);
                    break;
                }
                case 2103482633: {
                    this.protectionStart = (ProtectionStartOfDay)((Object)newValue);
                    break;
                }
                case 852621746: {
                    this.stepinDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedCdsIndex build() {
            return new ResolvedCdsIndex(this.buySell, this.cdsIndexId, this.legalEntityIds, this.paymentPeriods, this.protectionEndDate, this.dayCount, this.paymentOnDefault, this.protectionStart, this.stepinDateOffset, this.settlementDateOffset);
        }

        public Builder buySell(BuySell buySell) {
            JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
            this.buySell = buySell;
            return this;
        }

        public Builder cdsIndexId(StandardId cdsIndexId) {
            JodaBeanUtils.notNull((Object)cdsIndexId, (String)"cdsIndexId");
            this.cdsIndexId = cdsIndexId;
            return this;
        }

        public Builder legalEntityIds(List<StandardId> legalEntityIds) {
            JodaBeanUtils.notNull(legalEntityIds, (String)"legalEntityIds");
            this.legalEntityIds = legalEntityIds;
            return this;
        }

        public Builder legalEntityIds(StandardId ... legalEntityIds) {
            return this.legalEntityIds((List<StandardId>)ImmutableList.copyOf((Object[])legalEntityIds));
        }

        public Builder paymentPeriods(List<CreditCouponPaymentPeriod> paymentPeriods) {
            JodaBeanUtils.notEmpty(paymentPeriods, (String)"paymentPeriods");
            this.paymentPeriods = paymentPeriods;
            return this;
        }

        public Builder paymentPeriods(CreditCouponPaymentPeriod ... paymentPeriods) {
            return this.paymentPeriods((List<CreditCouponPaymentPeriod>)ImmutableList.copyOf((Object[])paymentPeriods));
        }

        public Builder protectionEndDate(LocalDate protectionEndDate) {
            JodaBeanUtils.notNull((Object)protectionEndDate, (String)"protectionEndDate");
            this.protectionEndDate = protectionEndDate;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder paymentOnDefault(PaymentOnDefault paymentOnDefault) {
            JodaBeanUtils.notNull((Object)((Object)paymentOnDefault), (String)"paymentOnDefault");
            this.paymentOnDefault = paymentOnDefault;
            return this;
        }

        public Builder protectionStart(ProtectionStartOfDay protectionStart) {
            JodaBeanUtils.notNull((Object)((Object)protectionStart), (String)"protectionStart");
            this.protectionStart = protectionStart;
            return this;
        }

        public Builder stepinDateOffset(DaysAdjustment stepinDateOffset) {
            JodaBeanUtils.notNull((Object)stepinDateOffset, (String)"stepinDateOffset");
            this.stepinDateOffset = stepinDateOffset;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("ResolvedCdsIndex.Builder{");
            buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
            buf.append("cdsIndexId").append('=').append(JodaBeanUtils.toString((Object)this.cdsIndexId)).append(',').append(' ');
            buf.append("legalEntityIds").append('=').append(JodaBeanUtils.toString(this.legalEntityIds)).append(',').append(' ');
            buf.append("paymentPeriods").append('=').append(JodaBeanUtils.toString(this.paymentPeriods)).append(',').append(' ');
            buf.append("protectionEndDate").append('=').append(JodaBeanUtils.toString((Object)this.protectionEndDate)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("paymentOnDefault").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentOnDefault))).append(',').append(' ');
            buf.append("protectionStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.protectionStart))).append(',').append(' ');
            buf.append("stepinDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.stepinDateOffset)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BuySell> buySell = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"buySell", ResolvedCdsIndex.class, BuySell.class);
        private final MetaProperty<StandardId> cdsIndexId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cdsIndexId", ResolvedCdsIndex.class, StandardId.class);
        private final MetaProperty<ImmutableList<StandardId>> legalEntityIds = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityIds", ResolvedCdsIndex.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<CreditCouponPaymentPeriod>> paymentPeriods = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentPeriods", ResolvedCdsIndex.class, ImmutableList.class);
        private final MetaProperty<LocalDate> protectionEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"protectionEndDate", ResolvedCdsIndex.class, LocalDate.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ResolvedCdsIndex.class, DayCount.class);
        private final MetaProperty<PaymentOnDefault> paymentOnDefault = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentOnDefault", ResolvedCdsIndex.class, PaymentOnDefault.class);
        private final MetaProperty<ProtectionStartOfDay> protectionStart = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"protectionStart", ResolvedCdsIndex.class, ProtectionStartOfDay.class);
        private final MetaProperty<DaysAdjustment> stepinDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stepinDateOffset", ResolvedCdsIndex.class, DaysAdjustment.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", ResolvedCdsIndex.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"buySell", "cdsIndexId", "legalEntityIds", "paymentPeriods", "protectionEndDate", "dayCount", "paymentOnDefault", "protectionStart", "stepinDateOffset", "settlementDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case -464117509: {
                    return this.cdsIndexId;
                }
                case 1085098268: {
                    return this.legalEntityIds;
                }
                case -1674414612: {
                    return this.paymentPeriods;
                }
                case -1193325040: {
                    return this.protectionEndDate;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -480203780: {
                    return this.paymentOnDefault;
                }
                case 2103482633: {
                    return this.protectionStart;
                }
                case 852621746: {
                    return this.stepinDateOffset;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedCdsIndex> beanType() {
            return ResolvedCdsIndex.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BuySell> buySell() {
            return this.buySell;
        }

        public MetaProperty<StandardId> cdsIndexId() {
            return this.cdsIndexId;
        }

        public MetaProperty<ImmutableList<StandardId>> legalEntityIds() {
            return this.legalEntityIds;
        }

        public MetaProperty<ImmutableList<CreditCouponPaymentPeriod>> paymentPeriods() {
            return this.paymentPeriods;
        }

        public MetaProperty<LocalDate> protectionEndDate() {
            return this.protectionEndDate;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<PaymentOnDefault> paymentOnDefault() {
            return this.paymentOnDefault;
        }

        public MetaProperty<ProtectionStartOfDay> protectionStart() {
            return this.protectionStart;
        }

        public MetaProperty<DaysAdjustment> stepinDateOffset() {
            return this.stepinDateOffset;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return ((ResolvedCdsIndex)bean).getBuySell();
                }
                case -464117509: {
                    return ((ResolvedCdsIndex)bean).getCdsIndexId();
                }
                case 1085098268: {
                    return ((ResolvedCdsIndex)bean).getLegalEntityIds();
                }
                case -1674414612: {
                    return ((ResolvedCdsIndex)bean).getPaymentPeriods();
                }
                case -1193325040: {
                    return ((ResolvedCdsIndex)bean).getProtectionEndDate();
                }
                case 1905311443: {
                    return ((ResolvedCdsIndex)bean).getDayCount();
                }
                case -480203780: {
                    return ((ResolvedCdsIndex)bean).getPaymentOnDefault();
                }
                case 2103482633: {
                    return ((ResolvedCdsIndex)bean).getProtectionStart();
                }
                case 852621746: {
                    return ((ResolvedCdsIndex)bean).getStepinDateOffset();
                }
                case 135924714: {
                    return ((ResolvedCdsIndex)bean).getSettlementDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

