/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit;

import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.credit.ResolvedCdsIndex;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedCdsIndexTrade
implements ResolvedTrade,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TradeInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ResolvedCdsIndex product;
    @PropertyDefinition(get="optional")
    private final Payment upfrontFee;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    public ResolvedCdsTrade toSingleNameCds() {
        return ResolvedCdsTrade.builder().product(this.product.toSingleNameCds()).info(this.info).upfrontFee(this.upfrontFee).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResolvedCdsIndexTrade(TradeInfo info, ResolvedCdsIndex product, Payment upfrontFee) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        this.info = info;
        this.product = product;
        this.upfrontFee = upfrontFee;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public TradeInfo getInfo() {
        return this.info;
    }

    @Override
    public ResolvedCdsIndex getProduct() {
        return this.product;
    }

    public Optional<Payment> getUpfrontFee() {
        return Optional.ofNullable(this.upfrontFee);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedCdsIndexTrade other = (ResolvedCdsIndexTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product) && JodaBeanUtils.equal((Object)this.upfrontFee, (Object)other.upfrontFee);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.upfrontFee);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ResolvedCdsIndexTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
        buf.append("upfrontFee").append('=').append(JodaBeanUtils.toString((Object)this.upfrontFee));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedCdsIndexTrade> {
        private TradeInfo info;
        private ResolvedCdsIndex product;
        private Payment upfrontFee;

        private Builder() {
            ResolvedCdsIndexTrade.applyDefaults(this);
        }

        private Builder(ResolvedCdsIndexTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
            this.upfrontFee = beanToCopy.upfrontFee;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case 963468344: {
                    return this.upfrontFee;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (TradeInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (ResolvedCdsIndex)newValue;
                    break;
                }
                case 963468344: {
                    this.upfrontFee = (Payment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedCdsIndexTrade build() {
            return new ResolvedCdsIndexTrade(this.info, this.product, this.upfrontFee);
        }

        public Builder info(TradeInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(ResolvedCdsIndex product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public Builder upfrontFee(Payment upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ResolvedCdsIndexTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
            buf.append("upfrontFee").append('=').append(JodaBeanUtils.toString((Object)this.upfrontFee));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<TradeInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", ResolvedCdsIndexTrade.class, TradeInfo.class);
        private final MetaProperty<ResolvedCdsIndex> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", ResolvedCdsIndexTrade.class, ResolvedCdsIndex.class);
        private final MetaProperty<Payment> upfrontFee = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"upfrontFee", ResolvedCdsIndexTrade.class, Payment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product", "upfrontFee"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case 963468344: {
                    return this.upfrontFee;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedCdsIndexTrade> beanType() {
            return ResolvedCdsIndexTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<TradeInfo> info() {
            return this.info;
        }

        public MetaProperty<ResolvedCdsIndex> product() {
            return this.product;
        }

        public MetaProperty<Payment> upfrontFee() {
            return this.upfrontFee;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((ResolvedCdsIndexTrade)bean).getInfo();
                }
                case -309474065: {
                    return ((ResolvedCdsIndexTrade)bean).getProduct();
                }
                case 963468344: {
                    return ((ResolvedCdsIndexTrade)bean).upfrontFee;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

