/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.AdjustablePayment;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.TradeConvention;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.credit.CdsTrade;
import com.opengamma.strata.product.credit.type.CdsConventions;
import com.opengamma.strata.product.credit.type.CdsImmDateLogic;
import java.time.LocalDate;
import java.time.temporal.TemporalAmount;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface CdsConvention
extends TradeConvention,
Named {
    @FromString
    public static CdsConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (CdsConvention)CdsConvention.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<CdsConvention> extendedEnum() {
        return CdsConventions.ENUM_LOOKUP;
    }

    public DaysAdjustment getSettlementDateOffset();

    public Currency getCurrency();

    default public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, Tenor tenor, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        LocalDate startDate = CdsImmDateLogic.getPreviousImmDate(tradeDate);
        LocalDate roll = CdsImmDateLogic.getNextSemiAnnualRollDate(tradeDate);
        LocalDate endDate = roll.plus((TemporalAmount)tenor).minusMonths(3L);
        return this.createTrade(legalEntityId, tradeDate, startDate, endDate, buySell, notional, fixedRate, refData);
    }

    default public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, LocalDate startDate, Tenor tenor, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        LocalDate roll = CdsImmDateLogic.getNextSemiAnnualRollDate(startDate);
        LocalDate endDate = roll.plus((TemporalAmount)tenor).minusMonths(3L);
        return this.createTrade(legalEntityId, tradeDate, startDate, endDate, buySell, notional, fixedRate, refData);
    }

    default public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        LocalDate settlementDate = this.getSettlementDateOffset().adjust(tradeDate, refData);
        TradeInfo tradeInfo = TradeInfo.builder().tradeDate(tradeDate).settlementDate(settlementDate).build();
        return this.toTrade(legalEntityId, tradeInfo, startDate, endDate, buySell, notional, fixedRate);
    }

    public CdsTrade toTrade(StandardId var1, TradeInfo var2, LocalDate var3, LocalDate var4, BuySell var5, double var6, double var8);

    default public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, Tenor tenor, BuySell buySell, double notional, double fixedRate, AdjustablePayment upFrontFee, ReferenceData refData) {
        LocalDate startDate = CdsImmDateLogic.getPreviousImmDate(tradeDate);
        LocalDate roll = CdsImmDateLogic.getNextSemiAnnualRollDate(tradeDate);
        LocalDate endDate = roll.plus((TemporalAmount)tenor).minusMonths(3L);
        return this.createTrade(legalEntityId, tradeDate, startDate, endDate, buySell, notional, fixedRate, upFrontFee, refData);
    }

    default public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, LocalDate startDate, Tenor tenor, BuySell buySell, double notional, double fixedRate, AdjustablePayment upFrontFee, ReferenceData refData) {
        LocalDate roll = CdsImmDateLogic.getNextSemiAnnualRollDate(startDate);
        LocalDate endDate = roll.plus((TemporalAmount)tenor).minusMonths(3L);
        return this.createTrade(legalEntityId, tradeDate, startDate, endDate, buySell, notional, fixedRate, upFrontFee, refData);
    }

    default public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRate, AdjustablePayment upFrontFee, ReferenceData refData) {
        LocalDate settlementDate = this.getSettlementDateOffset().adjust(tradeDate, refData);
        TradeInfo tradeInfo = TradeInfo.builder().tradeDate(tradeDate).settlementDate(settlementDate).build();
        return this.toTrade(legalEntityId, tradeInfo, startDate, endDate, buySell, notional, fixedRate, upFrontFee);
    }

    public CdsTrade toTrade(StandardId var1, TradeInfo var2, LocalDate var3, LocalDate var4, BuySell var5, double var6, double var8, AdjustablePayment var10);

    @ToString
    public String getName();
}

