/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit.type;

import com.opengamma.strata.collect.array.IntArray;
import java.time.LocalDate;

final class CdsImmDateLogic {
    private static final int IMM_DAY = 20;
    private static final IntArray IMM_MONTHS = IntArray.of((int)3, (int)6, (int)9, (int)12);
    private static final IntArray INDEX_ROLL_MONTHS = IntArray.of((int)3, (int)9);

    static boolean isSemiAnnualRollDate(LocalDate date) {
        if (date.getDayOfMonth() != 20) {
            return false;
        }
        int month = date.getMonthValue();
        return month == INDEX_ROLL_MONTHS.get(0) || month == INDEX_ROLL_MONTHS.get(1);
    }

    static LocalDate getPreviousImmDate(LocalDate date) {
        int day = date.getDayOfMonth();
        int month = date.getMonthValue();
        int year = date.getYear();
        if (month % 3 == 0) {
            if (day > 20) {
                return LocalDate.of(year, month, 20);
            }
            if (month != 3) {
                return LocalDate.of(year, month - 3, 20);
            }
            return LocalDate.of(year - 1, IMM_MONTHS.get(3), 20);
        }
        int i = month / 3;
        if (i == 0) {
            return LocalDate.of(year - 1, IMM_MONTHS.get(3), 20);
        }
        return LocalDate.of(year, IMM_MONTHS.get(i - 1), 20);
    }

    static LocalDate getNextSemiAnnualRollDate(LocalDate date) {
        int day = date.getDayOfMonth();
        int month = date.getMonthValue();
        int year = date.getYear();
        if (CdsImmDateLogic.isSemiAnnualRollDate(date)) {
            if (month == INDEX_ROLL_MONTHS.get(0)) {
                return LocalDate.of(year, INDEX_ROLL_MONTHS.get(1), 20);
            }
            return LocalDate.of(year + 1, INDEX_ROLL_MONTHS.get(0), 20);
        }
        if (month < INDEX_ROLL_MONTHS.get(0)) {
            return LocalDate.of(year, INDEX_ROLL_MONTHS.get(0), 20);
        }
        if (month == INDEX_ROLL_MONTHS.get(0)) {
            if (day < 20) {
                return LocalDate.of(year, month, 20);
            }
            return LocalDate.of(year, INDEX_ROLL_MONTHS.get(1), 20);
        }
        if (month < INDEX_ROLL_MONTHS.get(1)) {
            return LocalDate.of(year, INDEX_ROLL_MONTHS.get(1), 20);
        }
        if (month == INDEX_ROLL_MONTHS.get(1)) {
            if (day < 20) {
                return LocalDate.of(year, month, 20);
            }
            return LocalDate.of(year + 1, INDEX_ROLL_MONTHS.get(0), 20);
        }
        return LocalDate.of(year + 1, INDEX_ROLL_MONTHS.get(0), 20);
    }

    private CdsImmDateLogic() {
    }
}

